#ifndef ACE_EVENT_HANDLER_HANDLE_TIMEOUT_UPCALL_H
#define ACE_EVENT_HANDLER_HANDLE_TIMEOUT_UPCALL_H

#include /**/ "ace/pre.h"

/**
 * @file Event_Handler_Handle_Timeout_Upcall.h
 *
 * @author Carlos O'Ryan <coryan@atdesk.com>
 *
 * Based on classes and files developed by Doug Schmidt, Darrell
 * Brunsch, Irfan Pyarali and a cast of thousands.
 */

#include "ace/Timer_Queuefwd.h"

ACE_BEGIN_VERSIONED_NAMESPACE_DECL

class ACE_Time_Value;

/**
 * @class ACE_Event_Handler_Handle_Timeout_Upcall
 *
 * @brief Functor for Timer_Queues.
 *
 * This class implements the functor required by the Timer
 * Queue to call <handle_timeout> on ACE_Event_Handlers.
 */
class ACE_Export ACE_Event_Handler_Handle_Timeout_Upcall
{
public:
  ACE_Event_Handler_Handle_Timeout_Upcall () = default;

  /// Destructor.
  ~ACE_Event_Handler_Handle_Timeout_Upcall () = default;

  /// This method is called when a timer is registered.
  int registration (ACE_Timer_Queue &timer_queue,
                    ACE_Event_Handler *handler,
                    const void *arg);

  /// This method is called before the timer expires.
  int preinvoke (ACE_Timer_Queue &timer_queue,
                 ACE_Event_Handler *handler,
                 const void *arg,
                 int recurring_timer,
                 const ACE_Time_Value &cur_time,
                 const void *&upcall_act);

  /// This method is called when the timer expires.
  int timeout (ACE_Timer_Queue &timer_queue,
               ACE_Event_Handler *handler,
               const void *arg,
               int recurring_timer,
               const ACE_Time_Value &cur_time);

  /// This method is called after the timer expires.
  int postinvoke (ACE_Timer_Queue &timer_queue,
                  ACE_Event_Handler *handler,
                  const void *arg,
                  int recurring_timer,
                  const ACE_Time_Value &cur_time,
                  const void *upcall_act);

  /// This method is called when a handler is cancelled
  int cancel_type (ACE_Timer_Queue &timer_queue,
                   ACE_Event_Handler *handler,
                   int dont_call,
                   int &requires_reference_counting);

  /// This method is called when a timer is cancelled
  int cancel_timer (ACE_Timer_Queue &timer_queue,
                    ACE_Event_Handler *handler,
                    int dont_call,
                    int requires_reference_counting);

  /// This method is called when the timer queue is destroyed and
  /// the timer is still contained in it
  int deletion (ACE_Timer_Queue &timer_queue,
                ACE_Event_Handler *handler,
                const void *arg);

  /// Declare the dynamic allocation hooks.
  ACE_ALLOC_HOOK_DECLARE;

private:
  ACE_Event_Handler_Handle_Timeout_Upcall (const ACE_Event_Handler_Handle_Timeout_Upcall &) = delete;
  ACE_Event_Handler_Handle_Timeout_Upcall (ACE_Event_Handler_Handle_Timeout_Upcall &&) = delete;
  ACE_Event_Handler_Handle_Timeout_Upcall &operator= (const ACE_Event_Handler_Handle_Timeout_Upcall &) = delete;
  ACE_Event_Handler_Handle_Timeout_Upcall &operator= (ACE_Event_Handler_Handle_Timeout_Upcall &&) = delete;

  /// Flag indicating that reference counting is required for this
  /// event handler upcall.
  int requires_reference_counting_ {0};
};

ACE_END_VERSIONED_NAMESPACE_DECL

#if defined(__ACE_INLINE__)
# include "ace/Event_Handler_Handle_Timeout_Upcall.inl"
#endif /* __ACE_INLINE__ */

#include /**/ "ace/post.h"
#endif /* ACE_EVENT_HANDLER_HANDLE_TIMEOUT_UPCALL_H */
