/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * SPDX-License-Identifier: curl
 *
 ***************************************************************************/
#include "first.h"

/* Test CURLINFO_PROTOCOL */

static CURLcode test_lib1535(const char *URL)
{
  CURL *curl, *dupe = NULL;
  long protocol;
  CURLcode res = CURLE_OK;

  global_init(CURL_GLOBAL_ALL);

  easy_init(curl);

  /* Test that protocol is properly initialized on curl_easy_init.
   */

  res = curl_easy_getinfo(curl, CURLINFO_PROTOCOL, &protocol);

  if(res) {
    curl_mfprintf(stderr,
                  "%s:%d curl_easy_getinfo() failed with code %d (%s)\n",
                  __FILE__, __LINE__, res, curl_easy_strerror(res));
    goto test_cleanup;
  }
  if(protocol) {
    curl_mfprintf(stderr,
                  "%s:%d protocol init failed; expected 0 but is %ld\n",
                  __FILE__, __LINE__, protocol);
    res = CURLE_FAILED_INIT;
    goto test_cleanup;
  }

  easy_setopt(curl, CURLOPT_URL, URL);

  res = curl_easy_perform(curl);
  if(res) {
    curl_mfprintf(stderr,
                  "%s:%d curl_easy_perform() failed with code %d (%s)\n",
                  __FILE__, __LINE__, res, curl_easy_strerror(res));
    goto test_cleanup;
  }

  /* Test that a protocol is properly set after receiving an HTTP resource.
   */

  res = curl_easy_getinfo(curl, CURLINFO_PROTOCOL, &protocol);

  if(res) {
    curl_mfprintf(stderr,
                  "%s:%d curl_easy_getinfo() failed with code %d (%s)\n",
                  __FILE__, __LINE__, res, curl_easy_strerror(res));
    goto test_cleanup;
  }
  if(protocol != CURLPROTO_HTTP) {
    curl_mfprintf(stderr,
                  "%s:%d protocol of http resource is incorrect; "
                  "expected %ld but is %ld\n",
                  __FILE__, __LINE__, CURLPROTO_HTTP, protocol);
    res = CURLE_HTTP_RETURNED_ERROR;
    goto test_cleanup;
  }

  /* Test that a protocol is properly initialized on curl_easy_duphandle.
   */

  dupe = curl_easy_duphandle(curl);
  if(!dupe) {
    curl_mfprintf(stderr, "%s:%d curl_easy_duphandle() failed\n",
                  __FILE__, __LINE__);
    res = CURLE_FAILED_INIT;
    goto test_cleanup;
  }

  res = curl_easy_getinfo(dupe, CURLINFO_PROTOCOL, &protocol);

  if(res) {
    curl_mfprintf(stderr,
                  "%s:%d curl_easy_getinfo() failed with code %d (%s)\n",
                  __FILE__, __LINE__, res, curl_easy_strerror(res));
    goto test_cleanup;
  }
  if(protocol) {
    curl_mfprintf(stderr,
                  "%s:%d protocol init failed; expected 0 but is %ld\n",
                  __FILE__, __LINE__, protocol);
    res = CURLE_FAILED_INIT;
    goto test_cleanup;
  }

  /* Test that a protocol is properly initialized on curl_easy_reset.
   */

  curl_easy_reset(curl);

  res = curl_easy_getinfo(curl, CURLINFO_PROTOCOL, &protocol);

  if(res) {
    curl_mfprintf(stderr,
                  "%s:%d curl_easy_getinfo() failed with code %d (%s)\n",
                  __FILE__, __LINE__, res, curl_easy_strerror(res));
    goto test_cleanup;
  }
  if(protocol) {
    curl_mfprintf(stderr,
                  "%s:%d protocol init failed; expected 0 but is %ld\n",
                  __FILE__, __LINE__, protocol);
    res = CURLE_FAILED_INIT;
    goto test_cleanup;
  }

test_cleanup:
  curl_easy_cleanup(curl);
  curl_easy_cleanup(dupe);
  curl_global_cleanup();
  return res;
}
