from fileinput import filename
from typing import TextIO

class TestCase:
    def __init__(
        self,
        filename: str,
        *,
        # The JUnit schema has `classname` as mandatory
        classname: str,
        allow_multiple_subelements: bool,
        elapsed_sec: float,
    ) -> None: ...
    def add_failure_info(
        self,
        *,
        message: str,
        output: str,
    ) -> None: ...

class TestSuite:
    def __init__(
        self,
        name: str,
        *,
        test_cases: list[TestCase],
        timestamp: str,
    ) -> None: ...

def to_xml_report_file(
    fd: TextIO,
    test_suites: list[TestSuite],
    *,
    encoding: str,
) -> None: ...
