"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GaspTableIo = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
const variance_1 = require("@ot-builder/variance");
exports.GaspTableIo = {
    read(view) {
        const version = view.uint16();
        errors_1.Assert.VersionSupported(`GaspTable`, version, 0, 1);
        const numRanges = view.uint16();
        const ranges = view.array(numRanges, GapsRange);
        return new ot_metadata_1.Gasp.Table(ranges);
    },
    write(frag, table) {
        errors_1.Assert.NoGap(`GaspTable::ranges`, table.ranges);
        frag.uint16(1).uint16(table.ranges.length);
        frag.array(GapsRange, table.ranges);
    }
};
const GapsRange = {
    read(view) {
        const rangeMaxPPEM = view.uint16();
        const rangeGaspBehavior = view.uint16();
        return new ot_metadata_1.Gasp.Range(rangeMaxPPEM, rangeGaspBehavior);
    },
    write(frag, range) {
        frag.uint16(variance_1.OtVar.Ops.originOf(range.maxPPEM));
        frag.uint16(range.behavior);
    }
};
//# sourceMappingURL=index.js.map