import { GeneralGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { Tag } from "@ot-builder/primitive";
export declare class TableT<G, X> {
    horizontal: Data.Maybe<AxisTableT<G, X>>;
    vertical: Data.Maybe<AxisTableT<G, X>>;
}
export declare class AxisTableT<G, X> {
    baselineTags: Data.Maybe<Array<Tag>>;
    scripts: Map<Tag, ScriptT<G, X>>;
}
export declare class ScriptT<G, X> {
    baseValues: Data.Maybe<BaseValuesT<G, X>>;
    defaultMinMax: Data.Maybe<MinMaxTableT<G, X>>;
    baseLangSysRecords: Data.Maybe<Map<Tag, MinMaxTableT<G, X>>>;
}
export declare class BaseValuesT<G, X> {
    defaultBaselineIndex: number;
    baseValues: Map<Tag, CoordT<G, X>>;
    constructor(defaultBaselineIndex?: number, baseValues?: Map<Tag, CoordT<G, X>>);
}
export declare class MinMaxTableT<G, X> {
    defaultMinMax: MinMaxValueT<G, X>;
    featMinMax: Map<Tag, MinMaxValueT<G, X>>;
    constructor(defaultMinMax: MinMaxValueT<G, X>, featMinMax: Map<Tag, MinMaxValueT<G, X>>);
}
export interface CoordT<G, X> {
    readonly at: X;
    readonly pointAttachment?: Data.Maybe<GeneralGlyph.GlyphPointIDRefT<G>>;
    readonly deviceDeltas?: Data.Maybe<ReadonlyArray<number>>;
}
export interface MinMaxValueT<G, X> {
    readonly minCoord: Data.Maybe<CoordT<G, X>>;
    readonly maxCoord: Data.Maybe<CoordT<G, X>>;
}
//# sourceMappingURL=general.d.ts.map