dnl @synopsis AC_C_CLIP_MODE
dnl
dnl Determine the clipping mode when converting float to int.
dnl @version 1.0        May 17 2003
dnl @author Erik de Castro Lopo <erikd AT mega-nerd DOT com>
dnl
dnl Permission to use, copy, modify, distribute, and sell this file for any
dnl purpose is hereby granted without fee, provided that the above copyright
dnl and this permission notice appear in all copies.  No representations are
dnl made about the suitability of this software for any purpose.  It is
dnl provided "as is" without express or implied warranty.

dnl Find the clipping mode in the following way:
dnl    1) If we are not cross compiling test it.
dnl    2) IF we are cross compiling, assume that clipping isn't done correctly.

AC_DEFUN([AC_C_CLIP_MODE],
[AC_CACHE_CHECK(processor clipping capabilities,
        ac_cv_c_clip_type,

# Initialize to unknown
ac_cv_c_clip_positive=unknown
ac_cv_c_clip_negative=unknown

if test $ac_cv_c_clip_positive = unknown ; then
        AC_RUN_IFELSE(
        [AC_LANG_SOURCE([[
        #define _ISOC9X_SOURCE  1
        #define _ISOC99_SOURCE  1
        #define __USE_ISOC99    1
        #define __USE_ISOC9X    1
        #include <math.h>
        int main (void)
        {       double  fval ;
                int k, ival ;

                fval = 1.0 * 0x7FFFFFFF ;
                for (k = 0 ; k < 100 ; k++)
                {       ival = (lrint (fval)) >> 24 ;
                        if (ival != 127)
                                return 1 ;

                        fval *= 1.2499999 ;
                        } ;

                        return 0 ;
                }
                ]])],
                ac_cv_c_clip_positive=yes,
                ac_cv_c_clip_positive=no,
                ac_cv_c_clip_positive=unknown
                )

        AC_RUN_IFELSE(
        [AC_LANG_SOURCE([[
        #define _ISOC9X_SOURCE  1
        #define _ISOC99_SOURCE  1
        #define __USE_ISOC99    1
        #define __USE_ISOC9X    1
        #include <math.h>
        int main (void)
        {       double  fval ;
                int k, ival ;

                fval = -8.0 * 0x10000000 ;
                for (k = 0 ; k < 100 ; k++)
                {       ival = (lrint (fval)) >> 24 ;
                        if (ival != -128)
                                return 1 ;

                        fval *= 1.2499999 ;
                        } ;

                        return 0 ;
                }
                ]])],
                ac_cv_c_clip_negative=yes,
                ac_cv_c_clip_negative=no,
                ac_cv_c_clip_negative=unknown
                )

        fi

if test $ac_cv_c_clip_positive = yes ; then
        ac_cv_c_clip_positive=1
else
        ac_cv_c_clip_positive=0
        fi

if test $ac_cv_c_clip_negative = yes ; then
        ac_cv_c_clip_negative=1
else
        ac_cv_c_clip_negative=0
        fi

[[
case "$ac_cv_c_clip_positive$ac_cv_c_clip_negative" in
        "00")
                ac_cv_c_clip_type="none"
                ;;
        "10")
                ac_cv_c_clip_type="positive"
                ;;
        "01")
                ac_cv_c_clip_type="negative"
                ;;
        "11")
                ac_cv_c_clip_type="both"
                ;;
        esac
        ]]

)
]

)# AC_C_CLIP_MODE
