//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AccessReviewInstanceContactedReviewersServer is a fake server for instances of the armauthorization.AccessReviewInstanceContactedReviewersClient type.
type AccessReviewInstanceContactedReviewersServer struct {
	// NewListPager is the fake for method AccessReviewInstanceContactedReviewersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scheduleDefinitionID string, id string, options *armauthorization.AccessReviewInstanceContactedReviewersClientListOptions) (resp azfake.PagerResponder[armauthorization.AccessReviewInstanceContactedReviewersClientListResponse])
}

// NewAccessReviewInstanceContactedReviewersServerTransport creates a new instance of AccessReviewInstanceContactedReviewersServerTransport with the provided implementation.
// The returned AccessReviewInstanceContactedReviewersServerTransport instance is connected to an instance of armauthorization.AccessReviewInstanceContactedReviewersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessReviewInstanceContactedReviewersServerTransport(srv *AccessReviewInstanceContactedReviewersServer) *AccessReviewInstanceContactedReviewersServerTransport {
	return &AccessReviewInstanceContactedReviewersServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.AccessReviewInstanceContactedReviewersClientListResponse]](),
	}
}

// AccessReviewInstanceContactedReviewersServerTransport connects instances of armauthorization.AccessReviewInstanceContactedReviewersClient to instances of AccessReviewInstanceContactedReviewersServer.
// Don't use this type directly, use NewAccessReviewInstanceContactedReviewersServerTransport instead.
type AccessReviewInstanceContactedReviewersServerTransport struct {
	srv          *AccessReviewInstanceContactedReviewersServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.AccessReviewInstanceContactedReviewersClientListResponse]]
}

// Do implements the policy.Transporter interface for AccessReviewInstanceContactedReviewersServerTransport.
func (a *AccessReviewInstanceContactedReviewersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessReviewInstanceContactedReviewersClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessReviewInstanceContactedReviewersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/contactedReviewers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
		if err != nil {
			return nil, err
		}
		idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(scheduleDefinitionIDParam, idParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.AccessReviewInstanceContactedReviewersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
