//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armbillingbenefits.ClientFactory type.
type ServerFactory struct {
	OperationsServer            OperationsServer
	RPServer                    RPServer
	ReservationOrderAliasServer ReservationOrderAliasServer
	SavingsPlanServer           SavingsPlanServer
	SavingsPlanOrderAliasServer SavingsPlanOrderAliasServer
	SavingsPlanOrderServer      SavingsPlanOrderServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armbillingbenefits.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armbillingbenefits.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                           *ServerFactory
	trMu                          sync.Mutex
	trOperationsServer            *OperationsServerTransport
	trRPServer                    *RPServerTransport
	trReservationOrderAliasServer *ReservationOrderAliasServerTransport
	trSavingsPlanServer           *SavingsPlanServerTransport
	trSavingsPlanOrderAliasServer *SavingsPlanOrderAliasServerTransport
	trSavingsPlanOrderServer      *SavingsPlanOrderServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "RPClient":
		initServer(s, &s.trRPServer, func() *RPServerTransport { return NewRPServerTransport(&s.srv.RPServer) })
		resp, err = s.trRPServer.Do(req)
	case "ReservationOrderAliasClient":
		initServer(s, &s.trReservationOrderAliasServer, func() *ReservationOrderAliasServerTransport {
			return NewReservationOrderAliasServerTransport(&s.srv.ReservationOrderAliasServer)
		})
		resp, err = s.trReservationOrderAliasServer.Do(req)
	case "SavingsPlanClient":
		initServer(s, &s.trSavingsPlanServer, func() *SavingsPlanServerTransport { return NewSavingsPlanServerTransport(&s.srv.SavingsPlanServer) })
		resp, err = s.trSavingsPlanServer.Do(req)
	case "SavingsPlanOrderAliasClient":
		initServer(s, &s.trSavingsPlanOrderAliasServer, func() *SavingsPlanOrderAliasServerTransport {
			return NewSavingsPlanOrderAliasServerTransport(&s.srv.SavingsPlanOrderAliasServer)
		})
		resp, err = s.trSavingsPlanOrderAliasServer.Do(req)
	case "SavingsPlanOrderClient":
		initServer(s, &s.trSavingsPlanOrderServer, func() *SavingsPlanOrderServerTransport {
			return NewSavingsPlanOrderServerTransport(&s.srv.SavingsPlanOrderServer)
		})
		resp, err = s.trSavingsPlanOrderServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
