//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcdn_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/LogAnalytics_GetLogAnalyticsMetrics.json
func ExampleLogAnalyticsClient_GetLogAnalyticsMetrics() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogAnalyticsClient().GetLogAnalyticsMetrics(ctx, "RG", "profile1", []armcdn.LogMetric{
		armcdn.LogMetricClientRequestCount}, func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:30:00.000Z"); return t }(), func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T05:00:00.000Z"); return t }(), armcdn.LogMetricsGranularityPT5M, []string{
		"customdomain1.azurecdn.net",
		"customdomain2.azurecdn.net"}, []string{
		"https"}, &armcdn.LogAnalyticsClientGetLogAnalyticsMetricsOptions{GroupBy: []armcdn.LogMetricsGroupBy{
		armcdn.LogMetricsGroupByProtocol},
		Continents:       []string{},
		CountryOrRegions: []string{},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricsResponse = armcdn.MetricsResponse{
	// 	DateTimeBegin: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:30:27.554Z"); return t}()),
	// 	DateTimeEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T05:00:27.554Z"); return t}()),
	// 	Granularity: to.Ptr(armcdn.MetricsGranularityPT5M),
	// 	Series: []*armcdn.MetricsResponseSeriesItem{
	// 		{
	// 			Data: []*armcdn.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems{
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:35:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](4250),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:40:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](3120),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:45:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](2221),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:50:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](2466),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T04:55:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](2654),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T05:00:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](3565),
	// 			}},
	// 			Groups: []*armcdn.MetricsResponseSeriesPropertiesItemsItem{
	// 				{
	// 					Name: to.Ptr("protocol"),
	// 					Value: to.Ptr("https"),
	// 			}},
	// 			Metric: to.Ptr("clientRequestCount"),
	// 			Unit: to.Ptr(armcdn.MetricsSeriesUnitCount),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/LogAnalytics_GetLogAnalyticsRankings.json
func ExampleLogAnalyticsClient_GetLogAnalyticsRankings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogAnalyticsClient().GetLogAnalyticsRankings(ctx, "RG", "profile1", []armcdn.LogRanking{
		armcdn.LogRankingURL}, []armcdn.LogRankingMetric{
		armcdn.LogRankingMetricClientRequestCount}, 5, func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T06:49:27.554Z"); return t }(), func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:49:27.554Z"); return t }(), &armcdn.LogAnalyticsClientGetLogAnalyticsRankingsOptions{CustomDomains: []string{}})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RankingsResponse = armcdn.RankingsResponse{
	// 	DateTimeBegin: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T06:49:27.554Z"); return t}()),
	// 	DateTimeEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:49:27.554Z"); return t}()),
	// 	Tables: []*armcdn.RankingsResponseTablesItem{
	// 		{
	// 			Data: []*armcdn.RankingsResponseTablesPropertiesItemsItem{
	// 				{
	// 					Name: to.Ptr("https://testdomain.com/favicon.png"),
	// 					Metrics: []*armcdn.RankingsResponseTablesPropertiesItemsMetricsItem{
	// 						{
	// 							Metric: to.Ptr("clientRequestCount"),
	// 							Percentage: to.Ptr[float32](8.28133862733976),
	// 							Value: to.Ptr[int64](2336),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("https://testdomain.com/js/app.js"),
	// 					Metrics: []*armcdn.RankingsResponseTablesPropertiesItemsMetricsItem{
	// 						{
	// 							Metric: to.Ptr("clientRequestCount"),
	// 							Percentage: to.Ptr[float32](7.586500283607488),
	// 							Value: to.Ptr[int64](2140),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("https://testdomain.com/js/lang/en.js"),
	// 					Metrics: []*armcdn.RankingsResponseTablesPropertiesItemsMetricsItem{
	// 						{
	// 							Metric: to.Ptr("clientRequestCount"),
	// 							Percentage: to.Ptr[float32](5.445263754963131),
	// 							Value: to.Ptr[int64](1536),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("https://testdomain.com/js/lib.js"),
	// 					Metrics: []*armcdn.RankingsResponseTablesPropertiesItemsMetricsItem{
	// 						{
	// 							Metric: to.Ptr("clientRequestCount"),
	// 							Percentage: to.Ptr[float32](5.246738513896767),
	// 							Value: to.Ptr[int64](1480),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("https://cdn.exam.net/css/lib.css"),
	// 					Metrics: []*armcdn.RankingsResponseTablesPropertiesItemsMetricsItem{
	// 						{
	// 							Metric: to.Ptr("clientRequestCount"),
	// 							Percentage: to.Ptr[float32](5.147475893363584),
	// 							Value: to.Ptr[int64](1452),
	// 					}},
	// 			}},
	// 			Ranking: to.Ptr("url"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/LogAnalytics_GetLogAnalyticsLocations.json
func ExampleLogAnalyticsClient_GetLogAnalyticsLocations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogAnalyticsClient().GetLogAnalyticsLocations(ctx, "RG", "profile1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContinentsResponse = armcdn.ContinentsResponse{
	// 	Continents: []*armcdn.ContinentsResponseContinentsItem{
	// 		{
	// 			ID: to.Ptr("africa"),
	// 		},
	// 		{
	// 			ID: to.Ptr("antarctica"),
	// 		},
	// 		{
	// 			ID: to.Ptr("asia"),
	// 		},
	// 		{
	// 			ID: to.Ptr("europe"),
	// 		},
	// 		{
	// 			ID: to.Ptr("northAmerica"),
	// 		},
	// 		{
	// 			ID: to.Ptr("oceania"),
	// 		},
	// 		{
	// 			ID: to.Ptr("southAmerica"),
	// 	}},
	// 	CountryOrRegions: []*armcdn.ContinentsResponseCountryOrRegionsItem{
	// 		{
	// 			ContinentID: to.Ptr("africa"),
	// 			ID: to.Ptr("dz"),
	// 		},
	// 		{
	// 			ContinentID: to.Ptr("africa"),
	// 			ID: to.Ptr("ao"),
	// 		},
	// 		{
	// 			ContinentID: to.Ptr("africa"),
	// 			ID: to.Ptr("bw"),
	// 		},
	// 		{
	// 			ContinentID: to.Ptr("africa"),
	// 			ID: to.Ptr("bi"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/LogAnalytics_GetLogAnalyticsResources.json
func ExampleLogAnalyticsClient_GetLogAnalyticsResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogAnalyticsClient().GetLogAnalyticsResources(ctx, "RG", "profile1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourcesResponse = armcdn.ResourcesResponse{
	// 	CustomDomains: []*armcdn.ResourcesResponseCustomDomainsItem{
	// 		{
	// 			Name: to.Ptr("customdomain1.azurecdn.net"),
	// 			History: to.Ptr(true),
	// 			ID: to.Ptr("customdomain1.azurecdn.net"),
	// 		},
	// 		{
	// 			Name: to.Ptr("customdomain2.azurecdn.net"),
	// 			History: to.Ptr(true),
	// 			ID: to.Ptr("customdomain2.azurecdn.net"),
	// 		},
	// 		{
	// 			Name: to.Ptr("customdomain3.azurecdn.net"),
	// 			History: to.Ptr(true),
	// 			ID: to.Ptr("customdomain3.azurecdn.net"),
	// 	}},
	// 	Endpoints: []*armcdn.ResourcesResponseEndpointsItem{
	// 		{
	// 			Name: to.Ptr("endpoint1.azureedge.net"),
	// 			CustomDomains: []*armcdn.ResourcesResponseEndpointsPropertiesItemsItem{
	// 				{
	// 					Name: to.Ptr("customdomain1.azurecdn.net"),
	// 					EndpointID: to.Ptr("enbdpiont1"),
	// 					History: to.Ptr(true),
	// 					ID: to.Ptr("customdomain1.azurecdn.net"),
	// 				},
	// 				{
	// 					Name: to.Ptr("customdomain2.azurecdn.net"),
	// 					History: to.Ptr(true),
	// 					ID: to.Ptr("customdomain2.azurecdn.net"),
	// 			}},
	// 			History: to.Ptr(false),
	// 			ID: to.Ptr("endpoint1"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/LogAnalytics_GetWafLogAnalyticsMetrics.json
func ExampleLogAnalyticsClient_GetWafLogAnalyticsMetrics() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogAnalyticsClient().GetWafLogAnalyticsMetrics(ctx, "RG", "profile1", []armcdn.WafMetric{
		armcdn.WafMetricClientRequestCount}, func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T06:49:27.554Z"); return t }(), func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:49:27.554Z"); return t }(), armcdn.WafGranularityPT5M, &armcdn.LogAnalyticsClientGetWafLogAnalyticsMetricsOptions{Actions: []armcdn.WafAction{
		armcdn.WafActionBlock,
		armcdn.WafActionLog},
		GroupBy:   []armcdn.WafRankingGroupBy{},
		RuleTypes: []armcdn.WafRuleType{},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WafMetricsResponse = armcdn.WafMetricsResponse{
	// 	DateTimeBegin: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T06:30:27.554Z"); return t}()),
	// 	DateTimeEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:00:27.554Z"); return t}()),
	// 	Granularity: to.Ptr(armcdn.WafMetricsGranularityPT5M),
	// 	Series: []*armcdn.WafMetricsResponseSeriesItem{
	// 		{
	// 			Data: []*armcdn.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems{
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:05:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](2),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:10:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](32),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:15:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](31),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:20:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](63),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:25:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](50),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:30:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](12),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:35:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](8),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:40:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](21),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:45:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](30),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:50:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](18),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T07:55:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](28),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:00:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](3),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:05:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](58),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:10:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](42),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:15:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](17),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:20:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](21),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:25:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](41),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:30:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](8),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:35:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](15),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:40:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](25),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:45:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](13),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:50:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](17),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T08:55:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](29),
	// 				},
	// 				{
	// 					DateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:00:00.000Z"); return t}()),
	// 					Value: to.Ptr[float32](17),
	// 			}},
	// 			Groups: []*armcdn.WafMetricsResponseSeriesPropertiesItemsItem{
	// 			},
	// 			Metric: to.Ptr("clientRequestCount"),
	// 			Unit: to.Ptr(armcdn.WafMetricsSeriesUnitCount),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/LogAnalytics_GetWafLogAnalyticsRankings.json
func ExampleLogAnalyticsClient_GetWafLogAnalyticsRankings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogAnalyticsClient().GetWafLogAnalyticsRankings(ctx, "RG", "profile1", []armcdn.WafMetric{
		armcdn.WafMetricClientRequestCount}, func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T06:49:27.554Z"); return t }(), func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:49:27.554Z"); return t }(), 5, []armcdn.WafRankingType{
		armcdn.WafRankingTypeRuleID}, &armcdn.LogAnalyticsClientGetWafLogAnalyticsRankingsOptions{Actions: []armcdn.WafAction{},
		RuleTypes: []armcdn.WafRuleType{},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WafRankingsResponse = armcdn.WafRankingsResponse{
	// 	Data: []*armcdn.WafRankingsResponseDataItem{
	// 		{
	// 			GroupValues: []*string{
	// 				to.Ptr("BlockRateLimit")},
	// 				Metrics: []*armcdn.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems{
	// 					{
	// 						Metric: to.Ptr("clientRequestCount"),
	// 						Percentage: to.Ptr[float64](0),
	// 						Value: to.Ptr[int64](1268),
	// 				}},
	// 		}},
	// 		DateTimeBegin: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T06:49:27.554Z"); return t}()),
	// 		DateTimeEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-04T09:49:27.554Z"); return t}()),
	// 		Groups: []*string{
	// 			to.Ptr("ruleId")},
	// 		}
}
