//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// BalancesServer is a fake server for instances of the armconsumption.BalancesClient type.
type BalancesServer struct {
	// GetByBillingAccount is the fake for method BalancesClient.GetByBillingAccount
	// HTTP status codes to indicate success: http.StatusOK
	GetByBillingAccount func(ctx context.Context, billingAccountID string, options *armconsumption.BalancesClientGetByBillingAccountOptions) (resp azfake.Responder[armconsumption.BalancesClientGetByBillingAccountResponse], errResp azfake.ErrorResponder)

	// GetForBillingPeriodByBillingAccount is the fake for method BalancesClient.GetForBillingPeriodByBillingAccount
	// HTTP status codes to indicate success: http.StatusOK
	GetForBillingPeriodByBillingAccount func(ctx context.Context, billingAccountID string, billingPeriodName string, options *armconsumption.BalancesClientGetForBillingPeriodByBillingAccountOptions) (resp azfake.Responder[armconsumption.BalancesClientGetForBillingPeriodByBillingAccountResponse], errResp azfake.ErrorResponder)
}

// NewBalancesServerTransport creates a new instance of BalancesServerTransport with the provided implementation.
// The returned BalancesServerTransport instance is connected to an instance of armconsumption.BalancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBalancesServerTransport(srv *BalancesServer) *BalancesServerTransport {
	return &BalancesServerTransport{srv: srv}
}

// BalancesServerTransport connects instances of armconsumption.BalancesClient to instances of BalancesServer.
// Don't use this type directly, use NewBalancesServerTransport instead.
type BalancesServerTransport struct {
	srv *BalancesServer
}

// Do implements the policy.Transporter interface for BalancesServerTransport.
func (b *BalancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BalancesClient.GetByBillingAccount":
		resp, err = b.dispatchGetByBillingAccount(req)
	case "BalancesClient.GetForBillingPeriodByBillingAccount":
		resp, err = b.dispatchGetForBillingPeriodByBillingAccount(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BalancesServerTransport) dispatchGetByBillingAccount(req *http.Request) (*http.Response, error) {
	if b.srv.GetByBillingAccount == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByBillingAccount not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/balances`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetByBillingAccount(req.Context(), billingAccountIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Balance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BalancesServerTransport) dispatchGetForBillingPeriodByBillingAccount(req *http.Request) (*http.Response, error) {
	if b.srv.GetForBillingPeriodByBillingAccount == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetForBillingPeriodByBillingAccount not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingPeriods/(?P<billingPeriodName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/balances`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
	if err != nil {
		return nil, err
	}
	billingPeriodNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingPeriodName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetForBillingPeriodByBillingAccount(req.Context(), billingAccountIDParam, billingPeriodNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Balance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
