//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmachinelearning_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/machinelearning/armmachinelearning/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/operationsList.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AmlOperationListResult = armmachinelearning.AmlOperationListResult{
		// 	Value: []*armmachinelearning.AmlOperation{
		// 		{
		// 			Name: to.Ptr("Microsoft.MachineLearningServices/workspaces/write"),
		// 			Display: &armmachinelearning.AmlOperationDisplay{
		// 				Operation: to.Ptr("Create/Update Machine Learning workspaces"),
		// 				Provider: to.Ptr("Microsoft MachineLearningServices"),
		// 				Resource: to.Ptr("workspaces"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.MachineLearningServices/workspaces/delete"),
		// 			Display: &armmachinelearning.AmlOperationDisplay{
		// 				Operation: to.Ptr("Delete Machine Learning workspaces"),
		// 				Provider: to.Ptr("Microsoft MachineLearningServices"),
		// 				Resource: to.Ptr("workspaces"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.MachineLearningServices/workspaces/listkeys/action"),
		// 			Display: &armmachinelearning.AmlOperationDisplay{
		// 				Operation: to.Ptr("List workspace Keys"),
		// 				Provider: to.Ptr("Microsoft MachineLearningServices"),
		// 				Resource: to.Ptr("workspaces"),
		// 			},
		// 	}},
		// }
	}
}
