//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpanngfw_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_ListBySubscription_MaximumSet_Gen.json
func ExampleFirewallsClient_NewListBySubscriptionPager_firewallsListBySubscriptionMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirewallsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirewallResourceListResult = armpanngfw.FirewallResourceListResult{
		// 	Value: []*armpanngfw.FirewallResource{
		// 		{
		// 			Name: to.Ptr("aaaaaaaaaaaaa"),
		// 			Type: to.Ptr("aaaaaa"),
		// 			ID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaa"),
		// 			SystemData: &armpanngfw.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
		// 				CreatedBy: to.Ptr("praval"),
		// 				CreatedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("praval"),
		// 				LastModifiedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"tagName": to.Ptr("value"),
		// 			},
		// 			Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
		// 				Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
		// 				PrincipalID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 				TenantID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 				UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
		// 					"key16": &armpanngfw.AzureResourceManagerUserAssignedIdentity{
		// 						ClientID: to.Ptr("aaaa"),
		// 						PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armpanngfw.FirewallDeploymentProperties{
		// 				AssociatedRulestack: &armpanngfw.RulestackDetails{
		// 					Location: to.Ptr("eastus"),
		// 					ResourceID: to.Ptr("aaaaaaaaaa"),
		// 					RulestackID: to.Ptr("aaaaaaaaaaaaaaaa"),
		// 				},
		// 				DNSSettings: &armpanngfw.DNSSettings{
		// 					DNSServers: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.111"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
		// 					}},
		// 					EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
		// 					EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
		// 				},
		// 				FrontEndSettings: []*armpanngfw.FrontendSetting{
		// 					{
		// 						Name: to.Ptr("frontendsetting11"),
		// 						BackendConfiguration: &armpanngfw.EndpointConfiguration{
		// 							Address: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("20.22.32.136"),
		// 								ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
		// 							},
		// 							Port: to.Ptr("80"),
		// 						},
		// 						FrontendConfiguration: &armpanngfw.EndpointConfiguration{
		// 							Address: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("20.22.91.251"),
		// 								ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
		// 							},
		// 							Port: to.Ptr("80"),
		// 						},
		// 						Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
		// 				}},
		// 				IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
		// 				MarketplaceDetails: &armpanngfw.MarketplaceDetails{
		// 					MarketplaceSubscriptionID: to.Ptr("aa"),
		// 					MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
		// 					OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 					PublisherID: to.Ptr("aaaa"),
		// 				},
		// 				NetworkProfile: &armpanngfw.NetworkProfile{
		// 					EgressNatIP: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.111"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
		// 					}},
		// 					EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
		// 					NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
		// 					PublicIPs: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.11"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
		// 					}},
		// 					TrustedRanges: []*string{
		// 						to.Ptr("20.22.92.11")},
		// 						VnetConfiguration: &armpanngfw.VnetConfiguration{
		// 							IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							TrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
		// 							},
		// 							UnTrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							Vnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.0.0/16"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
		// 							},
		// 						},
		// 						VwanConfiguration: &armpanngfw.VwanConfiguration{
		// 							IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
		// 							TrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
		// 							},
		// 							UnTrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							VHub: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 						},
		// 					},
		// 					PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
		// 					PanoramaConfig: &armpanngfw.PanoramaConfig{
		// 						CgName: to.Ptr("PanoramaCollectorGroup"),
		// 						ConfigString: to.Ptr("bas64EncodedString"),
		// 						DgName: to.Ptr("PanoramaDeviceGroup"),
		// 						HostName: to.Ptr("hostname"),
		// 						PanoramaServer: to.Ptr("10.25.1.1"),
		// 						PanoramaServer2: to.Ptr("10.20.1.1"),
		// 						TplName: to.Ptr("PanoramaTemplateStack"),
		// 						VMAuthKey: to.Ptr("SSH_AUTH_KEY"),
		// 					},
		// 					PlanData: &armpanngfw.PlanData{
		// 						BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
		// 						EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-13T00:46:05.283Z"); return t}()),
		// 						PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 						UsageType: to.Ptr(armpanngfw.UsageTypePAYG),
		// 					},
		// 					ProvisioningState: to.Ptr(armpanngfw.ProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_ListBySubscription_MinimumSet_Gen.json
func ExampleFirewallsClient_NewListBySubscriptionPager_firewallsListBySubscriptionMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirewallsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirewallResourceListResult = armpanngfw.FirewallResourceListResult{
		// 	Value: []*armpanngfw.FirewallResource{
		// 		{
		// 			ID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/providers/PaloAltoNetworks.Cloudngfw/firewalls/firewall"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpanngfw.FirewallDeploymentProperties{
		// 				DNSSettings: &armpanngfw.DNSSettings{
		// 				},
		// 				MarketplaceDetails: &armpanngfw.MarketplaceDetails{
		// 					OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 					PublisherID: to.Ptr("aaaa"),
		// 				},
		// 				NetworkProfile: &armpanngfw.NetworkProfile{
		// 					EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
		// 					NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
		// 					PublicIPs: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.11"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
		// 					}},
		// 				},
		// 				PlanData: &armpanngfw.PlanData{
		// 					BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
		// 					PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_ListByResourceGroup_MaximumSet_Gen.json
func ExampleFirewallsClient_NewListByResourceGroupPager_firewallsListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirewallsClient().NewListByResourceGroupPager("firewall-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirewallResourceListResult = armpanngfw.FirewallResourceListResult{
		// 	Value: []*armpanngfw.FirewallResource{
		// 		{
		// 			Name: to.Ptr("aaaaaaaaaaaaa"),
		// 			Type: to.Ptr("aaaaaa"),
		// 			ID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaa"),
		// 			SystemData: &armpanngfw.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
		// 				CreatedBy: to.Ptr("praval"),
		// 				CreatedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("praval"),
		// 				LastModifiedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"tagName": to.Ptr("value"),
		// 			},
		// 			Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
		// 				Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
		// 				PrincipalID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 				TenantID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 				UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
		// 					"key16": &armpanngfw.AzureResourceManagerUserAssignedIdentity{
		// 						ClientID: to.Ptr("aaaa"),
		// 						PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armpanngfw.FirewallDeploymentProperties{
		// 				AssociatedRulestack: &armpanngfw.RulestackDetails{
		// 					Location: to.Ptr("eastus"),
		// 					ResourceID: to.Ptr("aaaaaaaaaa"),
		// 					RulestackID: to.Ptr("aaaaaaaaaaaaaaaa"),
		// 				},
		// 				DNSSettings: &armpanngfw.DNSSettings{
		// 					DNSServers: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.111"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
		// 					}},
		// 					EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
		// 					EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
		// 				},
		// 				FrontEndSettings: []*armpanngfw.FrontendSetting{
		// 					{
		// 						Name: to.Ptr("frontendsetting11"),
		// 						BackendConfiguration: &armpanngfw.EndpointConfiguration{
		// 							Address: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("20.22.32.136"),
		// 								ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
		// 							},
		// 							Port: to.Ptr("80"),
		// 						},
		// 						FrontendConfiguration: &armpanngfw.EndpointConfiguration{
		// 							Address: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("20.22.91.251"),
		// 								ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
		// 							},
		// 							Port: to.Ptr("80"),
		// 						},
		// 						Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
		// 				}},
		// 				IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
		// 				MarketplaceDetails: &armpanngfw.MarketplaceDetails{
		// 					MarketplaceSubscriptionID: to.Ptr("aa"),
		// 					MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
		// 					OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 					PublisherID: to.Ptr("aaaa"),
		// 				},
		// 				NetworkProfile: &armpanngfw.NetworkProfile{
		// 					EgressNatIP: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.111"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
		// 					}},
		// 					EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
		// 					NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
		// 					PublicIPs: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.11"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
		// 					}},
		// 					TrustedRanges: []*string{
		// 						to.Ptr("20.22.92.11")},
		// 						VnetConfiguration: &armpanngfw.VnetConfiguration{
		// 							IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							TrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
		// 							},
		// 							UnTrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							Vnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.0.0/16"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
		// 							},
		// 						},
		// 						VwanConfiguration: &armpanngfw.VwanConfiguration{
		// 							IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
		// 								Address: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
		// 							TrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
		// 							},
		// 							UnTrustSubnet: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 							VHub: &armpanngfw.IPAddressSpace{
		// 								AddressSpace: to.Ptr("10.1.1.0/24"),
		// 								ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
		// 							},
		// 						},
		// 					},
		// 					PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
		// 					PanoramaConfig: &armpanngfw.PanoramaConfig{
		// 						CgName: to.Ptr("PanoramaCollectorGroup"),
		// 						ConfigString: to.Ptr("bas64EncodedString"),
		// 						DgName: to.Ptr("PanoramaDeviceGroup"),
		// 						HostName: to.Ptr("hostname"),
		// 						PanoramaServer: to.Ptr("10.25.1.1"),
		// 						PanoramaServer2: to.Ptr("10.20.1.1"),
		// 						TplName: to.Ptr("PanoramaTemplateStack"),
		// 						VMAuthKey: to.Ptr("SSH_AUTH_KEY"),
		// 					},
		// 					PlanData: &armpanngfw.PlanData{
		// 						BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
		// 						EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-13T00:46:05.283Z"); return t}()),
		// 						PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 						UsageType: to.Ptr(armpanngfw.UsageTypePAYG),
		// 					},
		// 					ProvisioningState: to.Ptr(armpanngfw.ProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_ListByResourceGroup_MinimumSet_Gen.json
func ExampleFirewallsClient_NewListByResourceGroupPager_firewallsListByResourceGroupMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirewallsClient().NewListByResourceGroupPager("firewall-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirewallResourceListResult = armpanngfw.FirewallResourceListResult{
		// 	Value: []*armpanngfw.FirewallResource{
		// 		{
		// 			ID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourcegroups/firewall-rg/providers/PaloAltoNetworks.Cloudngfw/firewalls/firewall"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpanngfw.FirewallDeploymentProperties{
		// 				DNSSettings: &armpanngfw.DNSSettings{
		// 				},
		// 				MarketplaceDetails: &armpanngfw.MarketplaceDetails{
		// 					OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 					PublisherID: to.Ptr("aaaa"),
		// 				},
		// 				NetworkProfile: &armpanngfw.NetworkProfile{
		// 					EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
		// 					NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
		// 					PublicIPs: []*armpanngfw.IPAddress{
		// 						{
		// 							Address: to.Ptr("20.22.92.11"),
		// 							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
		// 					}},
		// 				},
		// 				PlanData: &armpanngfw.PlanData{
		// 					BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
		// 					PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Get_MaximumSet_Gen.json
func ExampleFirewallsClient_Get_firewallsGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().Get(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallResource = armpanngfw.FirewallResource{
	// 	Name: to.Ptr("aaaaaaaaaaaaa"),
	// 	Type: to.Ptr("aaaaaa"),
	// 	ID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaa"),
	// 	SystemData: &armpanngfw.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
	// 		CreatedBy: to.Ptr("praval"),
	// 		CreatedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("praval"),
	// 		LastModifiedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tagName": to.Ptr("value"),
	// 	},
	// 	Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
	// 		Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
	// 		PrincipalID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		TenantID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
	// 			"key16": &armpanngfw.AzureResourceManagerUserAssignedIdentity{
	// 				ClientID: to.Ptr("aaaa"),
	// 				PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armpanngfw.FirewallDeploymentProperties{
	// 		AssociatedRulestack: &armpanngfw.RulestackDetails{
	// 			Location: to.Ptr("eastus"),
	// 			ResourceID: to.Ptr("aaaaaaaaaa"),
	// 			RulestackID: to.Ptr("aaaaaaaaaaaaaaaa"),
	// 		},
	// 		DNSSettings: &armpanngfw.DNSSettings{
	// 			DNSServers: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.111"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
	// 			}},
	// 			EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
	// 			EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
	// 		},
	// 		FrontEndSettings: []*armpanngfw.FrontendSetting{
	// 			{
	// 				Name: to.Ptr("frontendsetting11"),
	// 				BackendConfiguration: &armpanngfw.EndpointConfiguration{
	// 					Address: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("20.22.32.136"),
	// 						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
	// 					},
	// 					Port: to.Ptr("80"),
	// 				},
	// 				FrontendConfiguration: &armpanngfw.EndpointConfiguration{
	// 					Address: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("20.22.91.251"),
	// 						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
	// 					},
	// 					Port: to.Ptr("80"),
	// 				},
	// 				Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
	// 		}},
	// 		IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// 		MarketplaceDetails: &armpanngfw.MarketplaceDetails{
	// 			MarketplaceSubscriptionID: to.Ptr("aa"),
	// 			MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
	// 			OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			PublisherID: to.Ptr("aaaa"),
	// 		},
	// 		NetworkProfile: &armpanngfw.NetworkProfile{
	// 			EgressNatIP: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.111"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
	// 			}},
	// 			EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
	// 			NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
	// 			PublicIPs: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.11"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
	// 			}},
	// 			TrustedRanges: []*string{
	// 				to.Ptr("20.22.92.11")},
	// 				VnetConfiguration: &armpanngfw.VnetConfiguration{
	// 					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					TrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
	// 					},
	// 					UnTrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					Vnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.0.0/16"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
	// 					},
	// 				},
	// 				VwanConfiguration: &armpanngfw.VwanConfiguration{
	// 					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
	// 					TrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
	// 					},
	// 					UnTrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					VHub: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 				},
	// 			},
	// 			PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
	// 			PanoramaConfig: &armpanngfw.PanoramaConfig{
	// 				CgName: to.Ptr("PanoramaCollectorGroup"),
	// 				ConfigString: to.Ptr("bas64EncodedString"),
	// 				DgName: to.Ptr("PanoramaDeviceGroup"),
	// 				HostName: to.Ptr("hostname"),
	// 				PanoramaServer: to.Ptr("10.25.1.1"),
	// 				PanoramaServer2: to.Ptr("10.20.1.1"),
	// 				TplName: to.Ptr("PanoramaTemplateStack"),
	// 				VMAuthKey: to.Ptr("SSH_AUTH_KEY"),
	// 			},
	// 			PlanData: &armpanngfw.PlanData{
	// 				BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
	// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-13T00:46:05.283Z"); return t}()),
	// 				PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 				UsageType: to.Ptr(armpanngfw.UsageTypePAYG),
	// 			},
	// 			ProvisioningState: to.Ptr(armpanngfw.ProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Get_MinimumSet_Gen.json
func ExampleFirewallsClient_Get_firewallsGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().Get(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallResource = armpanngfw.FirewallResource{
	// 	ID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourcegroups/firewall-rg/providers/PaloAltoNetworks.Cloudngfw/firewalls/firewall1"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpanngfw.FirewallDeploymentProperties{
	// 		DNSSettings: &armpanngfw.DNSSettings{
	// 		},
	// 		MarketplaceDetails: &armpanngfw.MarketplaceDetails{
	// 			OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			PublisherID: to.Ptr("aaaa"),
	// 		},
	// 		NetworkProfile: &armpanngfw.NetworkProfile{
	// 			EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
	// 			NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
	// 			PublicIPs: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.11"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
	// 			}},
	// 		},
	// 		PlanData: &armpanngfw.PlanData{
	// 			BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
	// 			PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_CreateOrUpdate_MaximumSet_Gen.json
func ExampleFirewallsClient_BeginCreateOrUpdate_firewallsCreateOrUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFirewallsClient().BeginCreateOrUpdate(ctx, "firewall-rg", "firewall1", armpanngfw.FirewallResource{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"tagName": to.Ptr("value"),
		},
		Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
			Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
			UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
				"key16": {
					ClientID:    to.Ptr("aaaa"),
					PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
				},
			},
		},
		Properties: &armpanngfw.FirewallDeploymentProperties{
			AssociatedRulestack: &armpanngfw.RulestackDetails{
				Location:    to.Ptr("eastus"),
				ResourceID:  to.Ptr("lrs1"),
				RulestackID: to.Ptr("PANRSID"),
			},
			DNSSettings: &armpanngfw.DNSSettings{
				DNSServers: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.111"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
					}},
				EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
				EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
			},
			FrontEndSettings: []*armpanngfw.FrontendSetting{
				{
					Name: to.Ptr("frontendsetting11"),
					BackendConfiguration: &armpanngfw.EndpointConfiguration{
						Address: &armpanngfw.IPAddress{
							Address:    to.Ptr("20.22.32.136"),
							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
						},
						Port: to.Ptr("80"),
					},
					FrontendConfiguration: &armpanngfw.EndpointConfiguration{
						Address: &armpanngfw.IPAddress{
							Address:    to.Ptr("20.22.91.251"),
							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
						},
						Port: to.Ptr("80"),
					},
					Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
				}},
			IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
			MarketplaceDetails: &armpanngfw.MarketplaceDetails{
				MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
				OfferID:                       to.Ptr("liftr-pan-ame-test"),
				PublisherID:                   to.Ptr("isvtestuklegacy"),
			},
			NetworkProfile: &armpanngfw.NetworkProfile{
				EgressNatIP: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.111"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
					}},
				EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
				NetworkType:     to.Ptr(armpanngfw.NetworkTypeVNET),
				PublicIPs: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.11"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
					}},
				TrustedRanges: []*string{
					to.Ptr("20.22.92.11")},
				VnetConfiguration: &armpanngfw.VnetConfiguration{
					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
						Address:    to.Ptr("10.1.1.0/24"),
						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					TrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
					},
					UnTrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					Vnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.0.0/16"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
					},
				},
				VwanConfiguration: &armpanngfw.VwanConfiguration{
					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
						Address:    to.Ptr("10.1.1.0/24"),
						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
					TrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
					},
					UnTrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					VHub: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
				},
			},
			PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
			PanoramaConfig: &armpanngfw.PanoramaConfig{
				ConfigString: to.Ptr("bas64EncodedString"),
			},
			PlanData: &armpanngfw.PlanData{
				BillingCycle: to.Ptr(armpanngfw.BillingCycleMONTHLY),
				PlanID:       to.Ptr("liftrpantestplan"),
				UsageType:    to.Ptr(armpanngfw.UsageTypePAYG),
			},
			ProvisioningState: to.Ptr(armpanngfw.ProvisioningStateAccepted),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallResource = armpanngfw.FirewallResource{
	// 	Name: to.Ptr("armid1"),
	// 	Type: to.Ptr("firewalls"),
	// 	ID: to.Ptr("/providers/PaloAltoNetworks.Cloudngfw/globalrulestacks/armid1/firewalls/armid1"),
	// 	SystemData: &armpanngfw.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
	// 		CreatedBy: to.Ptr("praval"),
	// 		CreatedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("praval"),
	// 		LastModifiedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tagName": to.Ptr("value"),
	// 	},
	// 	Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
	// 		Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
	// 		PrincipalID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		TenantID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
	// 			"key16": &armpanngfw.AzureResourceManagerUserAssignedIdentity{
	// 				ClientID: to.Ptr("aaaa"),
	// 				PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armpanngfw.FirewallDeploymentProperties{
	// 		AssociatedRulestack: &armpanngfw.RulestackDetails{
	// 			Location: to.Ptr("eastus"),
	// 			ResourceID: to.Ptr("aaaaaaaaaa"),
	// 			RulestackID: to.Ptr("aaaaaaaaaaaaaaaa"),
	// 		},
	// 		DNSSettings: &armpanngfw.DNSSettings{
	// 			DNSServers: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.111"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
	// 			}},
	// 			EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
	// 			EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
	// 		},
	// 		FrontEndSettings: []*armpanngfw.FrontendSetting{
	// 			{
	// 				Name: to.Ptr("frontendsetting11"),
	// 				BackendConfiguration: &armpanngfw.EndpointConfiguration{
	// 					Address: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("20.22.32.136"),
	// 						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
	// 					},
	// 					Port: to.Ptr("80"),
	// 				},
	// 				FrontendConfiguration: &armpanngfw.EndpointConfiguration{
	// 					Address: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("20.22.91.251"),
	// 						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
	// 					},
	// 					Port: to.Ptr("80"),
	// 				},
	// 				Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
	// 		}},
	// 		IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// 		MarketplaceDetails: &armpanngfw.MarketplaceDetails{
	// 			MarketplaceSubscriptionID: to.Ptr("aa"),
	// 			MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
	// 			OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			PublisherID: to.Ptr("aaaa"),
	// 		},
	// 		NetworkProfile: &armpanngfw.NetworkProfile{
	// 			EgressNatIP: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.111"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
	// 			}},
	// 			EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
	// 			NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
	// 			PublicIPs: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.11"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
	// 			}},
	// 			TrustedRanges: []*string{
	// 				to.Ptr("20.22.92.11")},
	// 				VnetConfiguration: &armpanngfw.VnetConfiguration{
	// 					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					TrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
	// 					},
	// 					UnTrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					Vnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.0.0/16"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
	// 					},
	// 				},
	// 				VwanConfiguration: &armpanngfw.VwanConfiguration{
	// 					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
	// 					TrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
	// 					},
	// 					UnTrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					VHub: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 				},
	// 			},
	// 			PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
	// 			PanoramaConfig: &armpanngfw.PanoramaConfig{
	// 				CgName: to.Ptr("PanoramaCollectorGroup"),
	// 				ConfigString: to.Ptr("bas64EncodedString"),
	// 				DgName: to.Ptr("PanoramaDeviceGroup"),
	// 				HostName: to.Ptr("hostname"),
	// 				PanoramaServer: to.Ptr("10.25.1.1"),
	// 				PanoramaServer2: to.Ptr("10.20.1.1"),
	// 				TplName: to.Ptr("PanoramaTemplateStack"),
	// 				VMAuthKey: to.Ptr("SSH_AUTH_KEY"),
	// 			},
	// 			PlanData: &armpanngfw.PlanData{
	// 				BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
	// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-13T00:46:05.283Z"); return t}()),
	// 				PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 				UsageType: to.Ptr(armpanngfw.UsageTypePAYG),
	// 			},
	// 			ProvisioningState: to.Ptr(armpanngfw.ProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_CreateOrUpdate_MinimumSet_Gen.json
func ExampleFirewallsClient_BeginCreateOrUpdate_firewallsCreateOrUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFirewallsClient().BeginCreateOrUpdate(ctx, "firewall-rg", "firewall1", armpanngfw.FirewallResource{
		Location: to.Ptr("eastus"),
		Properties: &armpanngfw.FirewallDeploymentProperties{
			DNSSettings: &armpanngfw.DNSSettings{},
			MarketplaceDetails: &armpanngfw.MarketplaceDetails{
				OfferID:     to.Ptr("liftr-pan-ame-test"),
				PublisherID: to.Ptr("isvtestuklegacy"),
			},
			NetworkProfile: &armpanngfw.NetworkProfile{
				EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
				NetworkType:     to.Ptr(armpanngfw.NetworkTypeVNET),
				PublicIPs: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.11"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
					}},
			},
			PlanData: &armpanngfw.PlanData{
				BillingCycle: to.Ptr(armpanngfw.BillingCycleMONTHLY),
				PlanID:       to.Ptr("liftrpantestplan"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallResource = armpanngfw.FirewallResource{
	// 	ID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourcegroups/firewall-rg/providers/PaloAltoNetworks.Cloudngfw/firewalls/firewall1"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpanngfw.FirewallDeploymentProperties{
	// 		DNSSettings: &armpanngfw.DNSSettings{
	// 		},
	// 		MarketplaceDetails: &armpanngfw.MarketplaceDetails{
	// 			OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			PublisherID: to.Ptr("aaaa"),
	// 		},
	// 		NetworkProfile: &armpanngfw.NetworkProfile{
	// 			EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
	// 			NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
	// 			PublicIPs: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.11"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
	// 			}},
	// 		},
	// 		PlanData: &armpanngfw.PlanData{
	// 			BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
	// 			PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Update_MaximumSet_Gen.json
func ExampleFirewallsClient_Update_firewallsUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().Update(ctx, "firewall-rg", "firewall1", armpanngfw.FirewallResourceUpdate{
		Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
			Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
			UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
				"key16": {
					ClientID:    to.Ptr("aaaa"),
					PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
				},
			},
		},
		Properties: &armpanngfw.FirewallResourceUpdateProperties{
			AssociatedRulestack: &armpanngfw.RulestackDetails{
				Location:    to.Ptr("eastus"),
				ResourceID:  to.Ptr("aaaaaaaaaa"),
				RulestackID: to.Ptr("aaaaaaaaaaaaaaaa"),
			},
			DNSSettings: &armpanngfw.DNSSettings{
				DNSServers: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.111"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
					}},
				EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
				EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
			},
			FrontEndSettings: []*armpanngfw.FrontendSetting{
				{
					Name: to.Ptr("frontendsetting11"),
					BackendConfiguration: &armpanngfw.EndpointConfiguration{
						Address: &armpanngfw.IPAddress{
							Address:    to.Ptr("20.22.32.136"),
							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
						},
						Port: to.Ptr("80"),
					},
					FrontendConfiguration: &armpanngfw.EndpointConfiguration{
						Address: &armpanngfw.IPAddress{
							Address:    to.Ptr("20.22.91.251"),
							ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
						},
						Port: to.Ptr("80"),
					},
					Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
				}},
			IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
			MarketplaceDetails: &armpanngfw.MarketplaceDetails{
				MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
				OfferID:                       to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
				PublisherID:                   to.Ptr("aaaa"),
			},
			NetworkProfile: &armpanngfw.NetworkProfile{
				EgressNatIP: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.111"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
					}},
				EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
				NetworkType:     to.Ptr(armpanngfw.NetworkTypeVNET),
				PublicIPs: []*armpanngfw.IPAddress{
					{
						Address:    to.Ptr("20.22.92.11"),
						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
					}},
				TrustedRanges: []*string{
					to.Ptr("20.22.92.11")},
				VnetConfiguration: &armpanngfw.VnetConfiguration{
					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
						Address:    to.Ptr("10.1.1.0/24"),
						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					TrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
					},
					UnTrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					Vnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.0.0/16"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
					},
				},
				VwanConfiguration: &armpanngfw.VwanConfiguration{
					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
						Address:    to.Ptr("10.1.1.0/24"),
						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
					TrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
					},
					UnTrustSubnet: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
					VHub: &armpanngfw.IPAddressSpace{
						AddressSpace: to.Ptr("10.1.1.0/24"),
						ResourceID:   to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
					},
				},
			},
			PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
			PanoramaConfig: &armpanngfw.PanoramaConfig{
				ConfigString: to.Ptr("bas64EncodedString"),
			},
			PlanData: &armpanngfw.PlanData{
				BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
				PlanID:       to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
				UsageType:    to.Ptr(armpanngfw.UsageTypePAYG),
			},
		},
		Tags: map[string]*string{
			"tagName": to.Ptr("value"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallResource = armpanngfw.FirewallResource{
	// 	Name: to.Ptr("aaaaaaaaaaaaa"),
	// 	Type: to.Ptr("aaaaaa"),
	// 	ID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaa"),
	// 	SystemData: &armpanngfw.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
	// 		CreatedBy: to.Ptr("praval"),
	// 		CreatedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-09T05:08:24.229Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("praval"),
	// 		LastModifiedByType: to.Ptr(armpanngfw.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tagName": to.Ptr("value"),
	// 	},
	// 	Identity: &armpanngfw.AzureResourceManagerManagedIdentityProperties{
	// 		Type: to.Ptr(armpanngfw.ManagedIdentityTypeNone),
	// 		PrincipalID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		TenantID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		UserAssignedIdentities: map[string]*armpanngfw.AzureResourceManagerUserAssignedIdentity{
	// 			"key16": &armpanngfw.AzureResourceManagerUserAssignedIdentity{
	// 				ClientID: to.Ptr("aaaa"),
	// 				PrincipalID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armpanngfw.FirewallDeploymentProperties{
	// 		AssociatedRulestack: &armpanngfw.RulestackDetails{
	// 			Location: to.Ptr("eastus"),
	// 			ResourceID: to.Ptr("aaaaaaaaaa"),
	// 			RulestackID: to.Ptr("aaaaaaaaaaaaaaaa"),
	// 		},
	// 		DNSSettings: &armpanngfw.DNSSettings{
	// 			DNSServers: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.111"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
	// 			}},
	// 			EnableDNSProxy: to.Ptr(armpanngfw.DNSProxyDISABLED),
	// 			EnabledDNSType: to.Ptr(armpanngfw.EnabledDNSTypeCUSTOM),
	// 		},
	// 		FrontEndSettings: []*armpanngfw.FrontendSetting{
	// 			{
	// 				Name: to.Ptr("frontendsetting11"),
	// 				BackendConfiguration: &armpanngfw.EndpointConfiguration{
	// 					Address: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("20.22.32.136"),
	// 						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
	// 					},
	// 					Port: to.Ptr("80"),
	// 				},
	// 				FrontendConfiguration: &armpanngfw.EndpointConfiguration{
	// 					Address: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("20.22.91.251"),
	// 						ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
	// 					},
	// 					Port: to.Ptr("80"),
	// 				},
	// 				Protocol: to.Ptr(armpanngfw.ProtocolTypeTCP),
	// 		}},
	// 		IsPanoramaManaged: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// 		MarketplaceDetails: &armpanngfw.MarketplaceDetails{
	// 			MarketplaceSubscriptionID: to.Ptr("aa"),
	// 			MarketplaceSubscriptionStatus: to.Ptr(armpanngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
	// 			OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			PublisherID: to.Ptr("aaaa"),
	// 		},
	// 		NetworkProfile: &armpanngfw.NetworkProfile{
	// 			EgressNatIP: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.111"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
	// 			}},
	// 			EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
	// 			NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
	// 			PublicIPs: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.11"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
	// 			}},
	// 			TrustedRanges: []*string{
	// 				to.Ptr("20.22.92.11")},
	// 				VnetConfiguration: &armpanngfw.VnetConfiguration{
	// 					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					TrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
	// 					},
	// 					UnTrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					Vnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.0.0/16"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
	// 					},
	// 				},
	// 				VwanConfiguration: &armpanngfw.VwanConfiguration{
	// 					IPOfTrustSubnetForUdr: &armpanngfw.IPAddress{
	// 						Address: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					NetworkVirtualApplianceID: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
	// 					TrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
	// 					},
	// 					UnTrustSubnet: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 					VHub: &armpanngfw.IPAddressSpace{
	// 						AddressSpace: to.Ptr("10.1.1.0/24"),
	// 						ResourceID: to.Ptr("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
	// 					},
	// 				},
	// 			},
	// 			PanEtag: to.Ptr("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
	// 			PanoramaConfig: &armpanngfw.PanoramaConfig{
	// 				CgName: to.Ptr("PanoramaCollectorGroup"),
	// 				ConfigString: to.Ptr("bas64EncodedString"),
	// 				DgName: to.Ptr("PanoramaDeviceGroup"),
	// 				HostName: to.Ptr("hostname"),
	// 				PanoramaServer: to.Ptr("10.25.1.1"),
	// 				PanoramaServer2: to.Ptr("10.20.1.1"),
	// 				TplName: to.Ptr("PanoramaTemplateStack"),
	// 				VMAuthKey: to.Ptr("SSH_AUTH_KEY"),
	// 			},
	// 			PlanData: &armpanngfw.PlanData{
	// 				BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
	// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-13T00:46:05.283Z"); return t}()),
	// 				PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 				UsageType: to.Ptr(armpanngfw.UsageTypePAYG),
	// 			},
	// 			ProvisioningState: to.Ptr(armpanngfw.ProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Update_MinimumSet_Gen.json
func ExampleFirewallsClient_Update_firewallsUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().Update(ctx, "firewall-rg", "firewall1", armpanngfw.FirewallResourceUpdate{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallResource = armpanngfw.FirewallResource{
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpanngfw.FirewallDeploymentProperties{
	// 		DNSSettings: &armpanngfw.DNSSettings{
	// 		},
	// 		MarketplaceDetails: &armpanngfw.MarketplaceDetails{
	// 			OfferID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 			PublisherID: to.Ptr("aaaa"),
	// 		},
	// 		NetworkProfile: &armpanngfw.NetworkProfile{
	// 			EnableEgressNat: to.Ptr(armpanngfw.EgressNatENABLED),
	// 			NetworkType: to.Ptr(armpanngfw.NetworkTypeVNET),
	// 			PublicIPs: []*armpanngfw.IPAddress{
	// 				{
	// 					Address: to.Ptr("20.22.92.11"),
	// 					ResourceID: to.Ptr("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
	// 			}},
	// 		},
	// 		PlanData: &armpanngfw.PlanData{
	// 			BillingCycle: to.Ptr(armpanngfw.BillingCycleWEEKLY),
	// 			PlanID: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Delete_MaximumSet_Gen.json
func ExampleFirewallsClient_BeginDelete_firewallsDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFirewallsClient().BeginDelete(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Delete_MinimumSet_Gen.json
func ExampleFirewallsClient_BeginDelete_firewallsDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFirewallsClient().BeginDelete(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getGlobalRulestack_MaximumSet_Gen.json
func ExampleFirewallsClient_GetGlobalRulestack_firewallsGetGlobalRulestackMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().GetGlobalRulestack(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GlobalRulestackInfo = armpanngfw.GlobalRulestackInfo{
	// 	AzureID: to.Ptr("aaaaaaaaaa"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getGlobalRulestack_MinimumSet_Gen.json
func ExampleFirewallsClient_GetGlobalRulestack_firewallsGetGlobalRulestackMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().GetGlobalRulestack(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GlobalRulestackInfo = armpanngfw.GlobalRulestackInfo{
	// 	AzureID: to.Ptr("aaaaaaaaaa"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getLogProfile_MaximumSet_Gen.json
func ExampleFirewallsClient_GetLogProfile_firewallsGetLogProfileMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().GetLogProfile(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogSettings = armpanngfw.LogSettings{
	// 	ApplicationInsights: &armpanngfw.ApplicationInsights{
	// 		ID: to.Ptr("aaaaaaaaaaaaaaaa"),
	// 		Key: to.Ptr("aaaaaaaaaaaaa"),
	// 	},
	// 	CommonDestination: &armpanngfw.LogDestination{
	// 		EventHubConfigurations: &armpanngfw.EventHub{
	// 			Name: to.Ptr("aaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaa"),
	// 			NameSpace: to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
	// 			PolicyName: to.Ptr("aaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaa"),
	// 		},
	// 		MonitorConfigurations: &armpanngfw.MonitorLog{
	// 			ID: to.Ptr("aaaaaaaaaaaaaaaaaaa"),
	// 			PrimaryKey: to.Ptr("aaaaaaaaaaaaa"),
	// 			SecondaryKey: to.Ptr("a"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
	// 			Workspace: to.Ptr("aaaaaaaaaaa"),
	// 		},
	// 		StorageConfigurations: &armpanngfw.StorageAccount{
	// 			AccountName: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaa"),
	// 		},
	// 	},
	// 	DecryptLogDestination: &armpanngfw.LogDestination{
	// 		EventHubConfigurations: &armpanngfw.EventHub{
	// 			Name: to.Ptr("aaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaa"),
	// 			NameSpace: to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
	// 			PolicyName: to.Ptr("aaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaa"),
	// 		},
	// 		MonitorConfigurations: &armpanngfw.MonitorLog{
	// 			ID: to.Ptr("aaaaaaaaaaaaaaaaaaa"),
	// 			PrimaryKey: to.Ptr("aaaaaaaaaaaaa"),
	// 			SecondaryKey: to.Ptr("a"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
	// 			Workspace: to.Ptr("aaaaaaaaaaa"),
	// 		},
	// 		StorageConfigurations: &armpanngfw.StorageAccount{
	// 			AccountName: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaa"),
	// 		},
	// 	},
	// 	LogOption: to.Ptr(armpanngfw.LogOptionSAMEDESTINATION),
	// 	LogType: to.Ptr(armpanngfw.LogTypeTRAFFIC),
	// 	ThreatLogDestination: &armpanngfw.LogDestination{
	// 		EventHubConfigurations: &armpanngfw.EventHub{
	// 			Name: to.Ptr("aaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaa"),
	// 			NameSpace: to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
	// 			PolicyName: to.Ptr("aaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaa"),
	// 		},
	// 		MonitorConfigurations: &armpanngfw.MonitorLog{
	// 			ID: to.Ptr("aaaaaaaaaaaaaaaaaaa"),
	// 			PrimaryKey: to.Ptr("aaaaaaaaaaaaa"),
	// 			SecondaryKey: to.Ptr("a"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
	// 			Workspace: to.Ptr("aaaaaaaaaaa"),
	// 		},
	// 		StorageConfigurations: &armpanngfw.StorageAccount{
	// 			AccountName: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaa"),
	// 		},
	// 	},
	// 	TrafficLogDestination: &armpanngfw.LogDestination{
	// 		EventHubConfigurations: &armpanngfw.EventHub{
	// 			Name: to.Ptr("aaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaa"),
	// 			NameSpace: to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
	// 			PolicyName: to.Ptr("aaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaa"),
	// 		},
	// 		MonitorConfigurations: &armpanngfw.MonitorLog{
	// 			ID: to.Ptr("aaaaaaaaaaaaaaaaaaa"),
	// 			PrimaryKey: to.Ptr("aaaaaaaaaaaaa"),
	// 			SecondaryKey: to.Ptr("a"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
	// 			Workspace: to.Ptr("aaaaaaaaaaa"),
	// 		},
	// 		StorageConfigurations: &armpanngfw.StorageAccount{
	// 			AccountName: to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
	// 			ID: to.Ptr("aaaaaaaaaaaaaaa"),
	// 			SubscriptionID: to.Ptr("aaaaaaaaa"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getLogProfile_MinimumSet_Gen.json
func ExampleFirewallsClient_GetLogProfile_firewallsGetLogProfileMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().GetLogProfile(ctx, "firewall-rg", "firewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogSettings = armpanngfw.LogSettings{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getSupportInfo_MaximumSet_Gen.json
func ExampleFirewallsClient_GetSupportInfo_firewallsGetSupportInfoMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().GetSupportInfo(ctx, "rgopenapi", "firewall1", &armpanngfw.FirewallsClientGetSupportInfoOptions{Email: to.Ptr("user1@domain.com")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SupportInfo = armpanngfw.SupportInfo{
	// 	AccountID: to.Ptr("3cg5b439-294d-4c25-b0b2-ef649e0g6d38"),
	// 	AccountRegistered: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// 	FreeTrial: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// 	FreeTrialCreditLeft: to.Ptr[int32](10),
	// 	FreeTrialDaysLeft: to.Ptr[int32](1),
	// 	HelpURL: to.Ptr("https://ssopreview.paloaltonetworks.com/home/bookmark/0oa4ao61shG4rd3Ub1d7/2557"),
	// 	ProductSerial: to.Ptr("e22715cb-7e4e-4814-ad4f-ccd1417755d7"),
	// 	ProductSKU: to.Ptr("62f63e3c-bc5a-4d68-a8a1-fcba9f526c90"),
	// 	RegisterURL: to.Ptr("https://ssopreview.paloaltonetworks.com/home/bookmark/0oa4ao61shG4rd3Ub1d7/2557"),
	// 	SupportURL: to.Ptr("https://ssopreview.paloaltonetworks.com/home/bookmark/0oa4ao61shG4rd3Ub1d7/2557"),
	// 	UserDomainSupported: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// 	UserRegistered: to.Ptr(armpanngfw.BooleanEnumTRUE),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getSupportInfo_MinimumSet_Gen.json
func ExampleFirewallsClient_GetSupportInfo_firewallsGetSupportInfoMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirewallsClient().GetSupportInfo(ctx, "rgopenapi", "firewall1", &armpanngfw.FirewallsClientGetSupportInfoOptions{Email: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SupportInfo = armpanngfw.SupportInfo{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_saveLogProfile_MaximumSet_Gen.json
func ExampleFirewallsClient_SaveLogProfile_firewallsSaveLogProfileMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewFirewallsClient().SaveLogProfile(ctx, "firewall-rg", "firewall1", &armpanngfw.FirewallsClientSaveLogProfileOptions{LogSettings: &armpanngfw.LogSettings{
		ApplicationInsights: &armpanngfw.ApplicationInsights{
			ID:  to.Ptr("aaaaaaaaaaaaaaaa"),
			Key: to.Ptr("aaaaaaaaaaaaa"),
		},
		CommonDestination: &armpanngfw.LogDestination{
			EventHubConfigurations: &armpanngfw.EventHub{
				Name:           to.Ptr("aaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaa"),
				NameSpace:      to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
				PolicyName:     to.Ptr("aaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaaa"),
			},
			MonitorConfigurations: &armpanngfw.MonitorLog{
				ID:             to.Ptr("aaaaaaaaaaaaaaaaaaa"),
				PrimaryKey:     to.Ptr("aaaaaaaaaaaaa"),
				SecondaryKey:   to.Ptr("a"),
				SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
				Workspace:      to.Ptr("aaaaaaaaaaa"),
			},
			StorageConfigurations: &armpanngfw.StorageAccount{
				AccountName:    to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaa"),
			},
		},
		DecryptLogDestination: &armpanngfw.LogDestination{
			EventHubConfigurations: &armpanngfw.EventHub{
				Name:           to.Ptr("aaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaa"),
				NameSpace:      to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
				PolicyName:     to.Ptr("aaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaaa"),
			},
			MonitorConfigurations: &armpanngfw.MonitorLog{
				ID:             to.Ptr("aaaaaaaaaaaaaaaaaaa"),
				PrimaryKey:     to.Ptr("aaaaaaaaaaaaa"),
				SecondaryKey:   to.Ptr("a"),
				SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
				Workspace:      to.Ptr("aaaaaaaaaaa"),
			},
			StorageConfigurations: &armpanngfw.StorageAccount{
				AccountName:    to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaa"),
			},
		},
		LogOption: to.Ptr(armpanngfw.LogOptionSAMEDESTINATION),
		LogType:   to.Ptr(armpanngfw.LogTypeTRAFFIC),
		ThreatLogDestination: &armpanngfw.LogDestination{
			EventHubConfigurations: &armpanngfw.EventHub{
				Name:           to.Ptr("aaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaa"),
				NameSpace:      to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
				PolicyName:     to.Ptr("aaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaaa"),
			},
			MonitorConfigurations: &armpanngfw.MonitorLog{
				ID:             to.Ptr("aaaaaaaaaaaaaaaaaaa"),
				PrimaryKey:     to.Ptr("aaaaaaaaaaaaa"),
				SecondaryKey:   to.Ptr("a"),
				SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
				Workspace:      to.Ptr("aaaaaaaaaaa"),
			},
			StorageConfigurations: &armpanngfw.StorageAccount{
				AccountName:    to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaa"),
			},
		},
		TrafficLogDestination: &armpanngfw.LogDestination{
			EventHubConfigurations: &armpanngfw.EventHub{
				Name:           to.Ptr("aaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaa"),
				NameSpace:      to.Ptr("aaaaaaaaaaaaaaaaaaaaa"),
				PolicyName:     to.Ptr("aaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaaa"),
			},
			MonitorConfigurations: &armpanngfw.MonitorLog{
				ID:             to.Ptr("aaaaaaaaaaaaaaaaaaa"),
				PrimaryKey:     to.Ptr("aaaaaaaaaaaaa"),
				SecondaryKey:   to.Ptr("a"),
				SubscriptionID: to.Ptr("aaaaaaaaaaaaa"),
				Workspace:      to.Ptr("aaaaaaaaaaa"),
			},
			StorageConfigurations: &armpanngfw.StorageAccount{
				AccountName:    to.Ptr("aaaaaaaaaaaaaaaaaaaaaaa"),
				ID:             to.Ptr("aaaaaaaaaaaaaaa"),
				SubscriptionID: to.Ptr("aaaaaaaaa"),
			},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4bb583bcb67c2bf448712f2bd1593a64a7a8f139/specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_saveLogProfile_MinimumSet_Gen.json
func ExampleFirewallsClient_SaveLogProfile_firewallsSaveLogProfileMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpanngfw.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewFirewallsClient().SaveLogProfile(ctx, "firewall-rg", "firewall1", &armpanngfw.FirewallsClientSaveLogProfileOptions{LogSettings: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
