//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armlocks"
	"net/http"
	"net/url"
	"regexp"
)

// ManagementLocksServer is a fake server for instances of the armlocks.ManagementLocksClient type.
type ManagementLocksServer struct {
	// CreateOrUpdateAtResourceGroupLevel is the fake for method ManagementLocksClient.CreateOrUpdateAtResourceGroupLevel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtResourceGroupLevel func(ctx context.Context, resourceGroupName string, lockName string, parameters armlocks.ManagementLockObject, options *armlocks.ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtResourceLevel is the fake for method ManagementLocksClient.CreateOrUpdateAtResourceLevel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtResourceLevel func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters armlocks.ManagementLockObject, options *armlocks.ManagementLocksClientCreateOrUpdateAtResourceLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientCreateOrUpdateAtResourceLevelResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtSubscriptionLevel is the fake for method ManagementLocksClient.CreateOrUpdateAtSubscriptionLevel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtSubscriptionLevel func(ctx context.Context, lockName string, parameters armlocks.ManagementLockObject, options *armlocks.ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateByScope is the fake for method ManagementLocksClient.CreateOrUpdateByScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateByScope func(ctx context.Context, scope string, lockName string, parameters armlocks.ManagementLockObject, options *armlocks.ManagementLocksClientCreateOrUpdateByScopeOptions) (resp azfake.Responder[armlocks.ManagementLocksClientCreateOrUpdateByScopeResponse], errResp azfake.ErrorResponder)

	// DeleteAtResourceGroupLevel is the fake for method ManagementLocksClient.DeleteAtResourceGroupLevel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtResourceGroupLevel func(ctx context.Context, resourceGroupName string, lockName string, options *armlocks.ManagementLocksClientDeleteAtResourceGroupLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientDeleteAtResourceGroupLevelResponse], errResp azfake.ErrorResponder)

	// DeleteAtResourceLevel is the fake for method ManagementLocksClient.DeleteAtResourceLevel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtResourceLevel func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *armlocks.ManagementLocksClientDeleteAtResourceLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientDeleteAtResourceLevelResponse], errResp azfake.ErrorResponder)

	// DeleteAtSubscriptionLevel is the fake for method ManagementLocksClient.DeleteAtSubscriptionLevel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtSubscriptionLevel func(ctx context.Context, lockName string, options *armlocks.ManagementLocksClientDeleteAtSubscriptionLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientDeleteAtSubscriptionLevelResponse], errResp azfake.ErrorResponder)

	// DeleteByScope is the fake for method ManagementLocksClient.DeleteByScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteByScope func(ctx context.Context, scope string, lockName string, options *armlocks.ManagementLocksClientDeleteByScopeOptions) (resp azfake.Responder[armlocks.ManagementLocksClientDeleteByScopeResponse], errResp azfake.ErrorResponder)

	// GetAtResourceGroupLevel is the fake for method ManagementLocksClient.GetAtResourceGroupLevel
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResourceGroupLevel func(ctx context.Context, resourceGroupName string, lockName string, options *armlocks.ManagementLocksClientGetAtResourceGroupLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientGetAtResourceGroupLevelResponse], errResp azfake.ErrorResponder)

	// GetAtResourceLevel is the fake for method ManagementLocksClient.GetAtResourceLevel
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResourceLevel func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *armlocks.ManagementLocksClientGetAtResourceLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientGetAtResourceLevelResponse], errResp azfake.ErrorResponder)

	// GetAtSubscriptionLevel is the fake for method ManagementLocksClient.GetAtSubscriptionLevel
	// HTTP status codes to indicate success: http.StatusOK
	GetAtSubscriptionLevel func(ctx context.Context, lockName string, options *armlocks.ManagementLocksClientGetAtSubscriptionLevelOptions) (resp azfake.Responder[armlocks.ManagementLocksClientGetAtSubscriptionLevelResponse], errResp azfake.ErrorResponder)

	// GetByScope is the fake for method ManagementLocksClient.GetByScope
	// HTTP status codes to indicate success: http.StatusOK
	GetByScope func(ctx context.Context, scope string, lockName string, options *armlocks.ManagementLocksClientGetByScopeOptions) (resp azfake.Responder[armlocks.ManagementLocksClientGetByScopeResponse], errResp azfake.ErrorResponder)

	// NewListAtResourceGroupLevelPager is the fake for method ManagementLocksClient.NewListAtResourceGroupLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtResourceGroupLevelPager func(resourceGroupName string, options *armlocks.ManagementLocksClientListAtResourceGroupLevelOptions) (resp azfake.PagerResponder[armlocks.ManagementLocksClientListAtResourceGroupLevelResponse])

	// NewListAtResourceLevelPager is the fake for method ManagementLocksClient.NewListAtResourceLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtResourceLevelPager func(resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *armlocks.ManagementLocksClientListAtResourceLevelOptions) (resp azfake.PagerResponder[armlocks.ManagementLocksClientListAtResourceLevelResponse])

	// NewListAtSubscriptionLevelPager is the fake for method ManagementLocksClient.NewListAtSubscriptionLevelPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtSubscriptionLevelPager func(options *armlocks.ManagementLocksClientListAtSubscriptionLevelOptions) (resp azfake.PagerResponder[armlocks.ManagementLocksClientListAtSubscriptionLevelResponse])

	// NewListByScopePager is the fake for method ManagementLocksClient.NewListByScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByScopePager func(scope string, options *armlocks.ManagementLocksClientListByScopeOptions) (resp azfake.PagerResponder[armlocks.ManagementLocksClientListByScopeResponse])
}

// NewManagementLocksServerTransport creates a new instance of ManagementLocksServerTransport with the provided implementation.
// The returned ManagementLocksServerTransport instance is connected to an instance of armlocks.ManagementLocksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagementLocksServerTransport(srv *ManagementLocksServer) *ManagementLocksServerTransport {
	return &ManagementLocksServerTransport{
		srv:                              srv,
		newListAtResourceGroupLevelPager: newTracker[azfake.PagerResponder[armlocks.ManagementLocksClientListAtResourceGroupLevelResponse]](),
		newListAtResourceLevelPager:      newTracker[azfake.PagerResponder[armlocks.ManagementLocksClientListAtResourceLevelResponse]](),
		newListAtSubscriptionLevelPager:  newTracker[azfake.PagerResponder[armlocks.ManagementLocksClientListAtSubscriptionLevelResponse]](),
		newListByScopePager:              newTracker[azfake.PagerResponder[armlocks.ManagementLocksClientListByScopeResponse]](),
	}
}

// ManagementLocksServerTransport connects instances of armlocks.ManagementLocksClient to instances of ManagementLocksServer.
// Don't use this type directly, use NewManagementLocksServerTransport instead.
type ManagementLocksServerTransport struct {
	srv                              *ManagementLocksServer
	newListAtResourceGroupLevelPager *tracker[azfake.PagerResponder[armlocks.ManagementLocksClientListAtResourceGroupLevelResponse]]
	newListAtResourceLevelPager      *tracker[azfake.PagerResponder[armlocks.ManagementLocksClientListAtResourceLevelResponse]]
	newListAtSubscriptionLevelPager  *tracker[azfake.PagerResponder[armlocks.ManagementLocksClientListAtSubscriptionLevelResponse]]
	newListByScopePager              *tracker[azfake.PagerResponder[armlocks.ManagementLocksClientListByScopeResponse]]
}

// Do implements the policy.Transporter interface for ManagementLocksServerTransport.
func (m *ManagementLocksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagementLocksClient.CreateOrUpdateAtResourceGroupLevel":
		resp, err = m.dispatchCreateOrUpdateAtResourceGroupLevel(req)
	case "ManagementLocksClient.CreateOrUpdateAtResourceLevel":
		resp, err = m.dispatchCreateOrUpdateAtResourceLevel(req)
	case "ManagementLocksClient.CreateOrUpdateAtSubscriptionLevel":
		resp, err = m.dispatchCreateOrUpdateAtSubscriptionLevel(req)
	case "ManagementLocksClient.CreateOrUpdateByScope":
		resp, err = m.dispatchCreateOrUpdateByScope(req)
	case "ManagementLocksClient.DeleteAtResourceGroupLevel":
		resp, err = m.dispatchDeleteAtResourceGroupLevel(req)
	case "ManagementLocksClient.DeleteAtResourceLevel":
		resp, err = m.dispatchDeleteAtResourceLevel(req)
	case "ManagementLocksClient.DeleteAtSubscriptionLevel":
		resp, err = m.dispatchDeleteAtSubscriptionLevel(req)
	case "ManagementLocksClient.DeleteByScope":
		resp, err = m.dispatchDeleteByScope(req)
	case "ManagementLocksClient.GetAtResourceGroupLevel":
		resp, err = m.dispatchGetAtResourceGroupLevel(req)
	case "ManagementLocksClient.GetAtResourceLevel":
		resp, err = m.dispatchGetAtResourceLevel(req)
	case "ManagementLocksClient.GetAtSubscriptionLevel":
		resp, err = m.dispatchGetAtSubscriptionLevel(req)
	case "ManagementLocksClient.GetByScope":
		resp, err = m.dispatchGetByScope(req)
	case "ManagementLocksClient.NewListAtResourceGroupLevelPager":
		resp, err = m.dispatchNewListAtResourceGroupLevelPager(req)
	case "ManagementLocksClient.NewListAtResourceLevelPager":
		resp, err = m.dispatchNewListAtResourceLevelPager(req)
	case "ManagementLocksClient.NewListAtSubscriptionLevelPager":
		resp, err = m.dispatchNewListAtSubscriptionLevelPager(req)
	case "ManagementLocksClient.NewListByScopePager":
		resp, err = m.dispatchNewListByScopePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchCreateOrUpdateAtResourceGroupLevel(req *http.Request) (*http.Response, error) {
	if m.srv.CreateOrUpdateAtResourceGroupLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtResourceGroupLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlocks.ManagementLockObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateOrUpdateAtResourceGroupLevel(req.Context(), resourceGroupNameParam, lockNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchCreateOrUpdateAtResourceLevel(req *http.Request) (*http.Response, error) {
	if m.srv.CreateOrUpdateAtResourceLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtResourceLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourcePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlocks.ManagementLockObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourcePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourcePath")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateOrUpdateAtResourceLevel(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourcePathParam, resourceTypeParam, resourceNameParam, lockNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchCreateOrUpdateAtSubscriptionLevel(req *http.Request) (*http.Response, error) {
	if m.srv.CreateOrUpdateAtSubscriptionLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtSubscriptionLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlocks.ManagementLockObject](req)
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateOrUpdateAtSubscriptionLevel(req.Context(), lockNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchCreateOrUpdateByScope(req *http.Request) (*http.Response, error) {
	if m.srv.CreateOrUpdateByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlocks.ManagementLockObject](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateOrUpdateByScope(req.Context(), scopeParam, lockNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchDeleteAtResourceGroupLevel(req *http.Request) (*http.Response, error) {
	if m.srv.DeleteAtResourceGroupLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtResourceGroupLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.DeleteAtResourceGroupLevel(req.Context(), resourceGroupNameParam, lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchDeleteAtResourceLevel(req *http.Request) (*http.Response, error) {
	if m.srv.DeleteAtResourceLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtResourceLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourcePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourcePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourcePath")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.DeleteAtResourceLevel(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourcePathParam, resourceTypeParam, resourceNameParam, lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchDeleteAtSubscriptionLevel(req *http.Request) (*http.Response, error) {
	if m.srv.DeleteAtSubscriptionLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtSubscriptionLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.DeleteAtSubscriptionLevel(req.Context(), lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchDeleteByScope(req *http.Request) (*http.Response, error) {
	if m.srv.DeleteByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.DeleteByScope(req.Context(), scopeParam, lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchGetAtResourceGroupLevel(req *http.Request) (*http.Response, error) {
	if m.srv.GetAtResourceGroupLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResourceGroupLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetAtResourceGroupLevel(req.Context(), resourceGroupNameParam, lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchGetAtResourceLevel(req *http.Request) (*http.Response, error) {
	if m.srv.GetAtResourceLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResourceLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourcePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourcePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourcePath")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetAtResourceLevel(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourcePathParam, resourceTypeParam, resourceNameParam, lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchGetAtSubscriptionLevel(req *http.Request) (*http.Response, error) {
	if m.srv.GetAtSubscriptionLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtSubscriptionLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetAtSubscriptionLevel(req.Context(), lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchGetByScope(req *http.Request) (*http.Response, error) {
	if m.srv.GetByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks/(?P<lockName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	lockNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("lockName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetByScope(req.Context(), scopeParam, lockNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagementLockObject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchNewListAtResourceGroupLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAtResourceGroupLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtResourceGroupLevelPager not implemented")}
	}
	newListAtResourceGroupLevelPager := m.newListAtResourceGroupLevelPager.get(req)
	if newListAtResourceGroupLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlocks.ManagementLocksClientListAtResourceGroupLevelOptions
		if filterParam != nil {
			options = &armlocks.ManagementLocksClientListAtResourceGroupLevelOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListAtResourceGroupLevelPager(resourceGroupNameParam, options)
		newListAtResourceGroupLevelPager = &resp
		m.newListAtResourceGroupLevelPager.add(req, newListAtResourceGroupLevelPager)
		server.PagerResponderInjectNextLinks(newListAtResourceGroupLevelPager, req, func(page *armlocks.ManagementLocksClientListAtResourceGroupLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtResourceGroupLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAtResourceGroupLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtResourceGroupLevelPager) {
		m.newListAtResourceGroupLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchNewListAtResourceLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAtResourceLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtResourceLevelPager not implemented")}
	}
	newListAtResourceLevelPager := m.newListAtResourceLevelPager.get(req)
	if newListAtResourceLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourcePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
		if err != nil {
			return nil, err
		}
		parentResourcePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourcePath")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlocks.ManagementLocksClientListAtResourceLevelOptions
		if filterParam != nil {
			options = &armlocks.ManagementLocksClientListAtResourceLevelOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListAtResourceLevelPager(resourceGroupNameParam, resourceProviderNamespaceParam, parentResourcePathParam, resourceTypeParam, resourceNameParam, options)
		newListAtResourceLevelPager = &resp
		m.newListAtResourceLevelPager.add(req, newListAtResourceLevelPager)
		server.PagerResponderInjectNextLinks(newListAtResourceLevelPager, req, func(page *armlocks.ManagementLocksClientListAtResourceLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtResourceLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAtResourceLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtResourceLevelPager) {
		m.newListAtResourceLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchNewListAtSubscriptionLevelPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAtSubscriptionLevelPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtSubscriptionLevelPager not implemented")}
	}
	newListAtSubscriptionLevelPager := m.newListAtSubscriptionLevelPager.get(req)
	if newListAtSubscriptionLevelPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlocks.ManagementLocksClientListAtSubscriptionLevelOptions
		if filterParam != nil {
			options = &armlocks.ManagementLocksClientListAtSubscriptionLevelOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListAtSubscriptionLevelPager(options)
		newListAtSubscriptionLevelPager = &resp
		m.newListAtSubscriptionLevelPager.add(req, newListAtSubscriptionLevelPager)
		server.PagerResponderInjectNextLinks(newListAtSubscriptionLevelPager, req, func(page *armlocks.ManagementLocksClientListAtSubscriptionLevelResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtSubscriptionLevelPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAtSubscriptionLevelPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtSubscriptionLevelPager) {
		m.newListAtSubscriptionLevelPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementLocksServerTransport) dispatchNewListByScopePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByScopePager not implemented")}
	}
	newListByScopePager := m.newListByScopePager.get(req)
	if newListByScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/locks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlocks.ManagementLocksClientListByScopeOptions
		if filterParam != nil {
			options = &armlocks.ManagementLocksClientListByScopeOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListByScopePager(scopeParam, options)
		newListByScopePager = &resp
		m.newListByScopePager.add(req, newListByScopePager)
		server.PagerResponderInjectNextLinks(newListByScopePager, req, func(page *armlocks.ManagementLocksClientListByScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByScopePager) {
		m.newListByScopePager.remove(req)
	}
	return resp, nil
}
