//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolMetadataSyncConfigsServer is a fake server for instances of the armsynapse.SQLPoolMetadataSyncConfigsClient type.
type SQLPoolMetadataSyncConfigsServer struct {
	// Create is the fake for method SQLPoolMetadataSyncConfigsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, metadataSyncConfiguration armsynapse.MetadataSyncConfig, options *armsynapse.SQLPoolMetadataSyncConfigsClientCreateOptions) (resp azfake.Responder[armsynapse.SQLPoolMetadataSyncConfigsClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SQLPoolMetadataSyncConfigsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.SQLPoolMetadataSyncConfigsClientGetOptions) (resp azfake.Responder[armsynapse.SQLPoolMetadataSyncConfigsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewSQLPoolMetadataSyncConfigsServerTransport creates a new instance of SQLPoolMetadataSyncConfigsServerTransport with the provided implementation.
// The returned SQLPoolMetadataSyncConfigsServerTransport instance is connected to an instance of armsynapse.SQLPoolMetadataSyncConfigsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolMetadataSyncConfigsServerTransport(srv *SQLPoolMetadataSyncConfigsServer) *SQLPoolMetadataSyncConfigsServerTransport {
	return &SQLPoolMetadataSyncConfigsServerTransport{srv: srv}
}

// SQLPoolMetadataSyncConfigsServerTransport connects instances of armsynapse.SQLPoolMetadataSyncConfigsClient to instances of SQLPoolMetadataSyncConfigsServer.
// Don't use this type directly, use NewSQLPoolMetadataSyncConfigsServerTransport instead.
type SQLPoolMetadataSyncConfigsServerTransport struct {
	srv *SQLPoolMetadataSyncConfigsServer
}

// Do implements the policy.Transporter interface for SQLPoolMetadataSyncConfigsServerTransport.
func (s *SQLPoolMetadataSyncConfigsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolMetadataSyncConfigsClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SQLPoolMetadataSyncConfigsClient.Get":
		resp, err = s.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolMetadataSyncConfigsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metadataSync/config`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.MetadataSyncConfig](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MetadataSyncConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolMetadataSyncConfigsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metadataSync/config`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MetadataSyncConfig, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
