//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package generated

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strconv"
	"time"
)

// MessagesClient contains the methods for the Messages group.
// Don't use this type directly, use NewMessagesClient() instead.
type MessagesClient struct {
	endpoint string
	pl       runtime.Pipeline
}

// NewMessagesClient creates a new instance of MessagesClient with the specified values.
//   - endpoint - The URL of the service account, queue or message that is the target of the desired operation.
//   - pl - the pipeline used for sending requests and handling responses.
func NewMessagesClient(endpoint string, pl runtime.Pipeline) *MessagesClient {
	client := &MessagesClient{
		endpoint: endpoint,
		pl:       pl,
	}
	return client
}

// Clear - The Clear operation deletes all messages from the specified queue.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-28
//   - options - MessagesClientClearOptions contains the optional parameters for the MessagesClient.Clear method.
func (client *MessagesClient) Clear(ctx context.Context, options *MessagesClientClearOptions) (MessagesClientClearResponse, error) {
	req, err := client.clearCreateRequest(ctx, options)
	if err != nil {
		return MessagesClientClearResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MessagesClientClearResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return MessagesClientClearResponse{}, runtime.NewResponseError(resp)
	}
	return client.clearHandleResponse(resp)
}

// clearCreateRequest creates the Clear request.
func (client *MessagesClient) clearCreateRequest(ctx context.Context, options *MessagesClientClearOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2018-03-28"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// clearHandleResponse handles the Clear response.
func (client *MessagesClient) clearHandleResponse(resp *http.Response) (MessagesClientClearResponse, error) {
	result := MessagesClientClearResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessagesClientClearResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Dequeue - The Dequeue operation retrieves one or more messages from the front of the queue.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-28
//   - options - MessagesClientDequeueOptions contains the optional parameters for the MessagesClient.Dequeue method.
func (client *MessagesClient) Dequeue(ctx context.Context, options *MessagesClientDequeueOptions) (MessagesClientDequeueResponse, error) {
	req, err := client.dequeueCreateRequest(ctx, options)
	if err != nil {
		return MessagesClientDequeueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MessagesClientDequeueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return MessagesClientDequeueResponse{}, runtime.NewResponseError(resp)
	}
	return client.dequeueHandleResponse(resp)
}

// dequeueCreateRequest creates the Dequeue request.
func (client *MessagesClient) dequeueCreateRequest(ctx context.Context, options *MessagesClientDequeueOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.NumberOfMessages != nil {
		reqQP.Set("numofmessages", strconv.FormatInt(int64(*options.NumberOfMessages), 10))
	}
	if options != nil && options.Visibilitytimeout != nil {
		reqQP.Set("visibilitytimeout", strconv.FormatInt(int64(*options.Visibilitytimeout), 10))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2018-03-28"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// dequeueHandleResponse handles the Dequeue response.
func (client *MessagesClient) dequeueHandleResponse(resp *http.Response) (MessagesClientDequeueResponse, error) {
	result := MessagesClientDequeueResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessagesClientDequeueResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result); err != nil {
		return MessagesClientDequeueResponse{}, err
	}
	return result, nil
}

// Enqueue - The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be specified
// to make the message invisible until the visibility timeout expires. A message must
// be in a format that can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size
// for versions 2011-08-18 and newer, or 8 KB in size for previous versions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-28
//   - queueMessage - A Message object which can be stored in a Queue
//   - options - MessagesClientEnqueueOptions contains the optional parameters for the MessagesClient.Enqueue method.
func (client *MessagesClient) Enqueue(ctx context.Context, queueMessage QueueMessage, options *MessagesClientEnqueueOptions) (MessagesClientEnqueueResponse, error) {
	req, err := client.enqueueCreateRequest(ctx, queueMessage, options)
	if err != nil {
		return MessagesClientEnqueueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MessagesClientEnqueueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return MessagesClientEnqueueResponse{}, runtime.NewResponseError(resp)
	}
	return client.enqueueHandleResponse(resp)
}

// enqueueCreateRequest creates the Enqueue request.
func (client *MessagesClient) enqueueCreateRequest(ctx context.Context, queueMessage QueueMessage, options *MessagesClientEnqueueOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Visibilitytimeout != nil {
		reqQP.Set("visibilitytimeout", strconv.FormatInt(int64(*options.Visibilitytimeout), 10))
	}
	if options != nil && options.MessageTimeToLive != nil {
		reqQP.Set("messagettl", strconv.FormatInt(int64(*options.MessageTimeToLive), 10))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2018-03-28"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, runtime.MarshalAsXML(req, queueMessage)
}

// enqueueHandleResponse handles the Enqueue response.
func (client *MessagesClient) enqueueHandleResponse(resp *http.Response) (MessagesClientEnqueueResponse, error) {
	result := MessagesClientEnqueueResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessagesClientEnqueueResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result); err != nil {
		return MessagesClientEnqueueResponse{}, err
	}
	return result, nil
}

// Peek - The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
// of the message.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-28
//   - options - MessagesClientPeekOptions contains the optional parameters for the MessagesClient.Peek method.
func (client *MessagesClient) Peek(ctx context.Context, options *MessagesClientPeekOptions) (MessagesClientPeekResponse, error) {
	req, err := client.peekCreateRequest(ctx, options)
	if err != nil {
		return MessagesClientPeekResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MessagesClientPeekResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return MessagesClientPeekResponse{}, runtime.NewResponseError(resp)
	}
	return client.peekHandleResponse(resp)
}

// peekCreateRequest creates the Peek request.
func (client *MessagesClient) peekCreateRequest(ctx context.Context, options *MessagesClientPeekOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("peekonly", "true")
	if options != nil && options.NumberOfMessages != nil {
		reqQP.Set("numofmessages", strconv.FormatInt(int64(*options.NumberOfMessages), 10))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2018-03-28"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// peekHandleResponse handles the Peek response.
func (client *MessagesClient) peekHandleResponse(resp *http.Response) (MessagesClientPeekResponse, error) {
	result := MessagesClientPeekResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessagesClientPeekResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result); err != nil {
		return MessagesClientPeekResponse{}, err
	}
	return result, nil
}
