// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/chat/v1/membership.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the member's relationship with a space. Other membership states
// might be supported in the future.
type Membership_MembershipState int32

const (
	// Default value. Don't use.
	Membership_MEMBERSHIP_STATE_UNSPECIFIED Membership_MembershipState = 0
	// The user is added to the space, and can participate in the space.
	Membership_JOINED Membership_MembershipState = 1
	// The user is invited to join the space, but hasn't joined it.
	Membership_INVITED Membership_MembershipState = 2
	// The user doesn't belong to the space and doesn't have a pending
	// invitation to join the space.
	Membership_NOT_A_MEMBER Membership_MembershipState = 3
)

// Enum value maps for Membership_MembershipState.
var (
	Membership_MembershipState_name = map[int32]string{
		0: "MEMBERSHIP_STATE_UNSPECIFIED",
		1: "JOINED",
		2: "INVITED",
		3: "NOT_A_MEMBER",
	}
	Membership_MembershipState_value = map[string]int32{
		"MEMBERSHIP_STATE_UNSPECIFIED": 0,
		"JOINED":                       1,
		"INVITED":                      2,
		"NOT_A_MEMBER":                 3,
	}
)

func (x Membership_MembershipState) Enum() *Membership_MembershipState {
	p := new(Membership_MembershipState)
	*p = x
	return p
}

func (x Membership_MembershipState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Membership_MembershipState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_membership_proto_enumTypes[0].Descriptor()
}

func (Membership_MembershipState) Type() protoreflect.EnumType {
	return &file_google_chat_v1_membership_proto_enumTypes[0]
}

func (x Membership_MembershipState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Membership_MembershipState.Descriptor instead.
func (Membership_MembershipState) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{0, 0}
}

// Represents a user's permitted actions in a Chat space. More enum values
// might be added in the future.
type Membership_MembershipRole int32

const (
	// Default value. For [users][google.chat.v1.Membership.member]: they
	// aren't a member of the space, but can be invited. For
	// [Google Groups][google.chat.v1.Membership.group_member]: they're always
	//
	//	assigned this role (other enum values might be used in the future).
	Membership_MEMBERSHIP_ROLE_UNSPECIFIED Membership_MembershipRole = 0
	// A member of the space. The user has basic permissions, like sending
	// messages to the space. In 1:1 and unnamed group conversations, everyone
	// has this role.
	Membership_ROLE_MEMBER Membership_MembershipRole = 1
	// A space manager. The user has all basic permissions plus administrative
	// permissions that let them manage the space, like adding or removing
	// members. Only supported in
	// [SpaceType.SPACE][google.chat.v1.Space.SpaceType].
	Membership_ROLE_MANAGER Membership_MembershipRole = 2
)

// Enum value maps for Membership_MembershipRole.
var (
	Membership_MembershipRole_name = map[int32]string{
		0: "MEMBERSHIP_ROLE_UNSPECIFIED",
		1: "ROLE_MEMBER",
		2: "ROLE_MANAGER",
	}
	Membership_MembershipRole_value = map[string]int32{
		"MEMBERSHIP_ROLE_UNSPECIFIED": 0,
		"ROLE_MEMBER":                 1,
		"ROLE_MANAGER":                2,
	}
)

func (x Membership_MembershipRole) Enum() *Membership_MembershipRole {
	p := new(Membership_MembershipRole)
	*p = x
	return p
}

func (x Membership_MembershipRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Membership_MembershipRole) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_membership_proto_enumTypes[1].Descriptor()
}

func (Membership_MembershipRole) Type() protoreflect.EnumType {
	return &file_google_chat_v1_membership_proto_enumTypes[1]
}

func (x Membership_MembershipRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Membership_MembershipRole.Descriptor instead.
func (Membership_MembershipRole) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{0, 1}
}

// Represents a membership relation in Google Chat, such as whether a user or
// Chat app is invited to, part of, or absent from a space.
type Membership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the membership, assigned by the server.
	//
	// Format: `spaces/{space}/members/{member}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the membership.
	State Membership_MembershipState `protobuf:"varint,2,opt,name=state,proto3,enum=google.chat.v1.Membership_MembershipState" json:"state,omitempty"`
	// Optional. User's role within a Chat space, which determines their permitted
	// actions in the space.
	//
	// This field can only be used as input in `UpdateMembership`.
	Role Membership_MembershipRole `protobuf:"varint,7,opt,name=role,proto3,enum=google.chat.v1.Membership_MembershipRole" json:"role,omitempty"`
	// Member associated with this membership. Other member types might be
	// supported in the future.
	//
	// Types that are assignable to MemberType:
	//
	//	*Membership_Member
	//	*Membership_GroupMember
	MemberType isMembership_MemberType `protobuf_oneof:"memberType"`
	// Optional. Immutable. The creation time of the membership, such as when a
	// member joined or was invited to join a space. This field is output only,
	// except when used to import historical memberships in import mode spaces.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. Immutable. The deletion time of the membership, such as when a
	// member left or was removed from a space. This field is output only, except
	// when used to import historical memberships in import mode spaces.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
}

func (x *Membership) Reset() {
	*x = Membership{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Membership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Membership) ProtoMessage() {}

func (x *Membership) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Membership.ProtoReflect.Descriptor instead.
func (*Membership) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{0}
}

func (x *Membership) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Membership) GetState() Membership_MembershipState {
	if x != nil {
		return x.State
	}
	return Membership_MEMBERSHIP_STATE_UNSPECIFIED
}

func (x *Membership) GetRole() Membership_MembershipRole {
	if x != nil {
		return x.Role
	}
	return Membership_MEMBERSHIP_ROLE_UNSPECIFIED
}

func (m *Membership) GetMemberType() isMembership_MemberType {
	if m != nil {
		return m.MemberType
	}
	return nil
}

func (x *Membership) GetMember() *User {
	if x, ok := x.GetMemberType().(*Membership_Member); ok {
		return x.Member
	}
	return nil
}

func (x *Membership) GetGroupMember() *Group {
	if x, ok := x.GetMemberType().(*Membership_GroupMember); ok {
		return x.GroupMember
	}
	return nil
}

func (x *Membership) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Membership) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

type isMembership_MemberType interface {
	isMembership_MemberType()
}

type Membership_Member struct {
	// The Google Chat user or app the membership corresponds to.
	// If your Chat app [authenticates as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// the output populates the
	// [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
	// `name` and `type`.
	Member *User `protobuf:"bytes,3,opt,name=member,proto3,oneof"`
}

type Membership_GroupMember struct {
	// The Google Group the membership corresponds to.
	// Only supports read operations. Other operations, like
	// creating or updating a membership, aren't currently supported.
	GroupMember *Group `protobuf:"bytes,5,opt,name=group_member,json=groupMember,proto3,oneof"`
}

func (*Membership_Member) isMembership_MemberType() {}

func (*Membership_GroupMember) isMembership_MemberType() {}

// Request message for creating a membership.
type CreateMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the space for which to create the
	// membership.
	//
	// Format: spaces/{space}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The membership relation to create.
	// The `memberType` field must contain a user with the `user.name` and
	// `user.type` fields populated. The server will assign a resource name
	// and overwrite anything specified.
	// When a Chat app creates a membership relation for a human user, it must use
	// the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
	// `user.name` with format `users/{user}`, where `{user}` can be the email
	// address for the user. For users in the same Workspace organization `{user}`
	// can also be the `id` of the
	// [person](https://developers.google.com/people/api/rest/v1/people) from the
	// People API, or the `id` for the user in the Directory API. For example, if
	// the People API Person profile ID for `user@example.com` is `123456789`, you
	// can add the user to the space by setting the `membership.member.name` to
	// `users/user@example.com` or `users/123456789`. When a Chat app creates a
	// membership relation for itself, it must use the `chat.memberships.app`
	// scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
	Membership *Membership `protobuf:"bytes,2,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *CreateMembershipRequest) Reset() {
	*x = CreateMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMembershipRequest) ProtoMessage() {}

func (x *CreateMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMembershipRequest.ProtoReflect.Descriptor instead.
func (*CreateMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{1}
}

func (x *CreateMembershipRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMembershipRequest) GetMembership() *Membership {
	if x != nil {
		return x.Membership
	}
	return nil
}

// Request message for updating a membership.
type UpdateMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The membership to update. Only fields specified by `update_mask`
	// are updated.
	Membership *Membership `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
	// Required. The field paths to update. Separate multiple values with commas
	// or use `*` to update all field paths.
	//
	// Currently supported field paths:
	//
	// - `role`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMembershipRequest) Reset() {
	*x = UpdateMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMembershipRequest) ProtoMessage() {}

func (x *UpdateMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMembershipRequest.ProtoReflect.Descriptor instead.
func (*UpdateMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateMembershipRequest) GetMembership() *Membership {
	if x != nil {
		return x.Membership
	}
	return nil
}

func (x *UpdateMembershipRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for listing memberships.
type ListMembershipsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the space for which to fetch a membership
	// list.
	//
	// Format: spaces/{space}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of memberships to return. The service might
	// return fewer than this value.
	//
	// If unspecified, at most 100 memberships are returned.
	//
	// The maximum value is 1000. If you use a value more than 1000, it's
	// automatically changed to 1000.
	//
	// Negative values return an `INVALID_ARGUMENT` error.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous call to list memberships.
	// Provide this parameter to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided should match the call that
	// provided the page token. Passing different values to the other parameters
	// might lead to unexpected results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A query filter.
	//
	// You can filter memberships by a member's role
	// ([`role`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members#membershiprole))
	// and type
	// ([`member.type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/User#type)).
	//
	// To filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`.
	//
	// To filter by type, set `member.type` to `HUMAN` or `BOT`.
	//
	// To filter by both role and type, use the `AND` operator. To filter by
	// either role or type, use the `OR` operator.
	//
	// For example, the following queries are valid:
	//
	// ```
	// role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
	// member.type = "HUMAN" AND role = "ROLE_MANAGER"
	// ```
	//
	// The following queries are invalid:
	//
	// ```
	// member.type = "HUMAN" AND member.type = "BOT"
	// role = "ROLE_MANAGER" AND role = "ROLE_MEMBER"
	// ```
	//
	// Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
	// error.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. When `true`, also returns memberships associated with a
	// [Google Group][google.chat.v1.Membership.group_member], in
	// addition to other types of memberships. If a
	// [filter][google.chat.v1.ListMembershipsRequest.filter] is set,
	// [Google Group][google.chat.v1.Membership.group_member]
	// memberships that don't match the filter criteria aren't returned.
	ShowGroups bool `protobuf:"varint,6,opt,name=show_groups,json=showGroups,proto3" json:"show_groups,omitempty"`
	// Optional. When `true`, also returns memberships associated with
	// [invited][google.chat.v1.Membership.MembershipState.INVITED] members, in
	// addition to other types of memberships. If a
	// filter is set,
	// [invited][google.chat.v1.Membership.MembershipState.INVITED] memberships
	// that don't match the filter criteria aren't returned.
	//
	// Currently requires [user
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
	ShowInvited bool `protobuf:"varint,7,opt,name=show_invited,json=showInvited,proto3" json:"show_invited,omitempty"`
}

func (x *ListMembershipsRequest) Reset() {
	*x = ListMembershipsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMembershipsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMembershipsRequest) ProtoMessage() {}

func (x *ListMembershipsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMembershipsRequest.ProtoReflect.Descriptor instead.
func (*ListMembershipsRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{3}
}

func (x *ListMembershipsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMembershipsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMembershipsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMembershipsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMembershipsRequest) GetShowGroups() bool {
	if x != nil {
		return x.ShowGroups
	}
	return false
}

func (x *ListMembershipsRequest) GetShowInvited() bool {
	if x != nil {
		return x.ShowInvited
	}
	return false
}

// Response to list memberships of the space.
type ListMembershipsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unordered list. List of memberships in the requested (or first) page.
	Memberships []*Membership `protobuf:"bytes,1,rep,name=memberships,proto3" json:"memberships,omitempty"`
	// A token that you can send as `pageToken` to retrieve the next page of
	// results. If empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMembershipsResponse) Reset() {
	*x = ListMembershipsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMembershipsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMembershipsResponse) ProtoMessage() {}

func (x *ListMembershipsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMembershipsResponse.ProtoReflect.Descriptor instead.
func (*ListMembershipsResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{4}
}

func (x *ListMembershipsResponse) GetMemberships() []*Membership {
	if x != nil {
		return x.Memberships
	}
	return nil
}

func (x *ListMembershipsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to get a membership of a space.
type GetMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the membership to retrieve.
	//
	// To get the app's own membership [by using user
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// you can optionally use `spaces/{space}/members/app`.
	//
	// Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`
	//
	// When [authenticated as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// you can use the user's email as an alias for `{member}`. For example,
	// `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the
	// email of the Google Chat user.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMembershipRequest) Reset() {
	*x = GetMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMembershipRequest) ProtoMessage() {}

func (x *GetMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMembershipRequest.ProtoReflect.Descriptor instead.
func (*GetMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{5}
}

func (x *GetMembershipRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to delete a membership in a space.
type DeleteMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the membership to delete. Chat apps can delete
	// human users' or their own memberships. Chat apps can't delete other apps'
	// memberships.
	//
	// When deleting a human membership, requires the `chat.memberships` scope and
	// `spaces/{space}/members/{member}` format. You can use the email as an
	// alias for `{member}`. For example,
	// `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the
	// email of the Google Chat user.
	//
	// When deleting an app membership, requires the `chat.memberships.app` scope
	// and `spaces/{space}/members/app` format.
	//
	// Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMembershipRequest) Reset() {
	*x = DeleteMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_membership_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMembershipRequest) ProtoMessage() {}

func (x *DeleteMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_membership_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMembershipRequest.ProtoReflect.Descriptor instead.
func (*DeleteMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_membership_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteMembershipRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_chat_v1_membership_proto protoreflect.FileDescriptor

var file_google_chat_v1_membership_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd0, 0x05, 0x0a, 0x0a, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x6f, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x3a, 0x0a, 0x0c, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41,
	0x05, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x5e, 0x0a, 0x0f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49,
	0x50, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4a, 0x4f, 0x49, 0x4e, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x49, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x10,
	0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x03,
	0x22, 0x54, 0x0a, 0x0e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x6f,
	0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50,
	0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x4d, 0x45, 0x4d, 0x42,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e,
	0x41, 0x47, 0x45, 0x52, 0x10, 0x02, 0x3a, 0x44, 0xea, 0x41, 0x41, 0x0a, 0x1e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x1f, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x42, 0x0c, 0x0a, 0x0a,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x17, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x9c, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x89, 0x02, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x73, 0x68, 0x6f, 0x77, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x68,
	0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x69, 0x74,
	0x65, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41,
	0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x06, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x52, 0x0a, 0x14, 0x47, 0x65, 0x74,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x55, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x42, 0xa8, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63,
	0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44,
	0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x43,
	0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_membership_proto_rawDescOnce sync.Once
	file_google_chat_v1_membership_proto_rawDescData = file_google_chat_v1_membership_proto_rawDesc
)

func file_google_chat_v1_membership_proto_rawDescGZIP() []byte {
	file_google_chat_v1_membership_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_membership_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_membership_proto_rawDescData)
	})
	return file_google_chat_v1_membership_proto_rawDescData
}

var file_google_chat_v1_membership_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_chat_v1_membership_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_chat_v1_membership_proto_goTypes = []interface{}{
	(Membership_MembershipState)(0), // 0: google.chat.v1.Membership.MembershipState
	(Membership_MembershipRole)(0),  // 1: google.chat.v1.Membership.MembershipRole
	(*Membership)(nil),              // 2: google.chat.v1.Membership
	(*CreateMembershipRequest)(nil), // 3: google.chat.v1.CreateMembershipRequest
	(*UpdateMembershipRequest)(nil), // 4: google.chat.v1.UpdateMembershipRequest
	(*ListMembershipsRequest)(nil),  // 5: google.chat.v1.ListMembershipsRequest
	(*ListMembershipsResponse)(nil), // 6: google.chat.v1.ListMembershipsResponse
	(*GetMembershipRequest)(nil),    // 7: google.chat.v1.GetMembershipRequest
	(*DeleteMembershipRequest)(nil), // 8: google.chat.v1.DeleteMembershipRequest
	(*User)(nil),                    // 9: google.chat.v1.User
	(*Group)(nil),                   // 10: google.chat.v1.Group
	(*timestamppb.Timestamp)(nil),   // 11: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),   // 12: google.protobuf.FieldMask
}
var file_google_chat_v1_membership_proto_depIdxs = []int32{
	0,  // 0: google.chat.v1.Membership.state:type_name -> google.chat.v1.Membership.MembershipState
	1,  // 1: google.chat.v1.Membership.role:type_name -> google.chat.v1.Membership.MembershipRole
	9,  // 2: google.chat.v1.Membership.member:type_name -> google.chat.v1.User
	10, // 3: google.chat.v1.Membership.group_member:type_name -> google.chat.v1.Group
	11, // 4: google.chat.v1.Membership.create_time:type_name -> google.protobuf.Timestamp
	11, // 5: google.chat.v1.Membership.delete_time:type_name -> google.protobuf.Timestamp
	2,  // 6: google.chat.v1.CreateMembershipRequest.membership:type_name -> google.chat.v1.Membership
	2,  // 7: google.chat.v1.UpdateMembershipRequest.membership:type_name -> google.chat.v1.Membership
	12, // 8: google.chat.v1.UpdateMembershipRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 9: google.chat.v1.ListMembershipsResponse.memberships:type_name -> google.chat.v1.Membership
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_chat_v1_membership_proto_init() }
func file_google_chat_v1_membership_proto_init() {
	if File_google_chat_v1_membership_proto != nil {
		return
	}
	file_google_chat_v1_group_proto_init()
	file_google_chat_v1_user_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_chat_v1_membership_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Membership); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_membership_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_membership_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_membership_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMembershipsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_membership_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMembershipsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_membership_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_membership_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_chat_v1_membership_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Membership_Member)(nil),
		(*Membership_GroupMember)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_membership_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_membership_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_membership_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_membership_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_membership_proto_msgTypes,
	}.Build()
	File_google_chat_v1_membership_proto = out.File
	file_google_chat_v1_membership_proto_rawDesc = nil
	file_google_chat_v1_membership_proto_goTypes = nil
	file_google_chat_v1_membership_proto_depIdxs = nil
}
