#pragma once
/*
 *  $Id: shader.h 28452 2025-08-26 07:27:52Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_SHADER_H__
#define __GWYUI_SHADER_H__

#include <gtk/gtk.h>
#include <libgwyddion/gradient.h>

G_BEGIN_DECLS

#define GWY_TYPE_SHADER            (gwy_shader_get_type())
#define GWY_SHADER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_SHADER, GwyShader))
#define GWY_SHADER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_SHADER, GwyShaderClass))
#define GWY_IS_SHADER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_SHADER))
#define GWY_IS_SHADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_SHADER))
#define GWY_SHADER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_SHADER, GwyShaderClass))

typedef struct _GwyShader             GwyShader;
typedef struct _GwyShaderClass        GwyShaderClass;
typedef struct _GwyShaderPrivate      GwyShaderPrivate;

struct _GwyShader {
    GtkWidget widget;
    GwyShaderPrivate *priv;
};

struct _GwyShaderClass {
    GtkWidgetClass parent_class;

    void (*angle_changed)(GwyShader *shader);
    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType        gwy_shader_get_type    (void)                   G_GNUC_CONST;
GtkWidget*   gwy_shader_new         (void);
gdouble      gwy_shader_get_theta   (GwyShader *shader);
gdouble      gwy_shader_get_phi     (GwyShader *shader);
void         gwy_shader_set_theta   (GwyShader *shader,
                                     gdouble theta);
void         gwy_shader_set_phi     (GwyShader *shader,
                                     gdouble phi);
void         gwy_shader_set_angle   (GwyShader *shader,
                                     gdouble theta,
                                     gdouble phi);
GwyGradient* gwy_shader_get_gradient(GwyShader *shader);
void         gwy_shader_set_gradient(GwyShader *shader,
                                     GwyGradient *gradient);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
