#!/usr/bin/env python
# extract all C gettext strings and convert them to tr() so lupdate can handle them.

import os
import re

gettext_re = re.compile(r'''
    N?_     # gettext marker
    \(      # left paren
    \s*     # spaces
    (".*?[^\\]") # quoted string (the char before the ending " cannot be \)
    \s*     # spaces
    \)      # right paren
    ''', re.DOTALL|re.VERBOSE)

print("""// Generated by extract_c_strs.py. Do not edit!!!
#if 0
#include <QObject>
""")

dirname = "./core"
for fn in os.listdir(dirname):
    if not fn.endswith(".c"):
        continue
    fpath = os.path.join(dirname, fn)
    with open(fpath, 'r') as f:
        code = f.read()
        strs = gettext_re.findall(code)
        if strs:
            print("// {}".format(fpath))
            for s in strs:
                print('QObject::tr({});'.format(s))
            print()
print("""
#endif
""")
