/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEdit;
import org.chefproject.core.CalendarEvent;
import org.chefproject.core.CalendarEventEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseCalendarService;
import org.chefproject.service.component.BaseXmlFileStorage;

public class XmlFileCalendarService
extends BaseCalendarService {
    protected String m_storagePath = null;

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_storagePath = data.getServletContext().getRealPath(this.getProperties().getProperty("path", "db/calendar.xml"));
        Log.info("chef", this + ".init(RunData): storage path: " + this.m_storagePath);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_calendarCache.disable();
    }

    protected BaseCalendarService.Storage newStorage() {
        return new XmlFileStorage(this);
    }

    protected class XmlFileStorage
    extends BaseXmlFileStorage
    implements BaseCalendarService.Storage {
        public XmlFileStorage(StorageUser user) {
            super(XmlFileCalendarService.this.m_storagePath, "calendars", "calendar", "event", user);
        }

        public boolean checkCalendar(String ref) {
            return super.getContainer(ref) != null;
        }

        public Calendar getCalendar(String ref) {
            return (Calendar)super.getContainer(ref);
        }

        public List getCalendars() {
            return super.getAllContainers();
        }

        public CalendarEdit putCalendar(String ref) {
            return (CalendarEdit)super.putContainer(ref);
        }

        public CalendarEdit editCalendar(String ref) {
            return (CalendarEdit)super.editContainer(ref);
        }

        public void commitCalendar(CalendarEdit edit) {
            super.commitContainer(edit);
        }

        public void cancelCalendar(CalendarEdit edit) {
            super.cancelContainer(edit);
        }

        public void removeCalendar(CalendarEdit edit) {
            super.removeContainer(edit);
        }

        public boolean checkEvent(Calendar calendar, String id) {
            return super.checkResource(calendar.getReference(), id);
        }

        public CalendarEvent getEvent(Calendar calendar, String id) {
            return (CalendarEvent)super.getResource(calendar.getReference(), id);
        }

        public List getEvents(Calendar calendar) {
            return super.getAllResources(calendar.getReference());
        }

        public CalendarEventEdit putEvent(Calendar calendar, String id) {
            return (CalendarEventEdit)super.putResource(calendar.getReference(), id, null);
        }

        public CalendarEventEdit editEvent(Calendar calendar, String messageId) {
            return (CalendarEventEdit)super.editResource(calendar.getReference(), messageId);
        }

        public void commitEvent(Calendar calendar, CalendarEventEdit edit) {
            super.commitResource(calendar.getReference(), edit);
        }

        public void cancelEvent(Calendar calendar, CalendarEventEdit edit) {
            super.cancelResource(calendar.getReference(), edit);
        }

        public void removeEvent(Calendar calendar, CalendarEventEdit edit) {
            super.removeResource(calendar.getReference(), edit);
        }
    }
}

