# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ApiKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the API."""

    REST = "rest"
    """A Representational State Transfer Api"""
    GRAPHQL = "graphql"
    """A Graph query language Api"""
    GRPC = "grpc"
    """A gRPC Api"""
    SOAP = "soap"
    """A SOAP Api"""
    WEBHOOK = "webhook"
    """Web Hook"""
    WEBSOCKET = "websocket"
    """Web Socket"""


class ApiSpecExportResultFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Result format for exported Api spec."""

    INLINE = "inline"
    """The inlined content of a specification document."""
    LINK = "link"
    """The link to the result of the export operation. The URL is valid for 5 minutes."""


class ApiSpecImportSourceFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source format for imported Api spec."""

    INLINE = "inline"
    """The inlined content of a specification document."""
    LINK = "link"
    """The link to a specification document hosted on a publicly accessible internet
    #: address."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DeploymentState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the Deployment."""

    ACTIVE = "active"
    """Active State"""
    INACTIVE = "inactive"
    """Inactive State"""


class EnvironmentKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of environment."""

    DEVELOPMENT = "development"
    """Development environment"""
    TESTING = "testing"
    """Testing environment"""
    STAGING = "staging"
    """Staging environment"""
    PRODUCTION = "production"
    """Production environment"""


class EnvironmentServerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of environment server."""

    AZURE_API_MANAGEMENT = "Azure API Management"
    """Api Management Server"""
    AZURE_COMPUTE_SERVICE = "Azure compute service"
    """Compute server"""
    APIGEE_API_MANAGEMENT = "Apigee API Management"
    """Apigee server"""
    AWS_API_GATEWAY = "AWS API Gateway"
    """AWS Api Gateway server"""
    KONG_API_GATEWAY = "Kong API Gateway"
    """Kong API Gateway server"""
    KUBERNETES = "Kubernetes"
    """Kubernetes server"""
    MULE_SOFT_API_MANAGEMENT = "MuleSoft API Management"
    """Mulesoft Api Management server"""


class LifecycleStage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The stage of the Api development lifecycle."""

    DESIGN = "design"
    """design stage"""
    DEVELOPMENT = "development"
    """development stage"""
    TESTING = "testing"
    """testing stage"""
    PREVIEW = "preview"
    """In preview"""
    PRODUCTION = "production"
    """In production"""
    DEPRECATED = "deprecated"
    """deprecated stage"""
    RETIRED = "retired"
    """Retired stage"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class MetadataAssignmentEntity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Assignment entity for Metadata."""

    API = "api"
    """Assigned to API"""
    ENVIRONMENT = "environment"
    """Assigned to Environment"""
    DEPLOYMENT = "deployment"
    """Assigned to Deployment"""


class MetadataSchemaExportFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The format for schema export."""

    INLINE = "inline"
    """The inlined content of a schema document."""
    LINK = "link"
    """The link to a schema document. The URL is valid for 5 minutes."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class Versions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The available API versions."""

    V2024_03_01 = "2024-03-01"
    """The initial service version"""
