# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ACR(_serialization.Model):
    """Information on the azure container registry.

    :ivar acr_subscription_id: ACR subscription id.
    :vartype acr_subscription_id: str
    :ivar acr_resource_group: ACR resource group.
    :vartype acr_resource_group: str
    :ivar acr_registry_name: ACR registry.
    :vartype acr_registry_name: str
    :ivar acr_repository_name: ACR repository.
    :vartype acr_repository_name: str
    """

    _attribute_map = {
        "acr_subscription_id": {"key": "acrSubscriptionId", "type": "str"},
        "acr_resource_group": {"key": "acrResourceGroup", "type": "str"},
        "acr_registry_name": {"key": "acrRegistryName", "type": "str"},
        "acr_repository_name": {"key": "acrRepositoryName", "type": "str"},
    }

    def __init__(
        self,
        *,
        acr_subscription_id: Optional[str] = None,
        acr_resource_group: Optional[str] = None,
        acr_registry_name: Optional[str] = None,
        acr_repository_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword acr_subscription_id: ACR subscription id.
        :paramtype acr_subscription_id: str
        :keyword acr_resource_group: ACR resource group.
        :paramtype acr_resource_group: str
        :keyword acr_registry_name: ACR registry.
        :paramtype acr_registry_name: str
        :keyword acr_repository_name: ACR repository.
        :paramtype acr_repository_name: str
        """
        super().__init__(**kwargs)
        self.acr_subscription_id = acr_subscription_id
        self.acr_resource_group = acr_resource_group
        self.acr_registry_name = acr_registry_name
        self.acr_repository_name = acr_repository_name


class ArtifactGenerationProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties used for generating artifacts such as Dockerfiles and manifests.

    :ivar generation_language: The programming language used. Known values are: "clojure",
     "csharp", "erlang", "go", "gomodule", "gradle", "java", "javascript", "php", "python", "ruby",
     "rust", and "swift".
    :vartype generation_language: str or ~azure.mgmt.devhub.models.GenerationLanguage
    :ivar language_version: The version of the language image used for execution in the generated
     dockerfile.
    :vartype language_version: str
    :ivar builder_version: The version of the language image used for building the code in the
     generated dockerfile.
    :vartype builder_version: str
    :ivar port: The port the application is exposed on.
    :vartype port: str
    :ivar app_name: The name of the app.
    :vartype app_name: str
    :ivar dockerfile_output_directory: The directory to output the generated Dockerfile to.
    :vartype dockerfile_output_directory: str
    :ivar manifest_output_directory: The directory to output the generated manifests to.
    :vartype manifest_output_directory: str
    :ivar dockerfile_generation_mode: The mode of generation to be used for generating Dockerfiles.
     Known values are: "enabled" and "disabled".
    :vartype dockerfile_generation_mode: str or ~azure.mgmt.devhub.models.DockerfileGenerationMode
    :ivar manifest_generation_mode: The mode of generation to be used for generating Manifest.
     Known values are: "enabled" and "disabled".
    :vartype manifest_generation_mode: str or ~azure.mgmt.devhub.models.ManifestGenerationMode
    :ivar manifest_type: Determines the type of manifests to be generated. Known values are: "helm"
     and "kube".
    :vartype manifest_type: str or ~azure.mgmt.devhub.models.GenerationManifestType
    :ivar image_name: The name of the image to be generated.
    :vartype image_name: str
    :ivar namespace: The namespace to deploy the application to.
    :vartype namespace: str
    :ivar image_tag: The tag to apply to the generated image.
    :vartype image_tag: str
    """

    _attribute_map = {
        "generation_language": {"key": "generationLanguage", "type": "str"},
        "language_version": {"key": "languageVersion", "type": "str"},
        "builder_version": {"key": "builderVersion", "type": "str"},
        "port": {"key": "port", "type": "str"},
        "app_name": {"key": "appName", "type": "str"},
        "dockerfile_output_directory": {"key": "dockerfileOutputDirectory", "type": "str"},
        "manifest_output_directory": {"key": "manifestOutputDirectory", "type": "str"},
        "dockerfile_generation_mode": {"key": "dockerfileGenerationMode", "type": "str"},
        "manifest_generation_mode": {"key": "manifestGenerationMode", "type": "str"},
        "manifest_type": {"key": "manifestType", "type": "str"},
        "image_name": {"key": "imageName", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "image_tag": {"key": "imageTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        generation_language: Optional[Union[str, "_models.GenerationLanguage"]] = None,
        language_version: Optional[str] = None,
        builder_version: Optional[str] = None,
        port: Optional[str] = None,
        app_name: Optional[str] = None,
        dockerfile_output_directory: Optional[str] = None,
        manifest_output_directory: Optional[str] = None,
        dockerfile_generation_mode: Optional[Union[str, "_models.DockerfileGenerationMode"]] = None,
        manifest_generation_mode: Optional[Union[str, "_models.ManifestGenerationMode"]] = None,
        manifest_type: Optional[Union[str, "_models.GenerationManifestType"]] = None,
        image_name: Optional[str] = None,
        namespace: Optional[str] = None,
        image_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword generation_language: The programming language used. Known values are: "clojure",
         "csharp", "erlang", "go", "gomodule", "gradle", "java", "javascript", "php", "python", "ruby",
         "rust", and "swift".
        :paramtype generation_language: str or ~azure.mgmt.devhub.models.GenerationLanguage
        :keyword language_version: The version of the language image used for execution in the
         generated dockerfile.
        :paramtype language_version: str
        :keyword builder_version: The version of the language image used for building the code in the
         generated dockerfile.
        :paramtype builder_version: str
        :keyword port: The port the application is exposed on.
        :paramtype port: str
        :keyword app_name: The name of the app.
        :paramtype app_name: str
        :keyword dockerfile_output_directory: The directory to output the generated Dockerfile to.
        :paramtype dockerfile_output_directory: str
        :keyword manifest_output_directory: The directory to output the generated manifests to.
        :paramtype manifest_output_directory: str
        :keyword dockerfile_generation_mode: The mode of generation to be used for generating
         Dockerfiles. Known values are: "enabled" and "disabled".
        :paramtype dockerfile_generation_mode: str or
         ~azure.mgmt.devhub.models.DockerfileGenerationMode
        :keyword manifest_generation_mode: The mode of generation to be used for generating Manifest.
         Known values are: "enabled" and "disabled".
        :paramtype manifest_generation_mode: str or ~azure.mgmt.devhub.models.ManifestGenerationMode
        :keyword manifest_type: Determines the type of manifests to be generated. Known values are:
         "helm" and "kube".
        :paramtype manifest_type: str or ~azure.mgmt.devhub.models.GenerationManifestType
        :keyword image_name: The name of the image to be generated.
        :paramtype image_name: str
        :keyword namespace: The namespace to deploy the application to.
        :paramtype namespace: str
        :keyword image_tag: The tag to apply to the generated image.
        :paramtype image_tag: str
        """
        super().__init__(**kwargs)
        self.generation_language = generation_language
        self.language_version = language_version
        self.builder_version = builder_version
        self.port = port
        self.app_name = app_name
        self.dockerfile_output_directory = dockerfile_output_directory
        self.manifest_output_directory = manifest_output_directory
        self.dockerfile_generation_mode = dockerfile_generation_mode
        self.manifest_generation_mode = manifest_generation_mode
        self.manifest_type = manifest_type
        self.image_name = image_name
        self.namespace = namespace
        self.image_tag = image_tag


class DeleteWorkflowResponse(_serialization.Model):
    """delete response if content must be provided on delete operation.

    :ivar status: delete status message.
    :vartype status: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword status: delete status message.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.status = status


class DeploymentProperties(_serialization.Model):
    """DeploymentProperties.

    :ivar manifest_type: Determines the type of manifests within the repository. Known values are:
     "helm" and "kube".
    :vartype manifest_type: str or ~azure.mgmt.devhub.models.ManifestType
    :ivar kube_manifest_locations:
    :vartype kube_manifest_locations: list[str]
    :ivar helm_chart_path: Helm chart directory path in repository.
    :vartype helm_chart_path: str
    :ivar helm_values: Helm Values.yaml file location in repository.
    :vartype helm_values: str
    :ivar overrides: Manifest override values.
    :vartype overrides: dict[str, str]
    """

    _attribute_map = {
        "manifest_type": {"key": "manifestType", "type": "str"},
        "kube_manifest_locations": {"key": "kubeManifestLocations", "type": "[str]"},
        "helm_chart_path": {"key": "helmChartPath", "type": "str"},
        "helm_values": {"key": "helmValues", "type": "str"},
        "overrides": {"key": "overrides", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        manifest_type: Optional[Union[str, "_models.ManifestType"]] = None,
        kube_manifest_locations: Optional[List[str]] = None,
        helm_chart_path: Optional[str] = None,
        helm_values: Optional[str] = None,
        overrides: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword manifest_type: Determines the type of manifests within the repository. Known values
         are: "helm" and "kube".
        :paramtype manifest_type: str or ~azure.mgmt.devhub.models.ManifestType
        :keyword kube_manifest_locations:
        :paramtype kube_manifest_locations: list[str]
        :keyword helm_chart_path: Helm chart directory path in repository.
        :paramtype helm_chart_path: str
        :keyword helm_values: Helm Values.yaml file location in repository.
        :paramtype helm_values: str
        :keyword overrides: Manifest override values.
        :paramtype overrides: dict[str, str]
        """
        super().__init__(**kwargs)
        self.manifest_type = manifest_type
        self.kube_manifest_locations = kube_manifest_locations
        self.helm_chart_path = helm_chart_path
        self.helm_values = helm_values
        self.overrides = overrides


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.devhub.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.devhub.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.devhub.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.devhub.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GitHubOAuthCallRequest(_serialization.Model):
    """GitHubOAuth request object.

    :ivar redirect_url: The URL the client will redirect to on successful authentication. If empty,
     no redirect will occur.
    :vartype redirect_url: str
    """

    _attribute_map = {
        "redirect_url": {"key": "redirectUrl", "type": "str"},
    }

    def __init__(self, *, redirect_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword redirect_url: The URL the client will redirect to on successful authentication. If
         empty, no redirect will occur.
        :paramtype redirect_url: str
        """
        super().__init__(**kwargs)
        self.redirect_url = redirect_url


class GitHubOAuthInfoResponse(_serialization.Model):
    """URL used to authorize the Developer Hub GitHub App.

    :ivar auth_url: URL for authorizing the Developer Hub GitHub App.
    :vartype auth_url: str
    :ivar token: OAuth token used to make calls to GitHub.
    :vartype token: str
    """

    _attribute_map = {
        "auth_url": {"key": "authURL", "type": "str"},
        "token": {"key": "token", "type": "str"},
    }

    def __init__(self, *, auth_url: Optional[str] = None, token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword auth_url: URL for authorizing the Developer Hub GitHub App.
        :paramtype auth_url: str
        :keyword token: OAuth token used to make calls to GitHub.
        :paramtype token: str
        """
        super().__init__(**kwargs)
        self.auth_url = auth_url
        self.token = token


class GitHubOAuthListResponse(_serialization.Model):
    """The response from List GitHubOAuth operation.

    :ivar value: Singleton list response containing one GitHubOAuthResponse response.
    :vartype value: list[~azure.mgmt.devhub.models.GitHubOAuthResponse]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubOAuthResponse]"},
    }

    def __init__(self, *, value: Optional[List["_models.GitHubOAuthResponse"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Singleton list response containing one GitHubOAuthResponse response.
        :paramtype value: list[~azure.mgmt.devhub.models.GitHubOAuthResponse]
        """
        super().__init__(**kwargs)
        self.value = value


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devhub.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devhub.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class GitHubOAuthResponse(ProxyResource):
    """Singleton response of GitHubOAuth containing.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devhub.models.SystemData
    :ivar username: user making request.
    :vartype username: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "username": {"key": "properties.username", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: user making request.
        :paramtype username: str
        """
        super().__init__(**kwargs)
        self.username = username


class GitHubWorkflowProfileOidcCredentials(_serialization.Model):
    """The fields needed for OIDC with GitHub.

    :ivar azure_client_id: Azure Application Client ID.
    :vartype azure_client_id: str
    :ivar azure_tenant_id: Azure Directory (tenant) ID.
    :vartype azure_tenant_id: str
    """

    _attribute_map = {
        "azure_client_id": {"key": "azureClientId", "type": "str"},
        "azure_tenant_id": {"key": "azureTenantId", "type": "str"},
    }

    def __init__(
        self, *, azure_client_id: Optional[str] = None, azure_tenant_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword azure_client_id: Azure Application Client ID.
        :paramtype azure_client_id: str
        :keyword azure_tenant_id: Azure Directory (tenant) ID.
        :paramtype azure_tenant_id: str
        """
        super().__init__(**kwargs)
        self.azure_client_id = azure_client_id
        self.azure_tenant_id = azure_tenant_id


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.devhub.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.devhub.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.devhub.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.devhub.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.devhub.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.devhub.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.devhub.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.devhub.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.devhub.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Resource tags.

    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devhub.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Workflow(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Resource representation of a workflow.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devhub.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar generation_language: The programming language used. Known values are: "clojure",
     "csharp", "erlang", "go", "gomodule", "gradle", "java", "javascript", "php", "python", "ruby",
     "rust", and "swift".
    :vartype generation_language: str or ~azure.mgmt.devhub.models.GenerationLanguage
    :ivar language_version: The version of the language image used for execution in the generated
     dockerfile.
    :vartype language_version: str
    :ivar builder_version: The version of the language image used for building the code in the
     generated dockerfile.
    :vartype builder_version: str
    :ivar port: The port the application is exposed on.
    :vartype port: str
    :ivar app_name: The name of the app.
    :vartype app_name: str
    :ivar dockerfile_output_directory: The directory to output the generated Dockerfile to.
    :vartype dockerfile_output_directory: str
    :ivar manifest_output_directory: The directory to output the generated manifests to.
    :vartype manifest_output_directory: str
    :ivar dockerfile_generation_mode: The mode of generation to be used for generating Dockerfiles.
     Known values are: "enabled" and "disabled".
    :vartype dockerfile_generation_mode: str or ~azure.mgmt.devhub.models.DockerfileGenerationMode
    :ivar manifest_generation_mode: The mode of generation to be used for generating Manifest.
     Known values are: "enabled" and "disabled".
    :vartype manifest_generation_mode: str or ~azure.mgmt.devhub.models.ManifestGenerationMode
    :ivar manifest_type: Determines the type of manifests to be generated. Known values are: "helm"
     and "kube".
    :vartype manifest_type: str or ~azure.mgmt.devhub.models.GenerationManifestType
    :ivar image_name: The name of the image to be generated.
    :vartype image_name: str
    :ivar namespace_properties_artifact_generation_properties_namespace: The namespace to deploy
     the application to.
    :vartype namespace_properties_artifact_generation_properties_namespace: str
    :ivar image_tag: The tag to apply to the generated image.
    :vartype image_tag: str
    :ivar repository_owner: Repository Owner.
    :vartype repository_owner: str
    :ivar repository_name: Repository Name.
    :vartype repository_name: str
    :ivar branch_name: Repository Branch Name.
    :vartype branch_name: str
    :ivar dockerfile: Path to the Dockerfile within the repository.
    :vartype dockerfile: str
    :ivar docker_build_context: Path to Dockerfile Build Context within the repository.
    :vartype docker_build_context: str
    :ivar deployment_properties:
    :vartype deployment_properties: ~azure.mgmt.devhub.models.DeploymentProperties
    :ivar namespace_properties_github_workflow_profile_namespace: Kubernetes namespace the
     application is deployed to.
    :vartype namespace_properties_github_workflow_profile_namespace: str
    :ivar acr: Information on the azure container registry.
    :vartype acr: ~azure.mgmt.devhub.models.ACR
    :ivar oidc_credentials: The fields needed for OIDC with GitHub.
    :vartype oidc_credentials: ~azure.mgmt.devhub.models.GitHubWorkflowProfileOidcCredentials
    :ivar aks_resource_id: The Azure Kubernetes Cluster Resource the application will be deployed
     to.
    :vartype aks_resource_id: str
    :ivar pr_url: The URL to the Pull Request submitted against the users repository.
    :vartype pr_url: str
    :ivar pull_number: The number associated with the submitted pull request.
    :vartype pull_number: int
    :ivar pr_status: The status of the Pull Request submitted against the users repository. Known
     values are: "unknown", "submitted", "merged", and "removed".
    :vartype pr_status: str or ~azure.mgmt.devhub.models.PullRequestStatus
    :ivar last_workflow_run:
    :vartype last_workflow_run: ~azure.mgmt.devhub.models.WorkflowRun
    :ivar auth_status: Determines the authorization status of requests. Known values are:
     "Authorized", "NotFound", and "Error".
    :vartype auth_status: str or ~azure.mgmt.devhub.models.AuthorizationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "pr_url": {"readonly": True},
        "pull_number": {"readonly": True},
        "pr_status": {"readonly": True},
        "auth_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "generation_language": {"key": "properties.artifactGenerationProperties.generationLanguage", "type": "str"},
        "language_version": {"key": "properties.artifactGenerationProperties.languageVersion", "type": "str"},
        "builder_version": {"key": "properties.artifactGenerationProperties.builderVersion", "type": "str"},
        "port": {"key": "properties.artifactGenerationProperties.port", "type": "str"},
        "app_name": {"key": "properties.artifactGenerationProperties.appName", "type": "str"},
        "dockerfile_output_directory": {
            "key": "properties.artifactGenerationProperties.dockerfileOutputDirectory",
            "type": "str",
        },
        "manifest_output_directory": {
            "key": "properties.artifactGenerationProperties.manifestOutputDirectory",
            "type": "str",
        },
        "dockerfile_generation_mode": {
            "key": "properties.artifactGenerationProperties.dockerfileGenerationMode",
            "type": "str",
        },
        "manifest_generation_mode": {
            "key": "properties.artifactGenerationProperties.manifestGenerationMode",
            "type": "str",
        },
        "manifest_type": {"key": "properties.artifactGenerationProperties.manifestType", "type": "str"},
        "image_name": {"key": "properties.artifactGenerationProperties.imageName", "type": "str"},
        "namespace_properties_artifact_generation_properties_namespace": {
            "key": "properties.artifactGenerationProperties.namespace",
            "type": "str",
        },
        "image_tag": {"key": "properties.artifactGenerationProperties.imageTag", "type": "str"},
        "repository_owner": {"key": "properties.githubWorkflowProfile.repositoryOwner", "type": "str"},
        "repository_name": {"key": "properties.githubWorkflowProfile.repositoryName", "type": "str"},
        "branch_name": {"key": "properties.githubWorkflowProfile.branchName", "type": "str"},
        "dockerfile": {"key": "properties.githubWorkflowProfile.dockerfile", "type": "str"},
        "docker_build_context": {"key": "properties.githubWorkflowProfile.dockerBuildContext", "type": "str"},
        "deployment_properties": {
            "key": "properties.githubWorkflowProfile.deploymentProperties",
            "type": "DeploymentProperties",
        },
        "namespace_properties_github_workflow_profile_namespace": {
            "key": "properties.githubWorkflowProfile.namespace",
            "type": "str",
        },
        "acr": {"key": "properties.githubWorkflowProfile.acr", "type": "ACR"},
        "oidc_credentials": {
            "key": "properties.githubWorkflowProfile.oidcCredentials",
            "type": "GitHubWorkflowProfileOidcCredentials",
        },
        "aks_resource_id": {"key": "properties.githubWorkflowProfile.aksResourceId", "type": "str"},
        "pr_url": {"key": "properties.githubWorkflowProfile.prURL", "type": "str"},
        "pull_number": {"key": "properties.githubWorkflowProfile.pullNumber", "type": "int"},
        "pr_status": {"key": "properties.githubWorkflowProfile.prStatus", "type": "str"},
        "last_workflow_run": {"key": "properties.githubWorkflowProfile.lastWorkflowRun", "type": "WorkflowRun"},
        "auth_status": {"key": "properties.githubWorkflowProfile.authStatus", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        generation_language: Optional[Union[str, "_models.GenerationLanguage"]] = None,
        language_version: Optional[str] = None,
        builder_version: Optional[str] = None,
        port: Optional[str] = None,
        app_name: Optional[str] = None,
        dockerfile_output_directory: Optional[str] = None,
        manifest_output_directory: Optional[str] = None,
        dockerfile_generation_mode: Optional[Union[str, "_models.DockerfileGenerationMode"]] = None,
        manifest_generation_mode: Optional[Union[str, "_models.ManifestGenerationMode"]] = None,
        manifest_type: Optional[Union[str, "_models.GenerationManifestType"]] = None,
        image_name: Optional[str] = None,
        namespace_properties_artifact_generation_properties_namespace: Optional[str] = None,
        image_tag: Optional[str] = None,
        repository_owner: Optional[str] = None,
        repository_name: Optional[str] = None,
        branch_name: Optional[str] = None,
        dockerfile: Optional[str] = None,
        docker_build_context: Optional[str] = None,
        deployment_properties: Optional["_models.DeploymentProperties"] = None,
        namespace_properties_github_workflow_profile_namespace: Optional[str] = None,
        acr: Optional["_models.ACR"] = None,
        oidc_credentials: Optional["_models.GitHubWorkflowProfileOidcCredentials"] = None,
        aks_resource_id: Optional[str] = None,
        last_workflow_run: Optional["_models.WorkflowRun"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword generation_language: The programming language used. Known values are: "clojure",
         "csharp", "erlang", "go", "gomodule", "gradle", "java", "javascript", "php", "python", "ruby",
         "rust", and "swift".
        :paramtype generation_language: str or ~azure.mgmt.devhub.models.GenerationLanguage
        :keyword language_version: The version of the language image used for execution in the
         generated dockerfile.
        :paramtype language_version: str
        :keyword builder_version: The version of the language image used for building the code in the
         generated dockerfile.
        :paramtype builder_version: str
        :keyword port: The port the application is exposed on.
        :paramtype port: str
        :keyword app_name: The name of the app.
        :paramtype app_name: str
        :keyword dockerfile_output_directory: The directory to output the generated Dockerfile to.
        :paramtype dockerfile_output_directory: str
        :keyword manifest_output_directory: The directory to output the generated manifests to.
        :paramtype manifest_output_directory: str
        :keyword dockerfile_generation_mode: The mode of generation to be used for generating
         Dockerfiles. Known values are: "enabled" and "disabled".
        :paramtype dockerfile_generation_mode: str or
         ~azure.mgmt.devhub.models.DockerfileGenerationMode
        :keyword manifest_generation_mode: The mode of generation to be used for generating Manifest.
         Known values are: "enabled" and "disabled".
        :paramtype manifest_generation_mode: str or ~azure.mgmt.devhub.models.ManifestGenerationMode
        :keyword manifest_type: Determines the type of manifests to be generated. Known values are:
         "helm" and "kube".
        :paramtype manifest_type: str or ~azure.mgmt.devhub.models.GenerationManifestType
        :keyword image_name: The name of the image to be generated.
        :paramtype image_name: str
        :keyword namespace_properties_artifact_generation_properties_namespace: The namespace to deploy
         the application to.
        :paramtype namespace_properties_artifact_generation_properties_namespace: str
        :keyword image_tag: The tag to apply to the generated image.
        :paramtype image_tag: str
        :keyword repository_owner: Repository Owner.
        :paramtype repository_owner: str
        :keyword repository_name: Repository Name.
        :paramtype repository_name: str
        :keyword branch_name: Repository Branch Name.
        :paramtype branch_name: str
        :keyword dockerfile: Path to the Dockerfile within the repository.
        :paramtype dockerfile: str
        :keyword docker_build_context: Path to Dockerfile Build Context within the repository.
        :paramtype docker_build_context: str
        :keyword deployment_properties:
        :paramtype deployment_properties: ~azure.mgmt.devhub.models.DeploymentProperties
        :keyword namespace_properties_github_workflow_profile_namespace: Kubernetes namespace the
         application is deployed to.
        :paramtype namespace_properties_github_workflow_profile_namespace: str
        :keyword acr: Information on the azure container registry.
        :paramtype acr: ~azure.mgmt.devhub.models.ACR
        :keyword oidc_credentials: The fields needed for OIDC with GitHub.
        :paramtype oidc_credentials: ~azure.mgmt.devhub.models.GitHubWorkflowProfileOidcCredentials
        :keyword aks_resource_id: The Azure Kubernetes Cluster Resource the application will be
         deployed to.
        :paramtype aks_resource_id: str
        :keyword last_workflow_run:
        :paramtype last_workflow_run: ~azure.mgmt.devhub.models.WorkflowRun
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.generation_language = generation_language
        self.language_version = language_version
        self.builder_version = builder_version
        self.port = port
        self.app_name = app_name
        self.dockerfile_output_directory = dockerfile_output_directory
        self.manifest_output_directory = manifest_output_directory
        self.dockerfile_generation_mode = dockerfile_generation_mode
        self.manifest_generation_mode = manifest_generation_mode
        self.manifest_type = manifest_type
        self.image_name = image_name
        self.namespace_properties_artifact_generation_properties_namespace = (
            namespace_properties_artifact_generation_properties_namespace
        )
        self.image_tag = image_tag
        self.repository_owner = repository_owner
        self.repository_name = repository_name
        self.branch_name = branch_name
        self.dockerfile = dockerfile
        self.docker_build_context = docker_build_context
        self.deployment_properties = deployment_properties
        self.namespace_properties_github_workflow_profile_namespace = (
            namespace_properties_github_workflow_profile_namespace
        )
        self.acr = acr
        self.oidc_credentials = oidc_credentials
        self.aks_resource_id = aks_resource_id
        self.pr_url = None
        self.pull_number = None
        self.pr_status = None
        self.last_workflow_run = last_workflow_run
        self.auth_status = None


class WorkflowListResult(_serialization.Model):
    """The response from List Workflows operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of workflows.
    :vartype value: list[~azure.mgmt.devhub.models.Workflow]
    :ivar next_link: The URL to the next set of workflow results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Workflow]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Workflow"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of workflows.
        :paramtype value: list[~azure.mgmt.devhub.models.Workflow]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkflowRun(_serialization.Model):
    """WorkflowRun.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar succeeded: Describes if the workflow run succeeded.
    :vartype succeeded: bool
    :ivar workflow_run_url: URL to the run of the workflow.
    :vartype workflow_run_url: str
    :ivar last_run_at: The timestamp of the last workflow run.
    :vartype last_run_at: ~datetime.datetime
    :ivar workflow_run_status: Describes the status of the workflow run. Known values are:
     "queued", "inprogress", and "completed".
    :vartype workflow_run_status: str or ~azure.mgmt.devhub.models.WorkflowRunStatus
    """

    _validation = {
        "succeeded": {"readonly": True},
        "workflow_run_url": {"readonly": True},
        "last_run_at": {"readonly": True},
    }

    _attribute_map = {
        "succeeded": {"key": "succeeded", "type": "bool"},
        "workflow_run_url": {"key": "workflowRunURL", "type": "str"},
        "last_run_at": {"key": "lastRunAt", "type": "iso-8601"},
        "workflow_run_status": {"key": "workflowRunStatus", "type": "str"},
    }

    def __init__(
        self, *, workflow_run_status: Optional[Union[str, "_models.WorkflowRunStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword workflow_run_status: Describes the status of the workflow run. Known values are:
         "queued", "inprogress", and "completed".
        :paramtype workflow_run_status: str or ~azure.mgmt.devhub.models.WorkflowRunStatus
        """
        super().__init__(**kwargs)
        self.succeeded = None
        self.workflow_run_url = None
        self.last_run_at = None
        self.workflow_run_status = workflow_run_status
