# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestVirtualEnclavesMgmtEnclaveConnectionOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(VirtualEnclavesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_get(self, resource_group):
        response = self.client.enclave_connection.get(
            resource_group_name=resource_group.name,
            enclave_connection_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_begin_create_or_update(self, resource_group):
        response = self.client.enclave_connection.begin_create_or_update(
            resource_group_name=resource_group.name,
            enclave_connection_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "communityResourceId": "str",
                    "destinationEndpointId": "str",
                    "sourceResourceId": "str",
                    "provisioningState": "str",
                    "resourceCollection": ["str"],
                    "sourceCidr": "str",
                    "state": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_begin_update(self, resource_group):
        response = self.client.enclave_connection.begin_update(
            resource_group_name=resource_group.name,
            enclave_connection_name="str",
            properties={"properties": {"sourceCidr": "str"}, "tags": {"str": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_begin_delete(self, resource_group):
        response = self.client.enclave_connection.begin_delete(
            resource_group_name=resource_group.name,
            enclave_connection_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_list_by_resource_group(self, resource_group):
        response = self.client.enclave_connection.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_list_by_subscription(self, resource_group):
        response = self.client.enclave_connection.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_begin_handle_approval_creation(self, resource_group):
        response = self.client.enclave_connection.begin_handle_approval_creation(
            resource_group_name=resource_group.name,
            enclave_connection_name="str",
            body={"approvalStatus": "Approved", "resourceRequestAction": "Create", "approvalCallbackPayload": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_enclave_connection_begin_handle_approval_deletion(self, resource_group):
        response = self.client.enclave_connection.begin_handle_approval_deletion(
            resource_group_name=resource_group.name,
            enclave_connection_name="str",
            body={"resourceRequestAction": "Create"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
