// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Buildable, FileFilterFlags, FileFilterInfo};
use glib::translate::*;
use std::{boxed::Box as Box_, fmt};

glib::wrapper! {
    #[doc(alias = "GtkFileFilter")]
    pub struct FileFilter(Object<ffi::GtkFileFilter>) @implements Buildable;

    match fn {
        type_ => || ffi::gtk_file_filter_get_type(),
    }
}

impl FileFilter {
    #[doc(alias = "gtk_file_filter_new")]
    pub fn new() -> FileFilter {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_file_filter_new()) }
    }

    #[doc(alias = "gtk_file_filter_new_from_gvariant")]
    #[doc(alias = "new_from_gvariant")]
    pub fn from_gvariant(variant: &glib::Variant) -> FileFilter {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_file_filter_new_from_gvariant(
                variant.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_file_filter_add_custom")]
    pub fn add_custom<P: Fn(&FileFilterInfo) -> bool + 'static>(
        &self,
        needed: FileFilterFlags,
        func: P,
    ) {
        let func_data: Box_<P> = Box_::new(func);
        unsafe extern "C" fn func_func<P: Fn(&FileFilterInfo) -> bool + 'static>(
            filter_info: *const ffi::GtkFileFilterInfo,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let filter_info = from_glib_borrow(filter_info);
            let callback: &P = &*(data as *mut _);
            (*callback)(&filter_info).into_glib()
        }
        let func = Some(func_func::<P> as _);
        unsafe extern "C" fn notify_func<P: Fn(&FileFilterInfo) -> bool + 'static>(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call4 = Some(notify_func::<P> as _);
        let super_callback0: Box_<P> = func_data;
        unsafe {
            ffi::gtk_file_filter_add_custom(
                self.to_glib_none().0,
                needed.into_glib(),
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    #[doc(alias = "gtk_file_filter_add_mime_type")]
    pub fn add_mime_type(&self, mime_type: &str) {
        unsafe {
            ffi::gtk_file_filter_add_mime_type(self.to_glib_none().0, mime_type.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_file_filter_add_pattern")]
    pub fn add_pattern(&self, pattern: &str) {
        unsafe {
            ffi::gtk_file_filter_add_pattern(self.to_glib_none().0, pattern.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_file_filter_add_pixbuf_formats")]
    pub fn add_pixbuf_formats(&self) {
        unsafe {
            ffi::gtk_file_filter_add_pixbuf_formats(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_file_filter_filter")]
    pub fn filter(&self, filter_info: &FileFilterInfo) -> bool {
        unsafe {
            from_glib(ffi::gtk_file_filter_filter(
                self.to_glib_none().0,
                filter_info.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_file_filter_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_file_filter_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_file_filter_get_needed")]
    #[doc(alias = "get_needed")]
    pub fn needed(&self) -> FileFilterFlags {
        unsafe { from_glib(ffi::gtk_file_filter_get_needed(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_file_filter_set_name")]
    pub fn set_name(&self, name: Option<&str>) {
        unsafe {
            ffi::gtk_file_filter_set_name(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_file_filter_to_gvariant")]
    pub fn to_gvariant(&self) -> Option<glib::Variant> {
        unsafe { from_glib_none(ffi::gtk_file_filter_to_gvariant(self.to_glib_none().0)) }
    }
}

impl Default for FileFilter {
    fn default() -> Self {
        Self::new()
    }
}

impl fmt::Display for FileFilter {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("FileFilter")
    }
}
