% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/222_export_opt.r
\name{Initial Control Functions}
\alias{Initial Control Functions}
\alias{.zmqopt_get}
\alias{.zmqopt_set}
\alias{.zmqopt_init}
\title{Initial controls in pbdZMQ}
\usage{
.zmqopt_get(main, sub = NULL, envir = .GlobalEnv)

.zmqopt_set(val, main, sub = NULL, envir = .GlobalEnv)

.zmqopt_init(envir = .GlobalEnv)
}
\arguments{
\item{main}{a variable to be get from or set to}

\item{sub}{a subvariable to be get from or set to}

\item{envir}{an environment where ZMQ controls locate}

\item{val}{a value to be set}
}
\value{
\code{.zmqopt_init()} initial the ZMQ control
at \code{envir}.
}
\description{
Initial control functions
}
\details{
\code{.zmqopt_init()} initials default ZMQ controls.
\code{.zmqopt_get()} gets a ZMQ control.
\code{.zmqopt_set()} sets a ZMQ control.
}
\examples{
\dontrun{
library(pbdZMQ, quietly = TRUE)

ls(.pbd_env)
rm(.pbd_env)
.zmqopt_init()
ls(.pbd_env)

.pbd_env$ZMQ.SR$BLOCK
pbd_opt(bytext = "ZMQ.SR$BLOCK = 0L")
}

}
\references{
ZeroMQ/4.1.0 API Reference:
\url{https://libzmq.readthedocs.io/en/zeromq4-1/}

Programming with Big Data in R Website: \url{https://pbdr.org/}
}
\seealso{
\code{\link{.pbd_env}}.
}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.
}
\keyword{programming}
