% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-deprecated-check_heterogeneity_bias.R
\name{check_heterogeneity_bias}
\alias{check_heterogeneity_bias}
\title{Check model predictor for heterogeneity bias \emph{(Deprecated)}}
\usage{
check_heterogeneity_bias(x, select = NULL, by = NULL, nested = FALSE)
}
\arguments{
\item{x}{A data frame or a mixed model object.}

\item{select}{Character vector (or formula) with names of variables to select
that should be checked. If \code{x} is a mixed model object, this argument
will be ignored.}

\item{by}{Character vector (or formula) with the name of the variable that
indicates the group- or cluster-ID. For cross-classified or nested designs,
\code{by} can also identify two or more variables as group- or cluster-IDs. If
the data is nested and should be treated as such, set \code{nested = TRUE}. Else,
if \code{by} defines two or more variables and \code{nested = FALSE}, a cross-classified
design is assumed. If \code{x} is a model object, this argument will be ignored.

For nested designs, \code{by} can be:
\itemize{
\item a character vector with the name of the variable that indicates the
levels, ordered from \emph{highest} level to \emph{lowest} (e.g.
\code{by = c("L4", "L3", "L2")}.
\item a character vector with variable names in the format \code{by = "L4/L3/L2"},
where the levels are separated by \code{/}.
}

See also section \emph{De-meaning for cross-classified designs} and
\emph{De-meaning for nested designs} in \code{\link[datawizard:demean]{datawizard::demean()}}.}

\item{nested}{Logical, if \code{TRUE}, the data is treated as nested. If \code{FALSE},
the data is treated as cross-classified. Only applies if \code{by} contains more
than one variable.}
}
\description{
\code{check_heterogeneity_bias()} checks if model predictors or variables may
cause a heterogeneity bias, i.e. if variables have any within-group variance
(\emph{Bell and Jones, 2015}).

\strong{We recommend using \code{\link[=check_group_variation]{check_group_variation()}} instead, for a more detailed
and flexible examination of group-wise variability.}
}
\examples{
data(iris)
iris$ID <- sample(1:4, nrow(iris), replace = TRUE) # fake-ID
check_heterogeneity_bias(iris, select = c("Sepal.Length", "Petal.Length"), by = "ID")
}
\references{
\itemize{
\item Bell A, Jones K. 2015. Explaining Fixed Effects: Random Effects
Modeling of Time-Series Cross-Sectional and Panel Data. Political Science
Research and Methods, 3(1), 133–153.
}
}
\seealso{
For further details, read the vignette
\url{https://easystats.github.io/parameters/articles/demean.html} and also
see documentation for \code{\link[datawizard:demean]{datawizard::demean()}}.

For a more detailed and flexible examination of group-wise variability, see
\code{\link[=check_group_variation]{check_group_variation()}}.
}
