# coding: binary
# Generated by generate-specs
require 'helper'

describe_moneta "adapter_mongo_official" do
  def features
    [:create, :expires, :increment]
  end

  def new_store
    Moneta::Adapters::MongoOfficial.new(db: "adapter_mongo",
                                        collection: 'official')
  end

  def load_value(value)
    Marshal.load(value)
  end

  include_context 'setup_store'
  it_should_behave_like 'concurrent_create'
  it_should_behave_like 'concurrent_increment'
  it_should_behave_like 'create'
  it_should_behave_like 'create_expires'
  it_should_behave_like 'expires'
  it_should_behave_like 'features'
  it_should_behave_like 'increment'
  it_should_behave_like 'multiprocess'
  it_should_behave_like 'null_stringkey_stringvalue'
  it_should_behave_like 'null_stringkey_hashvalue'
  it_should_behave_like 'null_stringkey_integervalue'
  it_should_behave_like 'null_pathkey_stringvalue'
  it_should_behave_like 'null_pathkey_hashvalue'
  it_should_behave_like 'null_pathkey_integervalue'
  it_should_behave_like 'persist_stringkey_stringvalue'
  it_should_behave_like 'persist_stringkey_hashvalue'
  it_should_behave_like 'persist_stringkey_integervalue'
  it_should_behave_like 'persist_pathkey_stringvalue'
  it_should_behave_like 'persist_pathkey_hashvalue'
  it_should_behave_like 'persist_pathkey_integervalue'
  it_should_behave_like 'returndifferent_stringkey_stringvalue'
  it_should_behave_like 'returndifferent_stringkey_hashvalue'
  it_should_behave_like 'returndifferent_pathkey_stringvalue'
  it_should_behave_like 'returndifferent_pathkey_hashvalue'
  it_should_behave_like 'store_stringkey_stringvalue'
  it_should_behave_like 'store_stringkey_hashvalue'
  it_should_behave_like 'store_stringkey_integervalue'
  it_should_behave_like 'store_pathkey_stringvalue'
  it_should_behave_like 'store_pathkey_hashvalue'
  it_should_behave_like 'store_pathkey_integervalue'
  it_should_behave_like 'store_large'
  it 'automatically deletes expired document' do
    store.store('key', 'val', expires: 5)

    i = 0
    query = store.instance_variable_get(:@collection).find(_id: ::BSON::Binary.new('key'))
    while i < 70 && query.first
      i += 1
      sleep 1 # Mongo needs up to 60 seconds
    end

    i.should be > 0 # Indicates that it took at least one sleep to expire
    query.count.should == 0
  end
end
