---
title: sumo
permalink: /sumo/
---

# From 30.000 feet

**sumo** is the simulation itself; it is a microscopic,
space-continuous, and time-discrete traffic flow simulation.

- **Purpose:** Simulates a defined scenario
- **System:** portable (Linux/Windows is tested); runs on command line
  - **Input (mandatory):**

    A) a road network as generated via
    [netconvert](netconvert.md) or
    [netgenerate](netgenerate.md), see [Building
    Networks](index.md#network_building)
    
    B) a set of routes (as generated by
    [duarouter](duarouter.md),
    [jtrrouter](jtrrouter.md),
    [dfrouter](dfrouter.md), or
    [activitygen](activitygen.md), see also [Definition of
    Vehicles, Vehicle Types, and
    Routes](Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md))

- **Input (optional):** Additional definitions of traffic lights,
    variable speed signs, output detectors etc.
- **Output:** SUMO allows to generate a wide set of outputs;
    visualization is done using [sumo-gui](sumo-gui.md)
- **Programming Language:** C++

# Usage Description

For a brief overview see
[Simulation/Basic_Definition](Simulation/Basic_Definition.md).
Model details and feature documentation can be found at [Simulation
topics](index.md#simulation).

## Options

You may use a XML schema definition file for setting up a SUMO
configuration:
[sumoConfiguration.xsd](http://sumo.dlr.de/xsd/sumoConfiguration.xsd).

### Configuration

| Option | Description |
|--------|-------------|
| **-c** {{DT_FILE}}<br> **--configuration-file** {{DT_FILE}} | Loads the named config on startup |
| **-C** {{DT_FILE}}<br> **--save-configuration** {{DT_FILE}} | Saves current configuration into FILE |
| **--save-template** {{DT_FILE}} | Saves a configuration template (empty) into FILE |
| **--save-schema** {{DT_FILE}} | Saves the configuration schema into FILE |
| **--save-commented** {{DT_BOOL}} | Adds comments to saved template, configuration, or schema; *default:* **false** |

### Input

| Option | Description |
|--------|-------------|
| **-n** {{DT_FILE}}<br> **--net-file** {{DT_FILE}} | Load road network description from FILE |
| **-r** {{DT_FILE}}<br> **--route-files** {{DT_FILE}} | Load routes descriptions from FILE(s) |
| **-a** {{DT_FILE}}<br> **--additional-files** {{DT_FILE}} | Load further descriptions from FILE(s) |
| **-w** {{DT_FILE}}<br> **--weight-files** {{DT_FILE}} | Load edge/lane weights for online rerouting from FILE |
| **-x** {{DT_STR}}<br> **--weight-attribute** {{DT_STR}} | Name of the xml attribute which gives the edge weight; *default:* **traveltime** |
| **--load-state** {{DT_FILE}} | Loads a network state from FILE |
| **--load-state.offset** {{DT_TIME}} | Shifts all times loaded from a saved state by the given offset; *default:* **0** |
| **--load-state.remove-vehicles** {{DT_STR[]}} | Removes vehicles with the given IDs from the loaded state |
| **--junction-taz** {{DT_BOOL}} | Initialize a TAZ for every junction to use attributes toJunction and fromJunction; *default:* **false** |

### Output

| Option | Description |
|--------|-------------|
| **--write-license** {{DT_BOOL}} | Include license info into every output file; *default:* **false** |
| **--output-prefix** {{DT_STR}} | Prefix which is applied to all output files. The special string 'TIME' is replaced by the current time. |
| **--precision** {{DT_INT}} | Defines the number of digits after the comma for floating point output; *default:* **2** |
| **--precision.geo** {{DT_INT}} | Defines the number of digits after the comma for lon,lat output; *default:* **6** |
| **-H** {{DT_BOOL}}<br> **--human-readable-time** {{DT_BOOL}} | Write time values as hour:minute:second or day:hour:minute:second rather than seconds; *default:* **false** |
| **--netstate-dump** {{DT_FILE}} | Save complete network states into FILE |
| **--netstate-dump.empty-edges** {{DT_BOOL}} | Write also empty edges completely when dumping; *default:* **false** |
| **--netstate-dump.precision** {{DT_INT}} | Write positions and speeds with the given precision (default 2); *default:* **2** |
| **--emission-output** {{DT_FILE}} | Save the emission values of each vehicle |
| **--emission-output.precision** {{DT_INT}} | Write emission values with the given precision (default 2); *default:* **2** |
| **--battery-output** {{DT_FILE}} | Save the battery values of each vehicle |
| **--battery-output.precision** {{DT_INT}} | Write battery values with the given precision (default 2); *default:* **2** |
| **--elechybrid-output** {{DT_FILE}} | Save the elecHybrid values of each vehicle |
| **--elechybrid-output.precision** {{DT_INT}} | Write elecHybrid values with the given precision (default 2); *default:* **2** |
| **--elechybrid-output.aggregated** {{DT_BOOL}} | Write elecHybrid values into one aggregated file; *default:* **false** |
| **--chargingstations-output** {{DT_FILE}} | Write data of charging stations |
| **--overheadwiresegments-output** {{DT_FILE}} | Write data of overhead wire segments |
| **--substations-output** {{DT_FILE}} | Write data of electrical substation stations |
| **--fcd-output** {{DT_FILE}} | Save the Floating Car Data |
| **--fcd-output.geo** {{DT_BOOL}} | Save the Floating Car Data using geo-coordinates (lon/lat); *default:* **false** |
| **--fcd-output.signals** {{DT_BOOL}} | Add the vehicle signal state to the FCD output (brake lights etc.); *default:* **false** |
| **--fcd-output.distance** {{DT_BOOL}} | Add kilometrage to the FCD output (linear referencing); *default:* **false** |
| **--fcd-output.acceleration** {{DT_BOOL}} | Add acceleration to the FCD output; *default:* **false** |
| **--fcd-output.max-leader-distance** {{DT_FLOAT}} | Add leader vehicle information to the FCD output (within the given distance); *default:* **-1** |
| **--fcd-output.params** {{DT_STR[]}} | Add generic parameter values to the FCD output |
| **--fcd-output.filter-edges.input-file** {{DT_FILE}} | Restrict fcd output to the edge selection from the given input file |
| **--full-output** {{DT_FILE}} | Save a lot of information for each timestep (very redundant) |
| **--queue-output** {{DT_FILE}} | Save the vehicle queues at the junctions (experimental) |
| **--vtk-output** {{DT_FILE}} | Save complete vehicle positions inclusive speed values in the VTK Format (usage: /path/out will produce /path/out_$TIMESTEP$.vtp files) |
| **--amitran-output** {{DT_FILE}} | Save the vehicle trajectories in the Amitran format |
| **--summary-output** {{DT_FILE}} | Save aggregated vehicle departure info into FILE |
| **--person-summary-output** {{DT_FILE}} | Save aggregated person counts into FILE |
| **--tripinfo-output** {{DT_FILE}} | Save single vehicle trip info into FILE |
| **--tripinfo-output.write-unfinished** {{DT_BOOL}} | Write tripinfo output for vehicles which have not arrived at simulation end; *default:* **false** |
| **--vehroute-output** {{DT_FILE}} | Save single vehicle route info into FILE |
| **--vehroute-output.exit-times** {{DT_BOOL}} | Write the exit times for all edges; *default:* **false** |
| **--vehroute-output.last-route** {{DT_BOOL}} | Write the last route only; *default:* **false** |
| **--vehroute-output.sorted** {{DT_BOOL}} | Sorts the output by departure time; *default:* **false** |
| **--vehroute-output.dua** {{DT_BOOL}} | Write the output in the duarouter alternatives style; *default:* **false** |
| **--vehroute-output.cost** {{DT_BOOL}} | Write costs for all routes; *default:* **false** |
| **--vehroute-output.intended-depart** {{DT_BOOL}} | Write the output with the intended instead of the real departure time; *default:* **false** |
| **--vehroute-output.route-length** {{DT_BOOL}} | Include total route length in the output; *default:* **false** |
| **--vehroute-output.write-unfinished** {{DT_BOOL}} | Write vehroute output for vehicles which have not arrived at simulation end; *default:* **false** |
| **--vehroute-output.skip-ptlines** {{DT_BOOL}} | Skip vehroute output for public transport vehicles; *default:* **false** |
| **--vehroute-output.incomplete** {{DT_BOOL}} | Include invalid routes and route stubs in vehroute output; *default:* **false** |
| **--vehroute-output.stop-edges** {{DT_BOOL}} | Include information about edges between stops; *default:* **false** |
| **--link-output** {{DT_FILE}} | Save links states into FILE |
| **--railsignal-block-output** {{DT_FILE}} | Save railsignal-blocks into FILE |
| **--bt-output** {{DT_FILE}} | Save bluetooth visibilities into FILE (in conjunction with device.btreceiver and device.btsender) |
| **--lanechange-output** {{DT_FILE}} | Record lane changes and their motivations for all vehicles into FILE |
| **--lanechange-output.started** {{DT_BOOL}} | Record start of lane change manoeuvres; *default:* **false** |
| **--lanechange-output.ended** {{DT_BOOL}} | Record end of lane change manoeuvres; *default:* **false** |
| **--lanechange-output.xy** {{DT_BOOL}} | Record coordinates of lane change manoeuvres; *default:* **false** |
| **--stop-output** {{DT_FILE}} | Record stops and loading/unloading of passenger and containers for all vehicles into FILE |
| **--statistic-output** {{DT_FILE}} | Write overall statistics into FILE |
| **--save-state.times** {{DT_STR[]}} | Use TIME[] as times at which a network state written |
| **--save-state.period** {{DT_TIME}} | save state repeatedly after TIME period; *default:* **-1** |
| **--save-state.prefix** {{DT_FILE}} | Prefix for network states; *default:* **state** |
| **--save-state.suffix** {{DT_STR}} | Suffix for network states (.xml.gz or .xml); *default:* **.xml.gz** |
| **--save-state.files** {{DT_FILE}} | Files for network states |
| **--save-state.rng** {{DT_BOOL}} | Save random number generator states; *default:* **false** |
| **--save-state.transportables** {{DT_BOOL}} | Save person and container states (experimental); *default:* **false** |

### Time

| Option | Description |
|--------|-------------|
| **-b** {{DT_TIME}}<br> **--begin** {{DT_TIME}} | Defines the begin time in seconds; The simulation starts at this time; *default:* **0** |
| **-e** {{DT_TIME}}<br> **--end** {{DT_TIME}} | Defines the end time in seconds; The simulation ends at this time; *default:* **-1** |
| **--step-length** {{DT_TIME}} | Defines the step duration in seconds; *default:* **1** |

### Processing

| Option | Description |
|--------|-------------|
| **--step-method.ballistic** {{DT_BOOL}} | Whether to use ballistic method for the positional update of vehicles (default is a semi-implicit Euler method).; *default:* **false** |
| **--extrapolate-departpos** {{DT_BOOL}} | Whether vehicles that depart between simulation steps should extrapolate the depart position; *default:* **false** |
| **--threads** {{DT_INT}} | Defines the number of threads for parallel simulation; *default:* **1** |
| **--lateral-resolution** {{DT_FLOAT}} | Defines the resolution in m when handling lateral positioning within a lane (with -1 all vehicles drive at the center of their lane; *default:* **-1** |
| **-s** {{DT_TIME}}<br> **--route-steps** {{DT_TIME}} | Load routes for the next number of seconds ahead; *default:* **200** |
| **--no-internal-links** {{DT_BOOL}} | Disable (junction) internal links; *default:* **false** |
| **--ignore-junction-blocker** {{DT_TIME}} | Ignore vehicles which block the junction after they have been standing for SECONDS (-1 means never ignore); *default:* **-1** |
| **--ignore-route-errors** {{DT_BOOL}} | (1) Do not check whether routes are connected. (2) Allow inserting a vehicle in a situation which requires emergency braking.; *default:* **false** |
| **--ignore-accidents** {{DT_BOOL}} | Do not check whether accidents occur; *default:* **false** |
| **--collision.action** {{DT_STR}} | How to deal with collisions: [none,warn,teleport,remove]; *default:* **teleport** |
| **--collision.stoptime** {{DT_TIME}} | Let vehicle stop for TIME before performing collision.action (except for action 'none'); *default:* **0** |
| **--collision.check-junctions** {{DT_BOOL}} | Enables collisions checks on junctions; *default:* **false** |
| **--collision.mingap-factor** {{DT_FLOAT}} | Sets the fraction of minGap that must be maintained to avoid collision detection. If a negative value is given, the carFollowModel parameter is used; *default:* **-1** |
| **--max-num-vehicles** {{DT_INT}} | Delay vehicle insertion to stay within the given maximum number; *default:* **-1** |
| **--max-num-teleports** {{DT_INT}} | Abort the simulation if the given maximum number of teleports is exceeded; *default:* **-1** |
| **--scale** {{DT_FLOAT}} | Scale demand by the given factor (by discarding or duplicating vehicles); *default:* **1** |
| **--time-to-teleport** {{DT_TIME}} | Specify how long a vehicle may wait until being teleported, defaults to 300, non-positive values disable teleporting; *default:* **300** |
| **--time-to-teleport.highways** {{DT_TIME}} | The waiting time after which vehicles on a fast road (speed > 69km/h) are teleported if they are on a non-continuing lane; *default:* **0** |
| **--waiting-time-memory** {{DT_TIME}} | Length of time interval, over which accumulated waiting time is taken into account (default is 100s.); *default:* **100** |
| **--max-depart-delay** {{DT_TIME}} | How long vehicles wait for departure before being skipped, defaults to -1 which means vehicles are never skipped; *default:* **-1** |
| **--sloppy-insert** {{DT_BOOL}} | Whether insertion on an edge shall not be repeated in same step once failed; *default:* **false** |
| **--eager-insert** {{DT_BOOL}} | Whether each vehicle is checked separately for insertion on an edge; *default:* **false** |
| **--random-depart-offset** {{DT_TIME}} | Each vehicle receives a random offset to its depart value drawn uniformly from [0, TIME]; *default:* **0** |
| **--lanechange.duration** {{DT_TIME}} | Duration of a lane change maneuver (default 0); *default:* **0** |
| **--lanechange.overtake-right** {{DT_BOOL}} | Whether overtaking on the right on motorways is permitted; *default:* **false** |
| **--tls.all-off** {{DT_BOOL}} | Switches off all traffic lights.; *default:* **false** |
| **--tls.actuated.show-detectors** {{DT_BOOL}} | Sets default visibility for actuation detectors; *default:* **false** |
| **--tls.delay_based.detector-range** {{DT_FLOAT}} | Sets default range for detecting delayed vehicles; *default:* **100** |
| **--time-to-impatience** {{DT_TIME}} | Specify how long a vehicle may wait until impatience grows from 0 to 1, defaults to 300, non-positive values disable impatience growth; *default:* **300** |
| **--default.action-step-length** {{DT_FLOAT}} | Length of the default interval length between action points for the car-following and lane-change models (in seconds). If not specified, the simulation step-length is used per default. Vehicle- or VType-specific settings override the default. Must be a multiple of the simulation step-length.; *default:* **0** |
| **--default.carfollowmodel** {{DT_STR}} | Select default car following model (Krauss, IDM, ...); *default:* **Krauss** |
| **--default.speeddev** {{DT_FLOAT}} | Select default speed deviation. A negative value implies vClass specific defaults (0.1 for the default passenger class; *default:* **-1** |
| **--default.emergencydecel** {{DT_STR}} | Select default emergencyDecel value among ('decel', 'default', FLOAT) which sets the value either to the same as the deceleration value, a vClass-class specific default or the given FLOAT in m/s^2; *default:* **default** |
| **--overhead-wire-solver** {{DT_BOOL}} | Use Kirchhoff's laws for solving overhead wire circuit; *default:* **true** |
| **--emergencydecel.warning-threshold** {{DT_FLOAT}} | Sets the fraction of emergency decel capability that must be used to trigger a warning.; *default:* **1** |
| **--parking.maneuver** {{DT_BOOL}} | Whether parking simulation includes manoeuvering time and associated lane blocking; *default:* **false** |
| **--pedestrian.model** {{DT_STR}} | Select among pedestrian models ['nonInteracting', 'striping', 'remote']; *default:* **striping** |
| **--pedestrian.striping.stripe-width** {{DT_FLOAT}} | Width of parallel stripes for segmenting a sidewalk (meters) for use with model 'striping'; *default:* **0.64** |
| **--pedestrian.striping.dawdling** {{DT_FLOAT}} | Factor for random slow-downs [0,1] for use with model 'striping'; *default:* **0.2** |
| **--pedestrian.striping.jamtime** {{DT_TIME}} | Time in seconds after which pedestrians start squeezing through a jam when using model 'striping' (non-positive values disable squeezing); *default:* **300** |
| **--pedestrian.striping.jamtime.crossing** {{DT_TIME}} | Time in seconds after which pedestrians start squeezing through a jam while on a pedestrian crossing when using model 'striping' (non-positive values disable squeezing); *default:* **10** |
| **--pedestrian.striping.jamtime.narrow** {{DT_TIME}} | Time in seconds after which pedestrians start squeezing through a jam while on a narrow lane when using model 'striping'; *default:* **1** |
| **--pedestrian.striping.reserve-oncoming** {{DT_FLOAT}} | Fraction of stripes to reserve for oncoming pedestrians; *default:* **0** |
| **--pedestrian.striping.reserve-oncoming.junctions** {{DT_FLOAT}} | Fraction of stripes to reserve for oncoming pedestrians on crossings and walkingareas; *default:* **0.34** |
| **--pedestrian.remote.address** {{DT_STR}} | The address (host:port) of the external simulation; *default:* **localhost:9000** |
| **--ride.stop-tolerance** {{DT_FLOAT}} | Tolerance to apply when matching pedestrian and vehicle positions on boarding at individual stops; *default:* **10** |

### Routing

| Option | Description |
|--------|-------------|
| **--routing-algorithm** {{DT_STR}} | Select among routing algorithms ['dijkstra', 'astar', 'CH', 'CHWrapper']; *default:* **dijkstra** |
| **--weights.random-factor** {{DT_FLOAT}} | Edge weights for routing are dynamically disturbed by a random factor drawn uniformly from [1,FLOAT); *default:* **1** |
| **--weights.minor-penalty** {{DT_FLOAT}} | Apply the given time penalty when computing minimum routing costs for minor-link internal lanes; *default:* **1.5** |
| **--weights.priority-factor** {{DT_FLOAT}} | Consider edge priorities in addition to travel times, weighted by factor; *default:* **0** |
| **--astar.all-distances** {{DT_FILE}} | Initialize lookup table for astar from the given file (generated by marouter --all-pairs-output) |
| **--astar.landmark-distances** {{DT_FILE}} | Initialize lookup table for astar ALT-variant from the given file |
| **--persontrip.walkfactor** {{DT_FLOAT}} | Use FLOAT as a factor on pedestrian maximum speed during intermodal routing; *default:* **0.75** |
| **--persontrip.transfer.car-walk** {{DT_STR[]}} | Where are mode changes from car to walking allowed (possible values: 'parkingAreas', 'ptStops', 'allJunctions' and combinations); *default:* **parkingAreas** |
| **--persontrip.transfer.taxi-walk** {{DT_STR[]}} | Where taxis can drop off customers ('allJunctions, 'ptStops') |
| **--persontrip.transfer.walk-taxi** {{DT_STR[]}} | Where taxis can pick up customers ('allJunctions, 'ptStops') |
| **--persontrip.default.group** {{DT_STR}} | When set, trips between the same origin and destination will share a taxi by default |
| **--persontrip.taxi.waiting-time** {{DT_TIME}} | Estimated time for taxi pickup; *default:* **300** |
| **--railway.max-train-length** {{DT_FLOAT}} | Use FLOAT as a maximum train length when initializing the railway router; *default:* **5000** |
| **--device.rerouting.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'rerouting' device; *default:* **-1** |
| **--device.rerouting.explicit** {{DT_STR[]}} | Assign a 'rerouting' device to named vehicles |
| **--device.rerouting.deterministic** {{DT_BOOL}} | The 'rerouting' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.rerouting.period** {{DT_TIME}} | The period with which the vehicle shall be rerouted; *default:* **0** |
| **--device.rerouting.pre-period** {{DT_TIME}} | The rerouting period before depart; *default:* **60** |
| **--device.rerouting.adaptation-weight** {{DT_FLOAT}} | The weight of prior edge weights for exponential moving average; *default:* **0** |
| **--device.rerouting.adaptation-steps** {{DT_INT}} | The number of steps for moving average weight of prior edge weights; *default:* **180** |
| **--device.rerouting.adaptation-interval** {{DT_TIME}} | The interval for updating the edge weights; *default:* **1** |
| **--device.rerouting.with-taz** {{DT_BOOL}} | Use zones (districts) as routing start- and endpoints; *default:* **false** |
| **--device.rerouting.init-with-loaded-weights** {{DT_BOOL}} | Use weight files given with option --weight-files for initializing edge weights; *default:* **false** |
| **--device.rerouting.threads** {{DT_INT}} | The number of parallel execution threads used for rerouting; *default:* **0** |
| **--device.rerouting.synchronize** {{DT_BOOL}} | Let rerouting happen at the same time for all vehicles; *default:* **false** |
| **--device.rerouting.railsignal** {{DT_BOOL}} | Allow rerouting triggered by rail signals.; *default:* **true** |
| **--device.rerouting.bike-speeds** {{DT_BOOL}} | Compute separate average speeds for bicycles; *default:* **false** |
| **--device.rerouting.output** {{DT_FILE}} | Save adapting weights to FILE |
| **--person-device.rerouting.probability** {{DT_FLOAT}} | The probability for a person to have a 'rerouting' device; *default:* **-1** |
| **--person-device.rerouting.explicit** {{DT_STR[]}} | Assign a 'rerouting' device to named persons |
| **--person-device.rerouting.deterministic** {{DT_BOOL}} | The 'rerouting' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--person-device.rerouting.period** {{DT_TIME}} | The period with which the person shall be rerouted; *default:* **0** |

### Report

| Option | Description |
|--------|-------------|
| **-v** {{DT_BOOL}}<br> **--verbose** {{DT_BOOL}} | Switches to verbose output; *default:* **false** |
| **--print-options** {{DT_BOOL}} | Prints option values before processing; *default:* **false** |
| **-?** {{DT_BOOL}}<br> **--help** {{DT_BOOL}} | Prints this screen or selected topics; *default:* **false** |
| **-V** {{DT_BOOL}}<br> **--version** {{DT_BOOL}} | Prints the current version; *default:* **false** |
| **-X** {{DT_STR}}<br> **--xml-validation** {{DT_STR}} | Set schema validation scheme of XML inputs ("never", "auto" or "always"); *default:* **auto** |
| **--xml-validation.net** {{DT_STR}} | Set schema validation scheme of SUMO network inputs ("never", "auto" or "always"); *default:* **never** |
| **--xml-validation.routes** {{DT_STR}} | Set schema validation scheme of SUMO route inputs ("never", "auto" or "always"); *default:* **auto** |
| **-W** {{DT_BOOL}}<br> **--no-warnings** {{DT_BOOL}} | Disables output of warnings; *default:* **false** |
| **--aggregate-warnings** {{DT_INT}} | Aggregate warnings of the same type whenever more than INT occur; *default:* **-1** |
| **-l** {{DT_FILE}}<br> **--log** {{DT_FILE}} | Writes all messages to FILE (implies verbose) |
| **--message-log** {{DT_FILE}} | Writes all non-error messages to FILE (implies verbose) |
| **--error-log** {{DT_FILE}} | Writes all warnings and errors to FILE |
| **--duration-log.disable** {{DT_BOOL}} | Disable performance reports for individual simulation steps; *default:* **false** |
| **-t** {{DT_BOOL}}<br> **--duration-log.statistics** {{DT_BOOL}} | Enable statistics on vehicle trips; *default:* **false** |
| **--no-step-log** {{DT_BOOL}} | Disable console output of current simulation step; *default:* **false** |
| **--step-log.period** {{DT_INT}} | Number of simulation steps between step-log outputs; *default:* **100** |

### Emissions

| Option | Description |
|--------|-------------|
| **--phemlight-path** {{DT_FILE}} | Determines where to load PHEMlight definitions from.; *default:* **./PHEMlight/** |
| **--device.emissions.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'emissions' device; *default:* **-1** |
| **--device.emissions.explicit** {{DT_STR[]}} | Assign a 'emissions' device to named vehicles |
| **--device.emissions.deterministic** {{DT_BOOL}} | The 'emissions' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.emissions.period** {{DT_STR}} | Recording period for emission-output; *default:* **0** |

### Communication

| Option | Description |
|--------|-------------|
| **--device.btreceiver.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'btreceiver' device; *default:* **-1** |
| **--device.btreceiver.explicit** {{DT_STR[]}} | Assign a 'btreceiver' device to named vehicles |
| **--device.btreceiver.deterministic** {{DT_BOOL}} | The 'btreceiver' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.btreceiver.range** {{DT_FLOAT}} | The range of the bt receiver; *default:* **300** |
| **--device.btreceiver.all-recognitions** {{DT_BOOL}} | Whether all recognition point shall be written; *default:* **false** |
| **--device.btreceiver.offtime** {{DT_FLOAT}} | The offtime used for calculating detection probability (in seconds); *default:* **0.64** |
| **--device.btsender.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'btsender' device; *default:* **-1** |
| **--device.btsender.explicit** {{DT_STR[]}} | Assign a 'btsender' device to named vehicles |
| **--device.btsender.deterministic** {{DT_BOOL}} | The 'btsender' devices are set deterministic using a fraction of 1000; *default:* **false** |

### Battery

| Option | Description |
|--------|-------------|
| **--device.battery.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'battery' device; *default:* **-1** |
| **--device.battery.explicit** {{DT_STR[]}} | Assign a 'battery' device to named vehicles |
| **--device.battery.deterministic** {{DT_BOOL}} | The 'battery' devices are set deterministic using a fraction of 1000; *default:* **false** |

### Example Device

| Option | Description |
|--------|-------------|
| **--device.example.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'example' device; *default:* **-1** |
| **--device.example.explicit** {{DT_STR[]}} | Assign a 'example' device to named vehicles |
| **--device.example.deterministic** {{DT_BOOL}} | The 'example' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.example.parameter** {{DT_FLOAT}} | An exemplary parameter which can be used by all instances of the example device; *default:* **0** |

### Ssm Device

| Option | Description |
|--------|-------------|
| **--device.ssm.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'ssm' device; *default:* **-1** |
| **--device.ssm.explicit** {{DT_STR[]}} | Assign a 'ssm' device to named vehicles |
| **--device.ssm.deterministic** {{DT_BOOL}} | The 'ssm' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.ssm.measures** {{DT_STR}} | Specifies which measures will be logged (as a space separated sequence of IDs in ('TTC', 'DRAC', 'PET')). |
| **--device.ssm.thresholds** {{DT_STR}} | Specifies thresholds corresponding to the specified measures (see documentation and watch the order!). Only events exceeding the thresholds will be logged. |
| **--device.ssm.trajectories** {{DT_BOOL}} | Specifies whether trajectories will be logged (if false, only the extremal values and times are reported, this is the default). |
| **--device.ssm.range** {{DT_FLOAT}} | Specifies the detection range in meters (default is 50.00m.). For vehicles below this distance from the equipped vehicle, SSM values are traced. |
| **--device.ssm.extratime** {{DT_FLOAT}} | Specifies the time in seconds to be logged after a conflict is over (default is 5.00secs.). Required >0 if PET is to be calculated for crossing conflicts. |
| **--device.ssm.file** {{DT_STR}} | Give a global default filename for the SSM output. |
| **--device.ssm.geo** {{DT_BOOL}} | Whether to use coordinates of the original reference system in output (default is false). |

### Toc Device

| Option | Description |
|--------|-------------|
| **--device.toc.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'toc' device; *default:* **-1** |
| **--device.toc.explicit** {{DT_STR[]}} | Assign a 'toc' device to named vehicles |
| **--device.toc.deterministic** {{DT_BOOL}} | The 'toc' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.toc.manualType** {{DT_STR}} | Vehicle type for manual driving regime. |
| **--device.toc.automatedType** {{DT_STR}} | Vehicle type for automated driving regime. |
| **--device.toc.responseTime** {{DT_FLOAT}} | Average response time needed by a driver to take back control.; *default:* **-1** |
| **--device.toc.recoveryRate** {{DT_FLOAT}} | Recovery rate for the driver's awareness after a ToC.; *default:* **0.1** |
| **--device.toc.lcAbstinence** {{DT_FLOAT}} | Attention level below which a driver restrains from performing lane changes (value in [0,1]).; *default:* **0** |
| **--device.toc.initialAwareness** {{DT_FLOAT}} | Average awareness a driver has initially after a ToC (value in [0,1]).; *default:* **0.5** |
| **--device.toc.mrmDecel** {{DT_FLOAT}} | Deceleration rate applied during a 'minimum risk maneuver'.; *default:* **1.5** |
| **--device.toc.dynamicToCThreshold** {{DT_FLOAT}} | Time, which the vehicle requires to have ahead to continue in automated mode. The default value of 0 indicates no dynamic triggering of ToCs.; *default:* **0** |
| **--device.toc.dynamicMRMProbability** {{DT_FLOAT}} | Probability that a dynamically triggered TOR is not answered in time.; *default:* **0.05** |
| **--device.toc.mrmKeepRight** {{DT_BOOL}} | If true, the vehicle tries to change to the right during an MRM.; *default:* **false** |
| **--device.toc.mrmSafeSpot** {{DT_STR}} | If set, the vehicle tries to reach the given named stopping place during an MRM. |
| **--device.toc.mrmSafeSpotDuration** {{DT_FLOAT}} | Duration the vehicle stays at the safe spot after an MRM.; *default:* **60** |
| **--device.toc.maxPreparationAccel** {{DT_FLOAT}} | Maximal acceleration that may be applied during the ToC preparation phase.; *default:* **0** |
| **--device.toc.ogNewTimeHeadway** {{DT_FLOAT}} | Timegap for ToC preparation phase.; *default:* **-1** |
| **--device.toc.ogNewSpaceHeadway** {{DT_FLOAT}} | Additional spacing for ToC preparation phase.; *default:* **-1** |
| **--device.toc.ogMaxDecel** {{DT_FLOAT}} | Maximal deceleration applied for establishing increased gap in ToC preparation phase.; *default:* **-1** |
| **--device.toc.ogChangeRate** {{DT_FLOAT}} | Rate of adaptation towards the increased headway during ToC preparation.; *default:* **-1** |
| **--device.toc.useColorScheme** {{DT_BOOL}} | Whether a coloring scheme shall by applied to indicate the different ToC stages.; *default:* **true** |
| **--device.toc.file** {{DT_STR}} | Switches on output by specifying an output filename. |

### Driver State Device

| Option | Description |
|--------|-------------|
| **--device.driverstate.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'driverstate' device; *default:* **-1** |
| **--device.driverstate.explicit** {{DT_STR[]}} | Assign a 'driverstate' device to named vehicles |
| **--device.driverstate.deterministic** {{DT_BOOL}} | The 'driverstate' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.driverstate.initialAwareness** {{DT_FLOAT}} | Initial value assigned to the driver's awareness.; *default:* **1** |
| **--device.driverstate.errorTimeScaleCoefficient** {{DT_FLOAT}} | Time scale for the error process.; *default:* **100** |
| **--device.driverstate.errorNoiseIntensityCoefficient** {{DT_FLOAT}} | Noise intensity driving the error process.; *default:* **0.2** |
| **--device.driverstate.speedDifferenceErrorCoefficient** {{DT_FLOAT}} | General scaling coefficient for applying the error to the perceived speed difference (error also scales with distance).; *default:* **0.15** |
| **--device.driverstate.headwayErrorCoefficient** {{DT_FLOAT}} | General scaling coefficient for applying the error to the perceived distance (error also scales with distance).; *default:* **0.75** |
| **--device.driverstate.speedDifferenceChangePerceptionThreshold** {{DT_FLOAT}} | Base threshold for recognizing changes in the speed difference (threshold also scales with distance).; *default:* **0.1** |
| **--device.driverstate.headwayChangePerceptionThreshold** {{DT_FLOAT}} | Base threshold for recognizing changes in the headway (threshold also scales with distance).; *default:* **0.1** |
| **--device.driverstate.minAwareness** {{DT_FLOAT}} | Minimal admissible value for the driver's awareness.; *default:* **0.1** |
| **--device.driverstate.maximalReactionTime** {{DT_FLOAT}} | Maximal reaction time (~action step length) induced by decreased awareness level (reached for awareness=minAwareness).; *default:* **-1** |

### Bluelight Device

| Option | Description |
|--------|-------------|
| **--device.bluelight.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'bluelight' device; *default:* **-1** |
| **--device.bluelight.explicit** {{DT_STR[]}} | Assign a 'bluelight' device to named vehicles |
| **--device.bluelight.deterministic** {{DT_BOOL}} | The 'bluelight' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.bluelight.reactiondist** {{DT_FLOAT}} | Set the distance at which other drivers react to the blue light and siren sound; *default:* **25** |

### Fcd Device

| Option | Description |
|--------|-------------|
| **--device.fcd.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'fcd' device; *default:* **-1** |
| **--device.fcd.explicit** {{DT_STR[]}} | Assign a 'fcd' device to named vehicles |
| **--device.fcd.deterministic** {{DT_BOOL}} | The 'fcd' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.fcd.period** {{DT_STR}} | Recording period for FCD-data; *default:* **0** |
| **--device.fcd.radius** {{DT_FLOAT}} | Record objects in a radius around equipped vehicles; *default:* **0** |
| **--person-device.fcd.probability** {{DT_FLOAT}} | The probability for a person to have a 'fcd' device; *default:* **-1** |
| **--person-device.fcd.explicit** {{DT_STR[]}} | Assign a 'fcd' device to named persons |
| **--person-device.fcd.deterministic** {{DT_BOOL}} | The 'fcd' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--person-device.fcd.period** {{DT_STR}} | Recording period for FCD-data; *default:* **0** |

### Elechybrid Device
| Option | Description |
|--------|-------------|
| **--device.elechybrid.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'elechybrid' device; *default:* **-1** |
| **--device.elechybrid.explicit** {{DT_STR[]}} | Assign a 'elechybrid' device to named vehicles |
| **--device.elechybrid.deterministic** {{DT_BOOL}} | The 'elechybrid' devices are set deterministic using a fraction of 1000; *default:* **false** |

### Taxi Device
| Option | Description |
|--------|-------------|
| **--device.taxi.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'taxi' device; *default:* **-1** |
| **--device.taxi.explicit** {{DT_STR[]}} | Assign a 'taxi' device to named vehicles |
| **--device.taxi.deterministic** {{DT_BOOL}} | The 'taxi' devices are set deterministic using a fraction of 1000; *default:* **false** |
| **--device.taxi.dispatch-algorithm** {{DT_STR}} | The dispatch algorithm [greedy|greedyClosest|greedyShared|routeExtension|traci]; *default:* **greedy** |
| **--device.taxi.dispatch-algorithm.output** {{DT_STR}} | Write information from the dispatch algorithm to FILE |
| **--device.taxi.dispatch-algorithm.params** {{DT_STR}} | Load dispatch algorithm parameters in format KEY1:VALUE1[,KEY2:VALUE] |
| **--device.taxi.dispatch-period** {{DT_TIME}} | The period between successive calls to the dispatcher; *default:* **60** |
| **--device.taxi.idle-algorithm** {{DT_STR}} | The behavior of idle taxis [stop|randomCircling]; *default:* **stop** |
| **--device.taxi.idle-algorithm.output** {{DT_STR}} | Write information from the idling algorithm to FILE |

### Tripinfo Device
| Option | Description |
|--------|-------------|
| **--device.tripinfo.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'tripinfo' device; *default:* **-1** |
| **--device.tripinfo.explicit** {{DT_STR[]}} | Assign a 'tripinfo' device to named vehicles |
| **--device.tripinfo.deterministic** {{DT_BOOL}} | The 'tripinfo' devices are set deterministic using a fraction of 1000; *default:* **false** |

### Vehroutes Device
| Option | Description |
|--------|-------------|
| **--device.vehroute.probability** {{DT_FLOAT}} | The probability for a vehicle to have a 'vehroute' device; *default:* **-1** |
| **--device.vehroute.explicit** {{DT_STR[]}} | Assign a 'vehroute' device to named vehicles |
| **--device.vehroute.deterministic** {{DT_BOOL}} | The 'vehroute' devices are set deterministic using a fraction of 1000; *default:* **false** |

### Traci Server
| Option | Description |
|--------|-------------|
| **--remote-port** {{DT_INT}} | Enables TraCI Server if set; *default:* **0** |
| **--num-clients** {{DT_INT}} | Expected number of connecting clients; *default:* **1** |

### Mesoscopic

| Option | Description |
|--------|-------------|
| **--mesosim** {{DT_BOOL}} | Enables mesoscopic simulation; *default:* **false** |
| **--meso-edgelength** {{DT_FLOAT}} | Length of an edge segment in mesoscopic simulation; *default:* **98** |
| **--meso-tauff** {{DT_TIME}} | Factor for calculating the net free-free headway time; *default:* **1.13** |
| **--meso-taufj** {{DT_TIME}} | Factor for calculating the net free-jam headway time; *default:* **1.13** |
| **--meso-taujf** {{DT_TIME}} | Factor for calculating the jam-free headway time; *default:* **1.73** |
| **--meso-taujj** {{DT_TIME}} | Factor for calculating the jam-jam headway time; *default:* **1.4** |
| **--meso-jam-threshold** {{DT_FLOAT}} | Minimum percentage of occupied space to consider a segment jammed. A negative argument causes thresholds to be computed based on edge speed and tauff (default); *default:* **-1** |
| **--meso-multi-queue** {{DT_BOOL}} | Enable multiple queues at edge ends; *default:* **true** |
| **--meso-lane-queue** {{DT_BOOL}} | Enable separate queues for every lane; *default:* **false** |
| **--meso-junction-control** {{DT_BOOL}} | Enable mesoscopic traffic light and priority junction handling; *default:* **false** |
| **--meso-junction-control.limited** {{DT_BOOL}} | Enable mesoscopic traffic light and priority junction handling for saturated links. This prevents faulty traffic lights from hindering flow in low-traffic situations; *default:* **false** |
| **--meso-tls-penalty** {{DT_FLOAT}} | Apply scaled travel time penalties when driving across tls controlled junctions based on green split instead of checking actual phases; *default:* **0** |
| **--meso-tls-flow-penalty** {{DT_FLOAT}} | Apply scaled headway penalties when driving across tls controlled junctions based on green split instead of checking actual phases; *default:* **0** |
| **--meso-minor-penalty** {{DT_TIME}} | Apply fixed time penalty when driving across a minor link. When using --meso-junction-control.limited, the penalty is not applied whenever limited control is active.; *default:* **0** |
| **--meso-overtaking** {{DT_BOOL}} | Enable mesoscopic overtaking; *default:* **false** |
| **--meso-recheck** {{DT_TIME}} | Time interval for rechecking insertion into the next segment after failure; *default:* **0** |

### Random Number

| Option | Description |
|--------|-------------|
| **--random** {{DT_BOOL}} | Initialises the random number generator with the current system time; *default:* **false** |
| **--seed** {{DT_INT}} | Initialises the random number generator with the given value; *default:* **23423** |
| **--thread-rngs** {{DT_INT}} | Number of pre-allocated random number generators to ensure repeatable multi-threaded simulations (should be at least the number of threads for repeatable simulations).; *default:* **64** |

### Gui Only

| Option | Description |
|--------|-------------|
| **-g** {{DT_FILE}}<br> **--gui-settings-file** {{DT_FILE}} | Load visualisation settings from FILE |
| **-Q** {{DT_BOOL}}<br> **--quit-on-end** {{DT_BOOL}} | Quits the GUI when the simulation stops; *default:* **false** |
| **-G** {{DT_BOOL}}<br> **--game** {{DT_BOOL}} | Start the GUI in gaming mode; *default:* **false** |
| **--game.mode** {{DT_STR}} | Select the game type ('tls', 'drt'); *default:* **tls** |
| **-S** {{DT_BOOL}}<br> **--start** {{DT_BOOL}} | Start the simulation after loading; *default:* **false** |
| **-d** {{DT_FLOAT}}<br> **--delay** {{DT_FLOAT}} | Use FLOAT in ms as delay between simulation steps; *default:* **0** |
| **-B** {{DT_STR[]}}<br> **--breakpoints** {{DT_STR[]}} | Use TIME[] as times when the simulation should halt |
| **--edgedata-files** {{DT_FILE}} | Load edge/lane weights for visualization from FILE |
| **-D** {{DT_BOOL}}<br> **--demo** {{DT_BOOL}} | Restart the simulation after ending (demo mode); *default:* **false** |
| **-T** {{DT_BOOL}}<br> **--disable-textures** {{DT_BOOL}} | Do not load background pictures; *default:* **false** |
| **--registry-viewport** {{DT_BOOL}} | Load current viewport from registry; *default:* **false** |
| **--window-size** {{DT_STR[]}} | Create initial window with the given x,y size |
| **--window-pos** {{DT_STR[]}} | Create initial window at the given x,y position |
| **--tracker-interval** {{DT_FLOAT}} | The aggregation period for value tracker windows; *default:* **1** |
| **--osg-view** {{DT_BOOL}} | Start with an OpenSceneGraph view instead of the regular 2D view; *default:* **false** |
| **--gui-testing** {{DT_BOOL}} | Enable overlay for screen recognition; *default:* **false** |
| **--gui-testing-debug** {{DT_BOOL}} | Enable output messages during GUI-Testing; *default:* **false** |
| **--gui-testing.setting-output** {{DT_FILE}} | Save gui settings in the given settings output file |

# Loading order of input files

Whenever a simulation object A (such as a vehicle) defined in an input
file refers to another simulation object B (such as a vehicle type), the
corresponding object B must be defined before A either by being put into
a file that is loaded earlier, or by being put into the same file on an
earlier line.

This is of particular importance in regard to files loaded with the
options **--route-files** {{DT_FILE}} and **--additional-files** {{DT_FILE}}. The most important feature of the option **--route-files** {{DT_FILE}} is that it
loads the files incrementally thus saving memory. However, this means
vehicles and flows must be sorted by their `departure` and `begin` times.

The option **--additional-files** {{DT_FILE}} is handled before option **--route-files** {{DT_FILE}} and the given files are fully
loaded before the simulation starts. All items which can be put into a
*route-file* can also be put into an *additional-file* (no vehicle
sorting is necessary). Some objects must be available at the start of
the simulation (such as output objects) and thus need to be loaded with
this option, but is also useful for loading things referenced by route
files such as `<vType>`-elements, named `<route>` elements or `<routeDistribution>`.

When multiple files are given as a comma-separated list, they are loaded
from left to right.

# Format of additional files

Files loaded with the option **--additional-files** {{DT_FILE}} may included a wide range of network
elements such as [traffic light
programs](Simulation/Traffic_Lights.md), [detector
definitions](Simulation/Output/Induction_Loops_Detectors_(E1).md),
[variable speed signs](Simulation/Variable_Speed_Signs.md) and
[bus stops](Simulation/Public_Transport.md). These files are
also used to configure simulation outputs such as [edge-based traffic
measures](Simulation/Output.md#values_for_edges_or_lanes) or
[traffic light switching
information](Simulation/Output.md#traffic_lights-based_information).
Furthermore, any element permitted in a route file such as
[vTypes](Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md#vehicle_types),
[routes](Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md#routes)
and
[vehicles](Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md#vehicles_and_routes)
can be added. All elements may be put into the same additional file or
they may be grouped into multiple files as convenient.

The additional file always needs a top level tag with arbitrary name
(*additional* is customary). An example file is given below:

```
<additional>
    <inductionLoop id="myLoop1" lane="foo_0" pos="42" freq="900" file="out.xml"/>
    <inductionLoop id="myLoop2" lane="foo_2" pos="42" freq="900" file="out.xml"/>

    <busStop id="station1" lane="foo_0" startPos="5" endPos="20"/>

    <vType id="bus" maxSpeed="20" length="12"/>
</additional>
```

# Subtopics

- [General topics](index.md#simulation)
- [Traffic Management and Other Structures](index.md#traffic_management_and_other_structures)
- [Traffic Modes](index.md#traffic_modes)
- [Additional Features](index.md#additional_features)
- [Model details](index.md#model_details)
- [Common Problems](index.md#common_problems)
