/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class RiemannSumRects
extends Drawable
implements Computable {
    private double[] rectHeights;
    private int method;
    private Color color = new Color(255, 255, 180);
    private Color outlineColor = new Color(180, 180, 0);
    private double[] endpointVals;
    private double[] maxVals;
    private double[] minVals;
    private double[] midpointVals;
    private Value intervalCount;
    private Function func;
    private Function deriv;
    private double[] sum;
    private double[] param = new double[1];
    private boolean changed = true;
    public static final int LEFTENDPOINT = 0;
    public static final int RIGHTENDPOINT = 1;
    public static final int MIDPOINT = 2;
    public static final int CIRCUMSCRIBED = 3;
    public static final int INSCRIBED = 4;
    public static final int TRAPEZOID = 5;
    public static final int CURRENT_METHOD = -1;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
            this.needsRedraw();
        }
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
        this.needsRedraw();
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setFunction(Function function) {
        if (function != null && function.getArity() != 1) {
            throw new IllegalArgumentException("Function for Riemann sums must have arity 1.");
        }
        this.func = function;
        this.deriv = function == null ? null : function.derivative(1);
        this.changed = true;
        this.needsRedraw();
    }

    public Function getFuction() {
        return this.func;
    }

    public void setMethod(int n) {
        this.method = n;
        this.changed = true;
        this.needsRedraw();
    }

    public int getMethod() {
        return this.method;
    }

    @Override
    public void compute() {
        this.changed = true;
        this.needsRedraw();
    }

    public Value getIntervalCount() {
        return this.intervalCount;
    }

    public void setIntervalCount(Value value) {
        this.changed = true;
        this.intervalCount = value;
        this.needsRedraw();
    }

    public RiemannSumRects() {
        this(null, null);
    }

    public RiemannSumRects(Function function, Value value) {
        this.intervalCount = value;
        this.func = function;
        if (function != null) {
            this.deriv = this.func.derivative(1);
        }
        this.sum = new double[6];
        this.method = 0;
    }

    @Override
    public void draw(Graphics graphics, boolean bl) {
        if (this.func == null || this.coords == null) {
            return;
        }
        if (this.changed || this.rectHeights == null || bl) {
            this.setSumData();
        }
        int n = this.method == 5 || this.method == 0 || this.method == 1 ? this.rectHeights.length - 1 : this.rectHeights.length;
        double d = this.coords.getXmin();
        double d2 = (this.coords.getXmax() - d) / (double)n;
        int n2 = this.coords.yToPixel(0.0);
        graphics.setColor(this.color);
        if (this.method == 5) {
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            nArray[1] = this.coords.xToPixel(d);
            nArray2[0] = nArray2[1] = n2;
            nArray2[2] = this.coords.yToPixel(this.rectHeights[0]);
            for (int i = 0; i < n; ++i) {
                nArray[0] = nArray[3] = nArray[1];
                nArray[1] = nArray[2] = this.coords.xToPixel(d += d2);
                nArray2[3] = nArray2[2];
                nArray2[2] = this.coords.yToPixel(this.rectHeights[i + 1]);
                graphics.fillPolygon(nArray, nArray2, 4);
                if (this.outlineColor == null) continue;
                graphics.setColor(this.outlineColor);
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.setColor(this.color);
            }
        } else {
            int n3 = this.coords.xToPixel(d);
            for (int i = 0; i < n; ++i) {
                int n4 = this.coords.xToPixel(d + d2);
                int n5 = n4 - n3 + 1;
                int n6 = this.coords.yToPixel(this.rectHeights[this.method == 1 ? i + 1 : i]);
                int n7 = n2 - n6;
                if (n7 > 0) {
                    graphics.fillRect(n3, n6, n5, n7);
                } else if (n7 == 0) {
                    graphics.drawLine(n3, n2, n3 + n5 - 1, n2);
                } else {
                    graphics.fillRect(n3, n2, n5, -n7);
                }
                if (this.outlineColor != null) {
                    graphics.setColor(this.outlineColor);
                    if (n7 > 0) {
                        graphics.drawRect(n3, n6, n5, n7);
                    } else if (n7 == 0) {
                        graphics.drawLine(n3, n2, n3 + n5 - 1, n2);
                    } else {
                        graphics.drawRect(n3, n2, n5, -n7);
                    }
                    graphics.setColor(this.color);
                }
                d += d2;
                n3 = n4;
            }
        }
    }

    private void setSumData() {
        double d;
        double d2;
        double d3;
        double d4;
        this.changed = false;
        double d5 = d4 = this.intervalCount == null ? 5.0 : this.intervalCount.getVal() + 0.5;
        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
            d4 = 5.0;
        } else if (d4 < 0.0) {
            d4 = 1.0;
        } else if (d4 > 5000.0) {
            d4 = 5000.0;
        }
        int n = (int)d4;
        this.endpointVals = new double[n + 1];
        this.maxVals = new double[n];
        this.minVals = new double[n];
        this.midpointVals = new double[n];
        double d6 = this.coords.getXmin();
        double d7 = (this.coords.getXmax() - d6) / (double)n;
        this.param[0] = d6;
        this.endpointVals[0] = this.func.getVal(this.param);
        int n2 = 200 / n;
        if (n2 < 1) {
            n2 = 1;
            d3 = d7;
        } else {
            d3 = d7 / (double)n2;
        }
        boolean bl = this.deriv.getVal(this.param) > 0.0;
        for (int i = 1; i <= n; ++i) {
            double d8;
            this.param[0] = d6 += d7;
            this.endpointVals[i] = this.func.getVal(this.param);
            this.param[0] = d6 - d7 / 2.0;
            this.midpointVals[i - 1] = this.func.getVal(this.param);
            double d9 = d8 = this.endpointVals[i - 1];
            for (int j = 1; j <= n2; ++j) {
                boolean bl2 = bl;
                this.param[0] = d2 = d6 - d7 + (double)j * d3;
                boolean bl3 = bl = this.deriv.getVal(this.param) > 0.0;
                if (bl2 == bl) continue;
                if (bl2) {
                    d = this.searchMax(d2 - d3, d2, 1);
                    if (!(d > d9)) continue;
                    d9 = d;
                    continue;
                }
                d = this.searchMin(d2 - d3, d2, 1);
                if (!(d < d8)) continue;
                d8 = d;
            }
            if (this.endpointVals[i] > d9) {
                d9 = this.endpointVals[i];
            } else if (this.endpointVals[i] < d8) {
                d8 = this.endpointVals[i];
            }
            this.minVals[i - 1] = d8;
            this.maxVals[i - 1] = d9;
        }
        double d10 = this.endpointVals[0];
        double d11 = 0.0;
        double d12 = 0.0;
        d2 = 0.0;
        d = 0.0;
        double d13 = 0.0;
        for (int i = 0; i < n; ++i) {
            d11 += this.endpointVals[i];
            d12 += this.midpointVals[i];
            d += this.maxVals[i];
            d13 += this.minVals[i];
        }
        d2 = d11 - this.endpointVals[0] + this.endpointVals[n];
        this.sum[0] = d11 * d7;
        this.sum[1] = d2 * d7;
        this.sum[2] = d12 * d7;
        this.sum[3] = d * d7;
        this.sum[4] = d13 * d7;
        this.sum[5] = (d11 + d2) / 2.0 * d7;
        this.setRectData();
    }

    private void setRectData() {
        if (this.method == 3) {
            this.setRectHeights(this.maxVals);
        } else if (this.method == 4) {
            this.setRectHeights(this.minVals);
        } else if (this.method == 2) {
            this.setRectHeights(this.midpointVals);
        } else {
            this.setRectHeights(this.endpointVals);
        }
    }

    private void setRectHeights(double[] dArray) {
        this.rectHeights = dArray;
        this.changed = true;
    }

    private double searchMin(double d, double d2, int n) {
        double d3;
        this.param[0] = d3 = (d + d2) / 2.0;
        if (n >= 13) {
            return this.func.getVal(this.param);
        }
        double d4 = this.deriv.getVal(this.param);
        if (d4 < 0.0) {
            return this.searchMin(d3, d2, n + 1);
        }
        return this.searchMin(d, d3, n + 1);
    }

    private double searchMax(double d, double d2, int n) {
        double d3;
        this.param[0] = d3 = (d + d2) / 2.0;
        if (n >= 13) {
            return this.func.getVal(this.param);
        }
        double d4 = this.deriv.getVal(this.param);
        if (d4 > 0.0) {
            return this.searchMin(d3, d2, n + 1);
        }
        return this.searchMin(d, d3, n + 1);
    }

    public Value getValueObject(final int n) {
        return new Value(){

            @Override
            public double getVal() {
                if (RiemannSumRects.this.func == null || RiemannSumRects.this.coords == null) {
                    return Double.NaN;
                }
                if (RiemannSumRects.this.changed) {
                    RiemannSumRects.this.setSumData();
                }
                if (n == -1) {
                    return RiemannSumRects.this.sum[RiemannSumRects.this.method];
                }
                return RiemannSumRects.this.sum[n];
            }
        };
    }
}

