//
// Created by uos on 2022/2/24.
//

#ifndef UOS_RECOVERY_ASYNCTASKTEST_H
#define UOS_RECOVERY_ASYNCTASKTEST_H

#include "utils/AsyncTask.h"
#include <gtest/gtest.h>
#include <QDebug>
#include <QTimer>

class AsyncTaskDemo : public AsyncTask
{
public:
    explicit AsyncTaskDemo() {

    }

    ~AsyncTaskDemo() override {

    }

    void setProgram(const QString &cmd) {
        m_cmd = cmd;
    }

    void setArguments(const QStringList &args) {
        m_args = args;
    }

    bool buildArgumentsForBackup() {

    }

    void readStandardOutput() override
    {
        while (m_process->canReadLine()) {
            auto line = m_process->readLine();
            qInfo() << line;
            lines << line;
        }
    }

    void readAllStandardError() override
    {

    }
public:
    QStringList lines;
};


class AsyncTaskTest : public testing::Test
{
public:
    void SetUp() override
    {
        m_task = new AsyncTaskDemo();
    }

    void TearDown() override
    {
        delete m_task;
        m_task = nullptr;
    }
public:
    AsyncTaskDemo *m_task;
};


TEST_F(AsyncTaskTest, all)
{
    m_task->setProgram("ping");
    m_task->setArguments(QStringList() << "127.0.0.1" << "-c" << "3");
    m_task->start();
    QEventLoop loop;
    QTimer::singleShot(5000, &loop, SLOT(quit()));
    loop.exec();
}

#endif //UOS_RECOVERY_ASYNCTASKTEST_H
