//
// Created by uos on 2022/6/6.
//

#ifndef UOS_RECOVERY_OSTREESYSTEMTEST_H
#define UOS_RECOVERY_OSTREESYSTEMTEST_H

#include "uos-recovery-service/OSTreeSystem.h"
#include <gtest/gtest.h>
#include <QTimer>
#include <QObject>
#include <QEventLoop>

class OStreeSystemTestHandle : public QObject
{
    Q_OBJECT
public:
    explicit OStreeSystemTestHandle(QEventLoop *eventLoop);
    void systemBackup();
    void querySubject();
    void removeBackup();

private Q_SLOTS:
    void onFinished(const QString &msg);
    void onProgressChanged(const QString &progress);

private:
    QEventLoop *m_eventLoop = nullptr;
    OSTreeSystem *m_ostreeSystem = nullptr;
};

class OStreeSystemTest : public testing::Test
{
public:
    void SetUp() override
    {
        m_loop = new QEventLoop;
        m_taskHandle = new OStreeSystemTestHandle(m_loop);
    }

    void TearDown() override
    {
        if (m_taskHandle != nullptr) {
            delete m_taskHandle;
            m_taskHandle = nullptr;
        }

        if (m_loop != nullptr) {
            delete m_loop;
            m_loop = nullptr;
        }
    }

public:
    OStreeSystemTestHandle *m_taskHandle = nullptr;
    QEventLoop *m_loop = nullptr;
};

#endif //UOS_RECOVERY_OSTREESYSTEMTEST_H
