//
// Created by uos on 2022/2/24.
//

#ifndef UOS_RECOVERY_RSYNCTASKTEST_H
#define UOS_RECOVERY_RSYNCTASKTEST_H

#include "utils/RsyncTask.h"
#include <gtest/gtest.h>
#include <QTimer>
#include <QObject>
#include <QEventLoop>

class RsyncTaskTestHandle : public QObject
{
    Q_OBJECT
public:
    explicit RsyncTaskTestHandle(QEventLoop *eventLoop);
    bool dataBackup();

signals:
    void error();
    void finished();

private:
    RsyncTask *m_rsyncTask = nullptr;
    QEventLoop *m_eventLoop;
};

class RsyncTaskTest : public testing::Test
{
public:
    void SetUp() override
    {
        m_loop = new QEventLoop;
        m_rsyncTaskHandle = new RsyncTaskTestHandle(m_loop);
    }

    void TearDown() override
    {
        if (m_rsyncTaskHandle != nullptr) {
            delete m_rsyncTaskHandle;
            m_rsyncTaskHandle = nullptr;
        }
        if (m_loop != nullptr) {
            delete m_loop;
            m_loop = nullptr;
        }
    }

public:
    RsyncTaskTestHandle *m_rsyncTaskHandle = nullptr;
    QEventLoop *m_loop = nullptr;
};



#endif //UOS_RECOVERY_RSYNCTASKTEST_H
