//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/18.
//
#include "NavigationListView.h"

NavigationListView::NavigationListView(QWidget *parent)
    : DListView(parent)
{
    this->initUI();
    this->initConnections();
}

NavigationListView::~NavigationListView()
{

}

void NavigationListView::initUI()
{
    setAccessibleName("NavigationListView");

    setFixedWidth(200);
    setViewMode(DListView::ViewMode::ListMode);
    setSelectionMode(QAbstractItemView::SelectionMode::SingleSelection);
    setSelectionBehavior(QAbstractItemView::SelectionBehavior::SelectItems);
    setEditTriggers(DListView::EditTrigger::NoEditTriggers);
    setAutoScroll(false);
    setMouseTracking(true);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    QPalette palette;
    palette.setColor(QPalette::BrightText, QColor(qRgba(255,255,255,0.8)));
    this->setPalette(palette);
}

void NavigationListView::initConnections()
{

}
