//
// Created by uos on 2022/3/21.
//

#ifndef UOS_RECOVERY_RESULTWIDGET_H
#define UOS_RECOVERY_RESULTWIDGET_H

#include <DWidget>
#include <DLabel>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ResultWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ResultWidget(bool success, const QString &resultText,
                          const QString &errorMsg, const QString &btnText, bool hideIcon, DWidget *parent = nullptr);

    void set(bool success, const QString &resultText,
             const QString &errorMsg, const QString &btnText, bool hideIcon = false);
    bool isSuccess() { return m_isSuccess; }
    void showViewButton(bool show, const QString &btnText, const QString &style);
    void showIntroductionMsg(bool show, const QString &msg, const QString &style);
Q_SIGNALS:
    void done();
    void viewBtnClicked();
private:
    DLabel *m_resultIcon = nullptr;
    DLabel *m_resultText = nullptr;
    DLabel *m_errorMsg = nullptr;
    DLabel *m_introduction = nullptr;
    DPushButton *m_viewButton = nullptr;
    DPushButton *m_button = nullptr;
    bool m_isSuccess = false;
};

class ResultWidgetV2 : public DWidget
{
    Q_OBJECT
public:
    explicit ResultWidgetV2(int opType, bool success, const QString &resultText,
                          const QString &errorMsg, const QString &btnText, bool hideIcon, DWidget *parent = nullptr);

    void set(int opType, bool success, const QString &resultText,
             const QString &errorMsg, const QString &btnText, bool hideIcon = false);
    bool isSuccess() { return m_isSuccess; }
    void showViewButton(bool show, const QString &btnText, const QString &style);
    void showIntroductionMsg(bool show, const QString &msg, const QString &style);
Q_SIGNALS:
    void done();
    void viewBtnClicked();

private Q_SLOTS:
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

private:
    DLabel *m_resultIcon = nullptr;
    DLabel *m_resultText = nullptr;
    DLabel *m_errorMsg = nullptr;
    DLabel *m_introduction = nullptr;
    DPushButton *m_viewButton = nullptr;
    DPushButton *m_button = nullptr;
    int m_opType = -1;
    bool m_isSuccess = false;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
};

#endif //UOS_RECOVERY_RESULTWIDGET_H
