//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/11/14.
//
#include "RecoverySessionDbusService.h"
#include <QDBusConnection>
#include <QDebug>
#include "MainWindow.h"
#include "MainWindowSnipe.h"

const QString RecoverySessionServiceName = "com.deepin.daemon.UosRecoverySession";
const QString RecoverySessionServicePath = "/com/deepin/daemon/UosRecoverySession";

RecoverySessionDbusService::RecoverySessionDbusService(QObject *parent) : QObject(parent)
{
    m_mainWindow = qobject_cast<MainWindow *>(QObject::parent());
    m_mainWinSnipe = qobject_cast<MainWindowSnipe *>(QObject::parent());
    QDBusConnection conn = QDBusConnection::sessionBus();
    if (!conn.registerService(RecoverySessionServiceName)) {
        qCritical() << "registerService: " << conn.lastError().message();
        exit(1);
    }

    if (!conn.registerObject(RecoverySessionServicePath, this, QDBusConnection::ExportAllContents)) {
        qCritical() << "registerObject: " << conn.lastError().message();
        exit(1);
    }
}

RecoverySessionDbusService::~RecoverySessionDbusService()
{}

void RecoverySessionDbusService::ShowBackupPage()
{
    if (nullptr != m_mainWindow) {
        m_mainWindow->ShowBackupPage();
    }
}

void RecoverySessionDbusService::ShowRestorePage()
{
    if (nullptr != m_mainWindow) {
        m_mainWindow->ShowRestorePage();
    }
}

void RecoverySessionDbusService::ShowSystemClonePage()
{
    if (nullptr != m_mainWindow) {
        m_mainWindow->ShowSystemClonePage();
    }
}

void RecoverySessionDbusService::ShowNewBackupPage()
{
    if (nullptr != m_mainWinSnipe) {
        m_mainWinSnipe->ShowNewBackupPage();
    }
}

void RecoverySessionDbusService::ShowNewRestorePage()
{
    if (nullptr != m_mainWinSnipe) {
        m_mainWinSnipe->ShowNewRestorePage();
    }
}

void RecoverySessionDbusService::ShowNewFactoryRestorePage()
{
    if (nullptr != m_mainWinSnipe) {
        m_mainWinSnipe->ShowNewFactoryRestorePage();
    }
}
