## RabbitMQ 4.0.6

RabbitMQ `4.0.6` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `27.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).

### Core Broker

#### Bug Fixes

 * When a quorum queue leader has changed, followers were not always notified of
   unapplied [for/by them] log commands.

   GitHub issue: [#13095](https://github.com/rabbitmq/rabbitmq-server/pull/13095)

 * Default cluster formation timeout with [Khepri](https://www.rabbitmq.com/docs/metadata-store) now matches that of Mnesia (5 minutes by default).

   Discovered and reported by @evolvedlight.

   GitHub issue: [#13195](https://github.com/rabbitmq/rabbitmq-server/pull/13195)

 * When stream consumer was cancelled, an [internal event](https://www.rabbitmq.com/docs/logging#internal-events) was not emitted.

   GitHub issues: [#13085](https://github.com/rabbitmq/rabbitmq-server/pull/13085), [#9356](https://github.com/rabbitmq/rabbitmq-server/pull/9356), [#13097](https://github.com/rabbitmq/rabbitmq-server/pull/13097)

 * Stream consumer metrics were not cleared when its respective connection was closed.

   GitHub issue: [#13086](https://github.com/rabbitmq/rabbitmq-server/pull/13086)

 * Quorum queues could return a list of members (replicas) with duplicates in some cases.

   GitHub issue: [#13168](https://github.com/rabbitmq/rabbitmq-server/pull/13168)

 * Classic queues with priorities could run into an exception.

   GitHub issue: [#13088](https://github.com/rabbitmq/rabbitmq-server/pull/13088)

 * Corrected a log message.

   GitHub issue: [#13155](https://github.com/rabbitmq/rabbitmq-server/pull/13155)

#### Enhancements

 * A new mechanism for protecting a virtual host from deletion using metadata.

   GitHub issues: [#12772](https://github.com/rabbitmq/rabbitmq-server/issues/12772), [#13017](https://github.com/rabbitmq/rabbitmq-server/pull/13017)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl import_definitions` hanged when definitions were provided via the standard input
    instead of a file.

    GitHub issue: [#13157](https://github.com/rabbitmq/rabbitmq-server/issues/13157)

#### Enhancements

 * [`rabbitmqadmin` v2](https://www.rabbitmq.com/docs/management-cli) has matured enough to recommend
   it over the original version of the tool

 * `rabbitmq-diagnostics ` CLI documentation was improved to clarify that all certificates
   discovered will be checked for expiration.

   GitHub issue: [#13038](https://github.com/rabbitmq/rabbitmq-server/pull/13038)

 * New health checks for [metadata store](https://www.rabbitmq.com/docs/metadata-store) initialization:

   1. `rabbitmq-diagnostics check_if_metadata_store_is_initialized`
   2. `rabbitmq-diagnostics check_if_metadata_store_is_initialized_with_data`

   GitHub issue: [#13169](https://github.com/rabbitmq/rabbitmq-server/pull/13169)


### Prometheus Plugin

#### Bug Fixes

 * Improved metric description.

   GitHub issue: [#13178](https://github.com/rabbitmq/rabbitmq-server/pull/13178)


### Management Plugin

#### Bug Fixes

 * Pagination-related sections of the HTTP API reference were clarified to explain
   that the maximum page size cannot exceed 500.

   GitHub issue: [#13042](https://github.com/rabbitmq/rabbitmq-server/issues/13042)

 * Empty `channel_details` objects are now serialized as empty objects and not empty arrays.

   GitHub issue: [#13091](https://github.com/rabbitmq/rabbitmq-server/pull/13091)

#### Enhancements

 * New health checks for [metadata store](https://www.rabbitmq.com/docs/metadata-store) initialization:

   1. GET `/api/health/checks/metadata-store/initialized`
   2. GET `/api/health/checks/metadata-store/initialized/with-data`

   GitHub issue: [#13169](https://github.com/rabbitmq/rabbitmq-server/pull/13169)

#### Deprecations

 * The original HTTP API One True Health Check™ is now a no-op. A comparable "mega health check"
   has long been deprecated in CLI tools and was made a no-op in `4.0.0`.

   This endpoint was using a [deprecated feature](https://www.rabbitmq.com/docs/deprecated-features): a classic non-exclusive transient (non-durable) queue.

   See [Health Checks](https://www.rabbitmq.com/docs/monitoring#health-checks) for modern focused alternatives.

   GitHub issue: [#13047](https://github.com/rabbitmq/rabbitmq-server/issues/13047)


### Consul Peer Discovery Plugin

#### Enhancements

 * `cluster_formation.registration.enabled` is a new configuration setting that allows the backend to skip registration.

   This is useful when Consul is used for peer discovery but a different tool such as Nomad
   is used to keep track of the services and their registration, unregistration.

   Contributed by @frederikbosch.

   GitHub issue: [#13201](https://github.com/rabbitmq/rabbitmq-server/pull/13201)


### Erlang AMQP 1.0 Client

#### Bug Fixes

 * Purging an non-existing queue now returns a 404 response.

   GitHub issue: [#13148](https://github.com/rabbitmq/rabbitmq-server/pull/13148)


### Dependency Changes

 * `ra` was upgraded to [`2.15.1`](https://github.com/rabbitmq/ra/releases)
 * `observer_cli` was upgraded to [`1.8.2`](https://github.com/zhongwencool/observer_cli/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.6.tar.xz`
instead of the source tarball produced by GitHub.
