/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.shared.http;

import org.jetbrains.kotlin.org.apache.http.HttpHost;
import org.jetbrains.kotlin.org.apache.http.auth.AuthScope;

public class BasicAuthScope {
    private String host;
    private String port;
    private String realm;

    public String getHost() {
        return this.host;
    }

    public String getRealm() {
        return this.realm;
    }

    public AuthScope getScope(String host, int port) {
        int scopePort;
        if (this.getHost() != null && "ANY".compareTo(this.getHost()) == 0 && this.getPort() != null && "ANY".compareTo(this.getPort()) == 0 && this.getRealm() != null && "ANY".compareTo(this.getRealm()) == 0) {
            return AuthScope.ANY;
        }
        String scopeHost = host;
        if (this.getHost() != null) {
            scopeHost = "ANY".compareTo(this.getHost()) == 0 ? AuthScope.ANY_HOST : this.getHost();
        }
        int n = scopePort = port > -1 ? port : -1;
        if (this.getPort() != null) {
            scopePort = "ANY".compareTo(this.getPort()) == 0 ? -1 : Integer.parseInt(this.getPort());
        }
        String scopeRealm = AuthScope.ANY_REALM;
        if (this.getRealm() != null) {
            scopeRealm = "ANY".compareTo(this.getRealm()) != 0 ? this.getRealm() : this.getRealm();
        }
        return new AuthScope(scopeHost, scopePort, scopeRealm);
    }

    public String getPort() {
        return this.port;
    }

    public AuthScope getScope(HttpHost targetHost) {
        return this.getScope(targetHost.getHostName(), targetHost.getPort());
    }
}

