/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_es extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_hy = "armenio";
        final String metaValue_ae = "av\u00e9stico";
        final String metaValue_ban = "balin\u00e9s";
        final String metaValue_bn = "bengal\u00ed";
        final String metaValue_bug = "bugin\u00e9s";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cheroqui";
        final String metaValue_cop = "copto";
        final String metaValue_ka = "georgiano";
        final String metaValue_got = "g\u00f3tico";
        final String metaValue_el = "griego";
        final String metaValue_gu = "guyarat\u00ed";
        final String metaValue_he = "hebreo";
        final String metaValue_jv = "javan\u00e9s";
        final String metaValue_ja = "japon\u00e9s";
        final String metaValue_km = "jemer";
        final String metaValue_kn = "canar\u00e9s";
        final String metaValue_ko = "coreano";
        final String metaValue_ml = "malay\u00e1lam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmano";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "oriya";
        final String metaValue_phn = "fenicio";
        final String metaValue_si = "cingal\u00e9s";
        final String metaValue_su = "sundan\u00e9s";
        final String metaValue_syr = "siriaco";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalo";
        final String metaValue_th = "tailand\u00e9s";
        final String metaValue_bo = "tibetano";
        final String metaValue_uga = "ugar\u00edtico";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persa antiguo";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica del Norte" },
            { "005", "Sudam\u00e9rica" },
            { "009", "Ocean\u00eda" },
            { "011", "\u00c1frica occidental" },
            { "013", "Centroam\u00e9rica" },
            { "014", "\u00c1frica oriental" },
            { "015", "\u00c1frica septentrional" },
            { "017", "\u00c1frica central" },
            { "018", "\u00c1frica meridional" },
            { "019", "Am\u00e9rica" },
            { "021", "Norteam\u00e9rica" },
            { "029", "Caribe" },
            { "030", "Asia oriental" },
            { "034", "Asia meridional" },
            { "035", "Sudeste asi\u00e1tico" },
            { "039", "Europa meridional" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Regi\u00f3n de Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia central" },
            { "145", "Asia occidental" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "155", "Europa occidental" },
            { "202", "\u00c1frica subsahariana" },
            { "419", "Latinoam\u00e9rica" },
            { "AC", "Isla de la Ascensi\u00f3n" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Unidos" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islas Aland" },
            { "AZ", "Azerbaiy\u00e1n" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglad\u00e9s" },
            { "BE", "B\u00e9lgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bar\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Bermudas" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe neerland\u00e9s" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "But\u00e1n" },
            { "BV", "Isla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belice" },
            { "CA", "Canad\u00e1" },
            { "CC", "Islas Cocos" },
            { "CD", "Rep\u00fablica Democr\u00e1tica del Congo" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congo" },
            { "CH", "Suiza" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Isla Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curazao" },
            { "CX", "Isla de Navidad" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "DE", "Alemania" },
            { "DG", "Diego Garc\u00eda" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Argelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "S\u00e1hara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Uni\u00f3n Europea" },
            { "EZ", "zona del euro" },
            { "FI", "Finlandia" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Islas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gab\u00f3n" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islas Georgia del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bis\u00e1u" },
            { "GY", "Guyana" },
            { "HK", "RAE de Hong Kong (China)" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "IC", "Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "IO", "Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico" },
            { "IQ", "Irak" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Jap\u00f3n" },
            { "KE", "Kenia" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "San Crist\u00f3bal y Nieves" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islas Caim\u00e1n" },
            { "KZ", "Kazajist\u00e1n" },
            { "LA", "Laos" },
            { "LB", "L\u00edbano" },
            { "LC", "Santa Luc\u00eda" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "San Mart\u00edn" },
            { "MG", "Madagascar" },
            { "MH", "Islas Marshall" },
            { "MK", "Macedonia del Norte" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "RAE de Macao (China)" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xico" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "N\u00edger" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Bajos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panam\u00e1" },
            { "PE", "Per\u00fa" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakist\u00e1n" },
            { "PL", "Polonia" },
            { "PM", "San Pedro y Miquel\u00f3n" },
            { "PN", "Islas Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Catar" },
            { "QO", "Territorios alejados de Ocean\u00eda" },
            { "RE", "Reuni\u00f3n" },
            { "RO", "Ruman\u00eda" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saud\u00ed" },
            { "SB", "Islas Salom\u00f3n" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e1n" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Elena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sud\u00e1n del Sur" },
            { "ST", "Santo Tom\u00e9 y Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Esuatini" },
            { "TA", "Trist\u00e1n de Acu\u00f1a" },
            { "TC", "Islas Turcas y Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tayikist\u00e1n" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "T\u00fanez" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinidad y Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "TZ", "Tanzania" },
            { "UA", "Ucrania" },
            { "UG", "Uganda" },
            { "UM", "Islas menores alejadas de EE. UU." },
            { "UN", "Naciones Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekist\u00e1n" },
            { "VA", "Ciudad del Vaticano" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Islas V\u00edrgenes Brit\u00e1nicas" },
            { "VI", "Islas V\u00edrgenes de EE. UU." },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoacentos" },
            { "XB", "Pseudobidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud\u00e1frica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Regi\u00f3n desconocida" },
            { "aa", "afar" },
            { "ab", "abjasio" },
            { "ae", metaValue_ae },
            { "af", "afrik\u00e1ans" },
            { "ak", "akan" },
            { "am", "am\u00e1rico" },
            { "an", "aragon\u00e9s" },
            { "ar", metaValue_ar },
            { "as", "asam\u00e9s" },
            { "av", "avar" },
            { "ay", "aimara" },
            { "az", "azerbaiyano" },
            { "ba", "baskir" },
            { "be", "bielorruso" },
            { "bg", "b\u00falgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bret\u00f3n" },
            { "bs", "bosnio" },
            { "ca", "catal\u00e1n" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "checo" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "chuvasio" },
            { "cy", "gal\u00e9s" },
            { "da", "dan\u00e9s" },
            { "de", "alem\u00e1n" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ew\u00e9" },
            { "el", metaValue_el },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "es", "espa\u00f1ol" },
            { "et", "estonio" },
            { "eu", "euskera" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "fin\u00e9s" },
            { "fj", "fiyiano" },
            { "fo", "fero\u00e9s" },
            { "fr", "franc\u00e9s" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9lico escoc\u00e9s" },
            { "gl", "gallego" },
            { "gn", "guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "man\u00e9s" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "criollo haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesio" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichu\u00e1n" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "island\u00e9s" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazajo" },
            { "kl", "groenland\u00e9s" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cachemir" },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "kirgu\u00eds" },
            { "la", "lat\u00edn" },
            { "lb", "luxemburgu\u00e9s" },
            { "lg", "ganda" },
            { "li", "limburgu\u00e9s" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "mg", "malgache" },
            { "mh", "marshal\u00e9s" },
            { "mi", "maor\u00ed" },
            { "mk", "macedonio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marat\u00ed" },
            { "ms", "malayo" },
            { "mt", "malt\u00e9s" },
            { "my", metaValue_my },
            { "na", "nauruano" },
            { "nb", "noruego bokmal" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepal\u00ed" },
            { "ng", "ndonga" },
            { "nl", "neerland\u00e9s" },
            { "nn", "noruego nynorsk" },
            { "no", "noruego" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitano" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "os\u00e9tico" },
            { "pa", "punyab\u00ed" },
            { "pi", "pali" },
            { "pl", "polaco" },
            { "ps", "past\u00fan" },
            { "pt", "portugu\u00e9s" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "kirundi" },
            { "ro", "rumano" },
            { "ru", "ruso" },
            { "rw", "kinyarwanda" },
            { "sa", "s\u00e1nscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami septentrional" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somal\u00ed" },
            { "sq", "alban\u00e9s" },
            { "sr", "serbio" },
            { "ss", "suazi" },
            { "st", "sotho meridional" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "suajili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tayiko" },
            { "th", metaValue_th },
            { "ti", "tigri\u00f1a" },
            { "tk", "turcomano" },
            { "tl", metaValue_tl },
            { "tn", "setsuana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "t\u00e1rtaro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "ug", "uigur" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "uz", "uzbeko" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volap\u00fck" },
            { "wa", "val\u00f3n" },
            { "wo", "w\u00f3lof" },
            { "xh", "xhosa" },
            { "yi", "yidis" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chino" },
            { "zu", "zul\u00fa" },
            { "ace", "achen\u00e9s" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigu\u00e9" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "acadio" },
            { "ale", "aleutiano" },
            { "alt", "alt\u00e1i meridional" },
            { "ang", "ingl\u00e9s antiguo" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameo" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "\u00e1rabe najd\u00ed" },
            { "arw", "arahuaco" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "avadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bax", "bam\u00fan" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgn", "baluchi occidental" },
            { "bho", "bhoyapur\u00ed" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriato" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagat\u00e1i" },
            { "chk", "truk\u00e9s" },
            { "chm", "mar\u00ed" },
            { "chn", "jerga chinuk" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyene" },
            { "ckb", "kurdo sorani" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "t\u00e1rtaro de Crimea" },
            { "crj", "cree suroriental" },
            { "crk", "cree de las llanuras" },
            { "crl", "cree nororiental" },
            { "crm", "cree moose" },
            { "crr", "algonquino de Carolina" },
            { "crs", "criollo seychelense" },
            { "csb", "casubio" },
            { "csw", "cree de los pantanos" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "bajo sorbio" },
            { "dua", "duala" },
            { "dum", "neerland\u00e9s medio" },
            { "dyo", "jola-fonyi" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "egipcio antiguo" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "ingl\u00e9s medio" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fon", "fon" },
            { "frc", "franc\u00e9s caj\u00fan" },
            { "frm", "franc\u00e9s medio" },
            { "fro", "franc\u00e9s antiguo" },
            { "frr", "fris\u00f3n septentrional" },
            { "frs", "fris\u00f3n oriental" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauzo" },
            { "gan", "chino gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbert\u00e9s" },
            { "gmh", "alto alem\u00e1n medio" },
            { "goh", "alto alem\u00e1n antiguo" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "griego antiguo" },
            { "gsw", "alem\u00e1n suizo" },
            { "guz", "gusii" },
            { "gwi", "kutchin" },
            { "hai", "haida" },
            { "hak", "chino hakka" },
            { "haw", "hawaiano" },
            { "hax", "haida meridional" },
            { "hil", "hiligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "alto sorbio" },
            { "hsn", "chino xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuit del oeste de Canad\u00e1" },
            { "ilo", "ilocano" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "judeo-persa" },
            { "jrb", "judeo-\u00e1rabe" },
            { "kaa", "karakalpako" },
            { "kab", "cabila" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardiano" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "criollo caboverdiano" },
            { "kfo", "koro" },
            { "kgp", "k\u00e1ingang" },
            { "kha", "khasi" },
            { "kho", "kotan\u00e9s" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi permio" },
            { "kok", "konkan\u00ed" },
            { "kos", "kosraeano" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "carelio" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgiano" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombardo" },
            { "lol", "mongo" },
            { "lou", "criollo de Luisiana" },
            { "loz", "lozi" },
            { "lrc", "lor\u00ed septentrional" },
            { "lsm", "samia" },
            { "lua", "luba-lulua" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madur\u00e9s" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "macasar" },
            { "man", "mandingo" },
            { "mas", "mas\u00e1i" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "criollo mauriciano" },
            { "mga", "irland\u00e9s medio" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manch\u00fa" },
            { "mni", "manipur\u00ed" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "varios idiomas" },
            { "mus", "creek" },
            { "mwl", "mirand\u00e9s" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazandaran\u00ed" },
            { "nan", "chino min nan" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "bajo alem\u00e1n" },
            { "new", "nevar\u00ed" },
            { "nia", "nias" },
            { "niu", "niueano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "n\u00f3rdico antiguo" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho septentrional" },
            { "nus", "nuer" },
            { "nwc", "newari cl\u00e1sico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwa noroccidental" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa occidental" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turco otomano" },
            { "pag", "pangasin\u00e1n" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin de Nigeria" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "pidgin salomonense" },
            { "pon", "pohnpeiano" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prusiano" },
            { "pro", "provenzal antiguo" },
            { "quc", "quich\u00e9" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "rohiny\u00e1" },
            { "rof", "rombo" },
            { "rom", "roman\u00ed" },
            { "rup", "arrumano" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "arameo samaritano" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "escoc\u00e9s" },
            { "sdh", "kurdo meridional" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irland\u00e9s antiguo" },
            { "shi", "tashelhit" },
            { "shn", "shan" },
            { "shu", "\u00e1rabe chadiano" },
            { "sid", "sidamo" },
            { "slh", "lushootseed meridional" },
            { "sma", "sami meridional" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "sonink\u00e9" },
            { "sog", "sogdiano" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "salish de los estrechos" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerio" },
            { "swb", "comorense" },
            { "syc", "sir\u00edaco cl\u00e1sico" },
            { "syr", metaValue_syr },
            { "tce", "tutchone meridional" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tet\u00fan" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "tokelauano" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "tonga del Nyasa" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshiano" },
            { "ttm", "tutchone septentrional" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluano" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniano" },
            { "tzm", "tamazight del Atlas Central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "lengua desconocida" },
            { "vai", metaValue_vai },
            { "vot", "v\u00f3tico" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolayta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "chino wu" },
            { "xal", "kalmyk" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yap\u00e9s" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "\u00f1e\u2019engat\u00fa" },
            { "yue", "canton\u00e9s" },
            { "zap", "zapoteco" },
            { "zbl", "s\u00edmbolos Bliss" },
            { "zen", "zenaga" },
            { "zgh", "tamazight est\u00e1ndar marroqu\u00ed" },
            { "zun", "zu\u00f1i" },
            { "zxx", "sin contenido ling\u00fc\u00edstico" },
            { "zza", "zazaki" },
            { "Adlm", "\u00e1dlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "s\u00edmbolos blis" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabarios abor\u00edgenes canadienses unificados" },
            { "Cari", "cario" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "chipriota" },
            { "Cyrl", "cir\u00edlico" },
            { "Cyrs", "cir\u00edlico del antiguo eslavo eclesi\u00e1stico" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipcio dem\u00f3tico" },
            { "Egyh", "egipcio hier\u00e1tico" },
            { "Egyp", "jerogl\u00edficos egipcios" },
            { "Ethi", "eti\u00f3pico" },
            { "Geok", "georgiano eclesi\u00e1stico" },
            { "Geor", metaValue_ka },
            { "Glag", "glagol\u00edtico" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuji" },
            { "Hanb", "han con bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "silabarios japoneses" },
            { "Hung", "h\u00fangaro antiguo" },
            { "Inds", "Indio (harappan)" },
            { "Ital", "antigua bastardilla" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "lanna" },
            { "Laoo", "laosiano" },
            { "Latf", "latino fraktur" },
            { "Latg", "latino ga\u00e9lico" },
            { "Latn", "latino" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineal A" },
            { "Linb", "lineal B" },
            { "Lyci", "licio" },
            { "Lydi", "lidio" },
            { "Mand", "mandeo" },
            { "Maya", "jerogl\u00edficos mayas" },
            { "Mero", "mero\u00edtico" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmaniya" },
            { "Perm", "permiano antiguo" },
            { "Phag", "phags-pa" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollard Miao" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongo-rongo" },
            { "Runr", "r\u00fanico" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "shaviano" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siriaco estrangelo" },
            { "Syrj", "siriaco occidental" },
            { "Syrn", "siriaco oriental" },
            { "Tagb", "tagban\u00faa" },
            { "Tale", "tai le" },
            { "Talu", "nuevo tai lue" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "lenguaje visible" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiforme sumerio-acadio" },
            { "Yiii", "yi" },
            { "Zinh", "heredado" },
            { "Zmth", "notaci\u00f3n matem\u00e1tica" },
            { "Zsye", "emojis" },
            { "Zsym", "s\u00edmbolos" },
            { "Zxxx", "no escrito" },
            { "Zyyy", "com\u00fan" },
            { "Zzzz", "alfabeto desconocido" },
            { "de_AT", "alem\u00e1n austr\u00edaco" },
            { "de_CH", "alto alem\u00e1n suizo" },
            { "en_AU", "ingl\u00e9s australiano" },
            { "en_CA", "ingl\u00e9s canadiense" },
            { "en_GB", "ingl\u00e9s brit\u00e1nico" },
            { "en_US", "ingl\u00e9s estadounidense" },
            { "es_ES", "espa\u00f1ol de Espa\u00f1a" },
            { "es_MX", "espa\u00f1ol de M\u00e9xico" },
            { "fa_AF", "dar\u00ed" },
            { "fr_CA", "franc\u00e9s canadiense" },
            { "fr_CH", "franc\u00e9s suizo" },
            { "nl_BE", "flamenco" },
            { "pt_BR", "portugu\u00e9s de Brasil" },
            { "pt_PT", "portugu\u00e9s de Portugal" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "suajili del Congo" },
            { "%%1901", "Ortograf\u00eda alemana tradicional" },
            { "%%1996", "Ortograf\u00eda alemana de 1996" },
            { "ar_001", "\u00e1rabe est\u00e1ndar moderno" },
            { "es_419", "espa\u00f1ol latinoamericano" },
            { "key.ca", "calendario" },
            { "key.cf", "formato de moneda" },
            { "key.co", "orden" },
            { "key.cu", "moneda" },
            { "key.hc", "ciclo horario (12 o 24 horas)" },
            { "key.lb", "estilo de salto de l\u00ednea" },
            { "key.ms", "sistema de medici\u00f3n" },
            { "key.nu", "n\u00fameros" },
            { "key.tz", "zona horaria" },
            { "key.va", "variante local" },
            { "nds_NL", "bajo saj\u00f3n" },
            { "%%POSIX", "Ordenador" },
            { "zh_Hans", "chino simplificado" },
            { "zh_Hant", "chino tradicional" },
            { "%%FONIPA", "Alfabeto fon\u00e9tico internacional IPA" },
            { "%%PINYIN", "Romanizaci\u00f3n pinyin" },
            { "%%AREVELA", "Armenio oriental" },
            { "%%MONOTON", "Monot\u00f3nico" },
            { "%%POLYTON", "Polit\u00f3nico" },
            { "%%REVISED", "Ortograf\u00eda revisada" },
            { "%%SCOTLAND", "Ingl\u00e9s escoc\u00e9s est\u00e1ndar" },
            { "%%VALENCIA", "Valenciano" },
            { "%%WADEGILE", "Romanizaci\u00f3n Wade-Giles" },
            { "type.ca.roc", "calendario de la Rep\u00fablica de China" },
            { "type.co.eor", "reglas de ordenaci\u00f3n europeas" },
            { "type.hc.h11", "sistema de 12 horas (0\u201311)" },
            { "type.hc.h12", "sistema de 12 horas (1\u201312)" },
            { "type.hc.h23", "sistema de 24 horas (0\u201323)" },
            { "type.hc.h24", "sistema de 24 horas (1\u201324)" },
            { "type.m0.bgn", "transliteraci\u00f3n USBGN" },
            { "type.nu.arab", "d\u00edgitos indoar\u00e1bigos" },
            { "type.nu.armn", "n\u00fameros en armenio" },
            { "type.nu.beng", "d\u00edgitos en bengal\u00ed" },
            { "type.nu.cakm", "d\u00edgitos en chakma" },
            { "type.nu.deva", "d\u00edgitos en devanagari" },
            { "type.nu.ethi", "n\u00fameros en et\u00edope" },
            { "type.nu.geor", "n\u00fameros en georgiano" },
            { "type.nu.grek", "n\u00fameros en griego" },
            { "type.nu.gujr", "d\u00edgitos en guyarat\u00ed" },
            { "type.nu.guru", "d\u00edgitos en gurmuji" },
            { "type.nu.hans", "n\u00fameros en chino simplificado" },
            { "type.nu.hant", "n\u00fameros en chino tradicional" },
            { "type.nu.hebr", "n\u00fameros en hebreo" },
            { "type.nu.java", "d\u00edgitos en javan\u00e9s" },
            { "type.nu.jpan", "n\u00fameros en japon\u00e9s" },
            { "type.nu.khmr", "d\u00edgitos en jemer" },
            { "type.nu.knda", "d\u00edgitos en canar\u00e9s" },
            { "type.nu.laoo", "d\u00edgitos en lao" },
            { "type.nu.latn", "d\u00edgitos occidentales" },
            { "type.nu.mlym", "d\u00edgitos en malay\u00e1lam" },
            { "type.nu.mong", "d\u00edgitos en mongol" },
            { "type.nu.mtei", "d\u00edgitos en meitei" },
            { "type.nu.mymr", "d\u00edgitos en birmano" },
            { "type.nu.olck", "d\u00edgitos en ol chiki" },
            { "type.nu.orya", "d\u00edgitos en oriya" },
            { "type.nu.taml", "n\u00fameros en tamil tradicional" },
            { "type.nu.telu", "d\u00edgitos en telugu" },
            { "type.nu.thai", "d\u00edgitos en tailand\u00e9s" },
            { "type.nu.tibt", "d\u00edgitos en tibetano" },
            { "type.nu.vaii", "d\u00edgitos en vai" },
            { "type.ca.dangi", "calendario dangi" },
            { "type.co.ducet", "orden predeterminado de Unicode" },
            { "type.lb.loose", "estilo de salto de l\u00ednea flexible" },
            { "type.nu.roman", "n\u00fameros romanos" },
            { "type.ca.coptic", "calendario c\u00f3ptico" },
            { "type.ca.hebrew", "calendario hebreo" },
            { "type.ca.indian", "calendario nacional hind\u00fa" },
            { "type.co.compat", "orden anterior, para compatibilidad" },
            { "type.co.pinyin", "orden pinyin" },
            { "type.co.search", "b\u00fasqueda de uso general" },
            { "type.co.stroke", "orden de los trazos" },
            { "type.co.unihan", "orden de trazos radicales" },
            { "type.co.zhuyin", "orden zhuyin" },
            { "type.d0.fwidth", "ancho completo" },
            { "type.d0.hwidth", "ancho medio" },
            { "type.lb.normal", "estilo de salto de l\u00ednea normal" },
            { "type.lb.strict", "estilo de salto de l\u00ednea estricto" },
            { "type.m0.ungegn", "transliteraci\u00f3n UNGEGN" },
            { "type.ms.metric", "sistema m\u00e9trico" },
            { "type.nu.native", "d\u00edgitos nativos" },
            { "type.ca.chinese", "calendario chino" },
            { "type.ca.islamic", "calendario isl\u00e1mico" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "type.ca.persian", "calendario persa" },
            { "type.cf.account", "formato de moneda de contabilidad" },
            { "type.co.big5han", "orden del chino tradicional - Big5" },
            { "type.d0.npinyin", "Num\u00e9rico" },
            { "type.nu.arabext", "d\u00edgitos indoar\u00e1bigos extendidos" },
            { "type.nu.armnlow", "n\u00fameros en armenio en min\u00fascula" },
            { "type.nu.finance", "N\u00fameros financieros" },
            { "type.nu.greklow", "n\u00fameros en griego en min\u00fascula" },
            { "type.nu.hanidec", "n\u00fameros decimales en chino" },
            { "type.nu.hansfin", "n\u00fameros financieros en chino simplificado" },
            { "type.nu.hantfin", "n\u00fameros financieros en chino tradicional" },
            { "type.nu.jpanfin", "n\u00fameros financieros en japon\u00e9s" },
            { "type.nu.tamldec", "d\u00edgitos en tamil" },
            { "type.ca.buddhist", "calendario budista" },
            { "type.ca.ethiopic", "calendario et\u00edope" },
            { "type.ca.japanese", "calendario japon\u00e9s" },
            { "type.cf.standard", "formato de moneda est\u00e1ndar" },
            { "type.co.phonetic", "orden fon\u00e9tico" },
            { "type.co.reformed", "orden reformado" },
            { "type.co.searchjl", "Buscar por consonante inicial de hangul" },
            { "type.co.standard", "orden est\u00e1ndar" },
            { "type.ms.uksystem", "sistema imperial" },
            { "type.ms.ussystem", "sistema estadounidense" },
            { "type.nu.fullwide", "d\u00edgitos de ancho completo" },
            { "type.nu.romanlow", "n\u00fameros romanos en min\u00fascula" },
            { "type.ca.gregorian", "calendario gregoriano" },
            { "type.co.gb2312han", "orden del chino simplificado - GB2312" },
            { "type.co.phonebook", "orden de list\u00edn telef\u00f3nico" },
            { "type.co.dictionary", "orden de diccionario" },
            { "type.co.traditional", "orden tradicional" },
            { "type.nu.traditional", "N\u00fameros tradicionales" },
            { "type.ca.islamic-civil", "calendario isl\u00e1mico tabular" },
            { "type.ca.islamic-umalqura", "calendario isl\u00e1mico Umm al-Qura" },
            { "type.ca.ethiopic-amete-alem", "calendario et\u00edope Amete Alem" },
        };
        return data;
    }
}
