/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import sun.jvm.hotspot.debugger.SymbolLookup;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.BasicVtblAccess;

public class HotSpotSolarisVtblAccess
extends BasicVtblAccess {
    public HotSpotSolarisVtblAccess(SymbolLookup symbolLookup, String[] jvmLibNames) {
        super(symbolLookup, jvmLibNames);
    }

    @Override
    protected String vtblSymbolForType(Type type) {
        String demangledSymbol = type.getName() + "::__vtbl";
        return this.mangle(demangledSymbol);
    }

    private String mangle(String symbol) {
        String[] parts = symbol.split("::");
        StringBuffer mangled = new StringBuffer("__1c");
        for (int i = 0; i < parts.length; ++i) {
            int len = parts[i].length();
            if (len >= 26) {
                mangled.append((char)(97 + len / 26));
                len %= 26;
            }
            mangled.append((char)(65 + len));
            mangled.append(parts[i]);
        }
        mangled.append("_");
        return mangled.toString();
    }
}

