#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>
#include <unistd.h>
#include <sys/wait.h>

int main(int argc, char **argv)
{
	const char *fifo = "/dev/guild";
	const char *opt = "--jobserver-auth=fifo:/dev/guild";
	int fd;
	if ((fd = open(fifo, O_RDWR | O_CLOEXEC)) < 0) {
		perror(fifo);
		return 1;
	}
	char token;
	ssize_t r;
	switch (r = read(fd, &token, 1)) {
	case -1:
		perror("read");
	case 0:
		return 1;
	}
	pid_t pid;
	if (!(pid = fork())) {
		const char *e;
		char buf[512];
		if (!(e = getenv("MAKEFLAGS")))
			e = opt;
		else if (snprintf(buf, sizeof buf, "%s %s", e, opt)
			 <= sizeof buf)
			e = buf;
		setenv("MAKEFLAGS", e, 1);
		execvp(argv[1], argv+1);
		perror(argv[1]);
		_Exit(1);
	}
	if (pid < 0) {
		perror("fork");
		return 1;
	}
	int ws;
	if (waitpid(pid, &ws, 0) < 0) {
		perror("waitpid");
		return 1;
	}
	if (write(fd, &token, 1) < 0) {
		perror("write");
		return 1;
	}
	if (WIFSIGNALED(ws))
		return WTERMSIG(ws) + 128;
	return WEXITSTATUS(ws);
}
