/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class EndsWith
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 2;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        StringValue arg0 = (StringValue)this.argument[0].evaluateItem(context);
        StringValue arg1 = (StringValue)this.argument[1].evaluateItem(context);
        try {
            return EndsWith.endsWith(arg0, arg1, this.getCollator(context));
        }
        catch (XPathException err) {
            err.maybeSetContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public static boolean endsWith(StringValue arg0, StringValue arg1, StringCollator collator) throws XPathException {
        if (arg1 == null || arg1.isZeroLength()) {
            return true;
        }
        if (arg0 == null || arg0.isZeroLength()) {
            return false;
        }
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof CodepointCollator) {
            return s0.endsWith(s1);
        }
        if (collator instanceof SimpleCollation && ((SimpleCollation)collator).getCollation() instanceof RuleBasedCollator) {
            collator = new RuleBasedSubstringMatcher((RuleBasedCollator)((SimpleCollation)collator).getCollation());
        }
        if (collator instanceof SubstringMatcher) {
            return ((SubstringMatcher)collator).endsWith(s0, s1);
        }
        throw new XPathException("The collation requested for ends-with() does not support substring matching", "FOCH0004");
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        try {
            StringValue s0 = (StringValue)arguments[0].head();
            StringValue s1 = (StringValue)arguments[1].head();
            StringCollator collator = this.getCollatorFromLastArgument(arguments, 2, context);
            return BooleanValue.get(EndsWith.endsWith(s0, s1, collator));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }
}

