//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmenuitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSMenuItem;
);

#[cfg(feature = "NSAccessibilityProtocols")]
extern_conformance!(
    unsafe impl NSAccessibility for NSMenuItem {}
);

#[cfg(feature = "NSAccessibilityProtocols")]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSMenuItem {}
);

extern_conformance!(
    unsafe impl NSCoding for NSMenuItem {}
);

extern_conformance!(
    unsafe impl NSCopying for NSMenuItem {}
);

unsafe impl CopyingHelper for NSMenuItem {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSMenuItem {}
);

#[cfg(feature = "NSUserInterfaceItemIdentification")]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSMenuItem {}
);

#[cfg(feature = "NSUserInterfaceValidation")]
extern_conformance!(
    unsafe impl NSValidatedUserInterfaceItem for NSMenuItem {}
);

impl NSMenuItem {
    extern_methods!(
        #[unsafe(method(usesUserKeyEquivalents))]
        #[unsafe(method_family = none)]
        pub fn usesUserKeyEquivalents(mtm: MainThreadMarker) -> bool;

        /// Setter for [`usesUserKeyEquivalents`][Self::usesUserKeyEquivalents].
        #[unsafe(method(setUsesUserKeyEquivalents:))]
        #[unsafe(method_family = none)]
        pub fn setUsesUserKeyEquivalents(uses_user_key_equivalents: bool, mtm: MainThreadMarker);

        #[unsafe(method(separatorItem))]
        #[unsafe(method_family = none)]
        pub fn separatorItem(mtm: MainThreadMarker) -> Retained<NSMenuItem>;

        /// Creates a menu item representing a section header with the provided title.
        /// Section header items are used to provide context to a grouping of menu items.
        /// Items created using this method are non-interactive and do not perform an action.
        #[unsafe(method(sectionHeaderWithTitle:))]
        #[unsafe(method_family = none)]
        pub fn sectionHeaderWithTitle(title: &NSString, mtm: MainThreadMarker) -> Retained<Self>;

        /// An array of standard menu items related to Writing Tools.
        /// Each call to this method returns an array of newly allocated instances of NSMenuItem.
        #[unsafe(method(writingToolsItems))]
        #[unsafe(method_family = none)]
        pub fn writingToolsItems(mtm: MainThreadMarker) -> Retained<NSArray<NSMenuItem>>;

        /// # Safety
        ///
        /// `selector` must be a valid selector.
        #[unsafe(method(initWithTitle:action:keyEquivalent:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTitle_action_keyEquivalent(
            this: Allocated<Self>,
            string: &NSString,
            selector: Option<Sel>,
            char_code: &NSString,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "NSMenu")]
        /// Note: Never call the setter method directly: it is there only for subclassers.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub unsafe fn menu(&self) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        /// Setter for [`menu`][Self::menu].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenu(&self, menu: Option<&NSMenu>);

        #[unsafe(method(hasSubmenu))]
        #[unsafe(method_family = none)]
        pub fn hasSubmenu(&self) -> bool;

        #[cfg(feature = "NSMenu")]
        #[unsafe(method(submenu))]
        #[unsafe(method_family = none)]
        pub fn submenu(&self) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        /// Setter for [`submenu`][Self::submenu].
        #[unsafe(method(setSubmenu:))]
        #[unsafe(method_family = none)]
        pub fn setSubmenu(&self, submenu: Option<&NSMenu>);

        /// Returns: The `NSMenuItem` whose submenu contains the receiver, or nil if the receiver does not have a parent item.
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(parentItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn parentItem(&self) -> Option<Retained<NSMenuItem>>;

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: &NSString);

        #[unsafe(method(attributedTitle))]
        #[unsafe(method_family = none)]
        pub fn attributedTitle(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`attributedTitle`][Self::attributedTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAttributedTitle:))]
        #[unsafe(method_family = none)]
        pub fn setAttributedTitle(&self, attributed_title: Option<&NSAttributedString>);

        /// Used to specify a standard subtitle for the menu item.
        ///
        /// The subtitle is displayed below the standard title.
        ///
        /// Note: On macOS 14, a menu item with an attributed title does not show the subtitle. The subtitle is shown on macOS 15 and later.
        #[unsafe(method(subtitle))]
        #[unsafe(method_family = none)]
        pub fn subtitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`subtitle`][Self::subtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitle:))]
        #[unsafe(method_family = none)]
        pub fn setSubtitle(&self, subtitle: Option<&NSString>);

        #[unsafe(method(isSeparatorItem))]
        #[unsafe(method_family = none)]
        pub fn isSeparatorItem(&self) -> bool;

        /// Indicates whether the item is a section header.
        /// Section header items are created using the `sectionHeader(title:)` class method.
        #[unsafe(method(isSectionHeader))]
        #[unsafe(method_family = none)]
        pub fn isSectionHeader(&self) -> bool;

        #[unsafe(method(keyEquivalent))]
        #[unsafe(method_family = none)]
        pub fn keyEquivalent(&self) -> Retained<NSString>;

        /// Setter for [`keyEquivalent`][Self::keyEquivalent].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setKeyEquivalent:))]
        #[unsafe(method_family = none)]
        pub fn setKeyEquivalent(&self, key_equivalent: &NSString);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(keyEquivalentModifierMask))]
        #[unsafe(method_family = none)]
        pub fn keyEquivalentModifierMask(&self) -> NSEventModifierFlags;

        #[cfg(feature = "NSEvent")]
        /// Setter for [`keyEquivalentModifierMask`][Self::keyEquivalentModifierMask].
        #[unsafe(method(setKeyEquivalentModifierMask:))]
        #[unsafe(method_family = none)]
        pub fn setKeyEquivalentModifierMask(
            &self,
            key_equivalent_modifier_mask: NSEventModifierFlags,
        );

        #[unsafe(method(userKeyEquivalent))]
        #[unsafe(method_family = none)]
        pub fn userKeyEquivalent(&self) -> Retained<NSString>;

        #[unsafe(method(allowsKeyEquivalentWhenHidden))]
        #[unsafe(method_family = none)]
        pub fn allowsKeyEquivalentWhenHidden(&self) -> bool;

        /// Setter for [`allowsKeyEquivalentWhenHidden`][Self::allowsKeyEquivalentWhenHidden].
        #[unsafe(method(setAllowsKeyEquivalentWhenHidden:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsKeyEquivalentWhenHidden(&self, allows_key_equivalent_when_hidden: bool);

        #[unsafe(method(allowsAutomaticKeyEquivalentLocalization))]
        #[unsafe(method_family = none)]
        pub fn allowsAutomaticKeyEquivalentLocalization(&self) -> bool;

        /// Setter for [`allowsAutomaticKeyEquivalentLocalization`][Self::allowsAutomaticKeyEquivalentLocalization].
        #[unsafe(method(setAllowsAutomaticKeyEquivalentLocalization:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsAutomaticKeyEquivalentLocalization(
            &self,
            allows_automatic_key_equivalent_localization: bool,
        );

        #[unsafe(method(allowsAutomaticKeyEquivalentMirroring))]
        #[unsafe(method_family = none)]
        pub fn allowsAutomaticKeyEquivalentMirroring(&self) -> bool;

        /// Setter for [`allowsAutomaticKeyEquivalentMirroring`][Self::allowsAutomaticKeyEquivalentMirroring].
        #[unsafe(method(setAllowsAutomaticKeyEquivalentMirroring:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsAutomaticKeyEquivalentMirroring(
            &self,
            allows_automatic_key_equivalent_mirroring: bool,
        );

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub fn setImage(&self, image: Option<&NSImage>);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub fn state(&self) -> NSControlStateValue;

        #[cfg(feature = "NSCell")]
        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub fn setState(&self, state: NSControlStateValue);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(onStateImage))]
        #[unsafe(method_family = none)]
        pub fn onStateImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`onStateImage`][Self::onStateImage].
        ///
        /// # Safety
        ///
        /// `on_state_image` might not allow `None`.
        #[unsafe(method(setOnStateImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOnStateImage(&self, on_state_image: Option<&NSImage>);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(offStateImage))]
        #[unsafe(method_family = none)]
        pub fn offStateImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`offStateImage`][Self::offStateImage].
        #[unsafe(method(setOffStateImage:))]
        #[unsafe(method_family = none)]
        pub fn setOffStateImage(&self, off_state_image: Option<&NSImage>);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(mixedStateImage))]
        #[unsafe(method_family = none)]
        pub fn mixedStateImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`mixedStateImage`][Self::mixedStateImage].
        ///
        /// # Safety
        ///
        /// `mixed_state_image` might not allow `None`.
        #[unsafe(method(setMixedStateImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMixedStateImage(&self, mixed_state_image: Option<&NSImage>);

        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setEnabled(&self, enabled: bool);

        #[unsafe(method(isAlternate))]
        #[unsafe(method_family = none)]
        pub fn isAlternate(&self) -> bool;

        /// Setter for [`isAlternate`][Self::isAlternate].
        #[unsafe(method(setAlternate:))]
        #[unsafe(method_family = none)]
        pub fn setAlternate(&self, alternate: bool);

        #[unsafe(method(indentationLevel))]
        #[unsafe(method_family = none)]
        pub fn indentationLevel(&self) -> NSInteger;

        /// Setter for [`indentationLevel`][Self::indentationLevel].
        #[unsafe(method(setIndentationLevel:))]
        #[unsafe(method_family = none)]
        pub fn setIndentationLevel(&self, indentation_level: NSInteger);

        #[unsafe(method(target))]
        #[unsafe(method_family = none)]
        pub fn target(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`target`][Self::target].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `target` should be of the correct type.
        #[unsafe(method(setTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTarget(&self, target: Option<&AnyObject>);

        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub fn action(&self) -> Option<Sel>;

        /// Setter for [`action`][Self::action].
        ///
        /// # Safety
        ///
        /// `action` must be a valid selector.
        #[unsafe(method(setAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAction(&self, action: Option<Sel>);

        #[unsafe(method(tag))]
        #[unsafe(method_family = none)]
        pub fn tag(&self) -> NSInteger;

        /// Setter for [`tag`][Self::tag].
        #[unsafe(method(setTag:))]
        #[unsafe(method_family = none)]
        pub fn setTag(&self, tag: NSInteger);

        #[unsafe(method(representedObject))]
        #[unsafe(method_family = none)]
        pub fn representedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`representedObject`][Self::representedObject].
        ///
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[unsafe(method(setRepresentedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRepresentedObject(&self, represented_object: Option<&AnyObject>);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(view))]
        #[unsafe(method_family = none)]
        pub fn view(&self) -> Option<Retained<NSView>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// Setter for [`view`][Self::view].
        #[unsafe(method(setView:))]
        #[unsafe(method_family = none)]
        pub fn setView(&self, view: Option<&NSView>);

        #[unsafe(method(isHighlighted))]
        #[unsafe(method_family = none)]
        pub fn isHighlighted(&self) -> bool;

        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub fn setHidden(&self, hidden: bool);

        #[unsafe(method(isHiddenOrHasHiddenAncestor))]
        #[unsafe(method_family = none)]
        pub fn isHiddenOrHasHiddenAncestor(&self) -> bool;

        #[unsafe(method(toolTip))]
        #[unsafe(method_family = none)]
        pub fn toolTip(&self) -> Option<Retained<NSString>>;

        /// Setter for [`toolTip`][Self::toolTip].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setToolTip:))]
        #[unsafe(method_family = none)]
        pub fn setToolTip(&self, tool_tip: Option<&NSString>);

        #[cfg(feature = "NSMenuItemBadge")]
        /// A badge used to provide additional quantitative information specific to
        /// the menu item, such as the number of available updates.
        ///
        ///
        /// Note: The default value of this property is
        /// `nil.`
        #[unsafe(method(badge))]
        #[unsafe(method_family = none)]
        pub fn badge(&self) -> Option<Retained<NSMenuItemBadge>>;

        #[cfg(feature = "NSMenuItemBadge")]
        /// Setter for [`badge`][Self::badge].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBadge:))]
        #[unsafe(method_family = none)]
        pub fn setBadge(&self, badge: Option<&NSMenuItemBadge>);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSMenuItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSViewEnclosingMenuItem.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSView {
    extern_methods!(
        #[unsafe(method(enclosingMenuItem))]
        #[unsafe(method_family = none)]
        pub fn enclosingMenuItem(&self) -> Option<Retained<NSMenuItem>>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmenuitemimportfromdeviceidentifier?language=objc)
    #[cfg(feature = "NSUserInterfaceItemIdentification")]
    pub static NSMenuItemImportFromDeviceIdentifier: &'static NSUserInterfaceItemIdentifier;
}

/// NSDeprecated.
impl NSMenuItem {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(setMnemonicLocation:))]
        #[unsafe(method_family = none)]
        pub fn setMnemonicLocation(&self, location: NSUInteger);

        #[deprecated]
        #[unsafe(method(mnemonicLocation))]
        #[unsafe(method_family = none)]
        pub fn mnemonicLocation(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(mnemonic))]
        #[unsafe(method_family = none)]
        pub fn mnemonic(&self) -> Option<Retained<NSString>>;

        #[deprecated]
        #[unsafe(method(setTitleWithMnemonic:))]
        #[unsafe(method_family = none)]
        pub fn setTitleWithMnemonic(&self, string_with_ampersand: &NSString);
    );
}
