/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobSchedule;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;

public class PostgreScheduleEditor
extends AbstractDatabaseObjectEditor<PostgreJobSchedule> {
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final boolean[] minutes = new boolean[60];
    private final boolean[] hours = new boolean[24];
    private final boolean[] weekDays = new boolean[7];
    private final boolean[] monthDays = new boolean[32];
    private final boolean[] months = new boolean[12];
    private PageControl pageControl;
    private boolean loaded;

    public void createPartControl(Composite parent) {
        this.pageControl = new PageControl(parent);
        Composite composite = new Composite((Composite)this.pageControl, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite category = new Composite(composite, 0);
        category.setLayoutData((Object)new GridData(4, 1, false, false));
        category.setLayout((Layout)new GridLayout(1, false));
        final Calendar calendar = Calendar.getInstance();
        this.listeners.add(PostgreScheduleEditor.createCheckboxPanel((Composite)UIUtils.createControlGroup((Composite)category, (String)"Week Days", (int)4, (int)768, (int)0), DayOfWeek.values(), new Decorator<DayOfWeek>(){

            @Override
            @NotNull
            public String getText(@NotNull DayOfWeek value) {
                return value.plus(calendar.getFirstDayOfWeek() - 2).getDisplayName(TextStyle.SHORT, Locale.getDefault());
            }

            @Override
            public boolean getChecked(@NotNull DayOfWeek value) {
                return PostgreScheduleEditor.this.weekDays[value.ordinal()];
            }

            @Override
            public void setChecked(@NotNull DayOfWeek value, boolean checked) {
                PostgreScheduleEditor.this.weekDays[value.ordinal()] = checked;
                PostgreScheduleEditor.this.addScheduleChange();
            }
        }));
        this.listeners.add(PostgreScheduleEditor.createCheckboxPanel((Composite)UIUtils.createControlGroup((Composite)category, (String)"Month Days", (int)4, (int)768, (int)0), (Integer[])IntStream.range(1, 33).boxed().toArray(Integer[]::new), new Decorator<Integer>(){

            @Override
            @NotNull
            public String getText(@NotNull Integer value) {
                return value == 32 ? "<Last>" : PostgreScheduleEditor.nth(value.toString(), value);
            }

            @Override
            public boolean getChecked(@NotNull Integer value) {
                return PostgreScheduleEditor.this.monthDays[value - 1];
            }

            @Override
            public void setChecked(@NotNull Integer value, boolean checked) {
                PostgreScheduleEditor.this.monthDays[value.intValue() - 1] = checked;
                PostgreScheduleEditor.this.addScheduleChange();
                PostgreScheduleEditor.this.refreshSchedulePresentation();
            }

            @Override
            public boolean getEnabled(@NotNull Integer value) {
                if (value > 31) {
                    return true;
                }
                int i = 0;
                while (i < PostgreScheduleEditor.this.months.length) {
                    if (PostgreScheduleEditor.this.months[i] && Month.of(i + 1).minLength() < value) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }));
        this.listeners.add(PostgreScheduleEditor.createCheckboxPanel((Composite)UIUtils.createControlGroup((Composite)category, (String)"Months", (int)4, (int)768, (int)0), Month.values(), new Decorator<Month>(){

            @Override
            @NotNull
            public String getText(@NotNull Month value) {
                return value.getDisplayName(TextStyle.SHORT, Locale.getDefault());
            }

            @Override
            public boolean getChecked(@NotNull Month value) {
                return PostgreScheduleEditor.this.months[value.ordinal()];
            }

            @Override
            public void setChecked(@NotNull Month value, boolean checked) {
                PostgreScheduleEditor.this.months[value.ordinal()] = checked;
                PostgreScheduleEditor.this.addScheduleChange();
                PostgreScheduleEditor.this.refreshSchedulePresentation();
            }

            @Override
            public boolean getEnabled(@NotNull Month month) {
                int i = month.minLength();
                while (i < 31) {
                    if (PostgreScheduleEditor.this.monthDays[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }));
        category = new Composite(composite, 0);
        category.setLayout((Layout)new GridLayout(1, false));
        category.setLayoutData((Object)new GridData(1, 1, false, false));
        this.listeners.add(PostgreScheduleEditor.createCheckboxPanel((Composite)UIUtils.createControlGroup((Composite)category, (String)"Hours", (int)6, (int)768, (int)0), (Integer[])IntStream.range(0, 24).boxed().toArray(Integer[]::new), new Decorator<Integer>(){

            @Override
            @NotNull
            public String getText(@NotNull Integer value) {
                return value.toString();
            }

            @Override
            public boolean getChecked(@NotNull Integer value) {
                return PostgreScheduleEditor.this.hours[value];
            }

            @Override
            public void setChecked(@NotNull Integer value, boolean checked) {
                PostgreScheduleEditor.this.hours[value.intValue()] = checked;
                PostgreScheduleEditor.this.addScheduleChange();
            }
        }));
        this.listeners.add(PostgreScheduleEditor.createCheckboxPanel((Composite)UIUtils.createControlGroup((Composite)category, (String)"Minutes", (int)6, (int)768, (int)0), (Integer[])IntStream.range(0, 60).boxed().toArray(Integer[]::new), new Decorator<Integer>(){

            @Override
            @NotNull
            public String getText(@NotNull Integer value) {
                return value.toString();
            }

            @Override
            public boolean getChecked(@NotNull Integer value) {
                return PostgreScheduleEditor.this.minutes[value];
            }

            @Override
            public void setChecked(@NotNull Integer value, boolean checked) {
                PostgreScheduleEditor.this.minutes[value.intValue()] = checked;
                PostgreScheduleEditor.this.addScheduleChange();
            }
        }));
        this.pageControl.createOrSubstituteProgressPanel(this.getSite());
    }

    public void activatePart() {
        if (this.loaded) {
            return;
        }
        PostgreJobSchedule schedule = (PostgreJobSchedule)this.getDatabaseObject();
        System.arraycopy(schedule.getMinutes(), 0, this.minutes, 0, this.minutes.length);
        System.arraycopy(schedule.getHours(), 0, this.hours, 0, this.hours.length);
        System.arraycopy(schedule.getWeekDays(), 0, this.weekDays, 0, this.weekDays.length);
        System.arraycopy(schedule.getMonthDays(), 0, this.monthDays, 0, this.monthDays.length);
        System.arraycopy(schedule.getMonths(), 0, this.months, 0, this.months.length);
        this.refreshSchedulePresentation();
        this.loaded = true;
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (force || !this.loaded || source instanceof DBNEvent && ((DBNEvent)source).getSource() == DBNEvent.UPDATE_ON_SAVE) {
            this.loaded = false;
            this.activatePart();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    public void setFocus() {
        if (this.pageControl != null) {
            this.pageControl.activate(true);
        }
    }

    private void refreshSchedulePresentation() {
        this.listeners.forEach(Runnable::run);
    }

    private void addScheduleChange() {
        this.addChangeCommand((DBECommand)new UpdateCommand((PostgreJobSchedule)this.getDatabaseObject()), (DBECommandReflector)new DBECommandReflector<PostgreJobSchedule, DBECommand<PostgreJobSchedule>>(){

            public void redoCommand(@NotNull DBECommand<PostgreJobSchedule> command) {
            }

            public void undoCommand(@NotNull DBECommand<PostgreJobSchedule> command) {
            }
        });
    }

    @NotNull
    private static <T> Runnable createCheckboxPanel(@NotNull Composite parent, @NotNull T[] input, final @NotNull Decorator<T> decorator) {
        int cols = ((GridLayout)parent.getLayout()).numColumns;
        int rows = (int)Math.ceil((float)input.length / (float)cols);
        Button[] buttons = new Button[input.length];
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                Object data = button.getData();
                decorator.setChecked(data, button.getSelection());
            }
        };
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int index = i + j * rows;
                if (index < input.length) {
                    T value = input[index];
                    Button button = new Button(parent, 32);
                    button.setText(decorator.getText(value));
                    button.setData(value);
                    button.addSelectionListener((SelectionListener)listener);
                    buttons[index] = button;
                } else {
                    UIUtils.createPlaceholder((Composite)parent, (int)1);
                }
                ++j;
            }
            ++i;
        }
        return () -> {
            Button[] buttonArray2 = buttons;
            int n = buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray2[n2];
                Object data = button.getData();
                button.setText(decorator.getText(data));
                button.setSelection(decorator.getChecked(data));
                button.setEnabled(decorator.getEnabled(data));
                ++n2;
            }
        };
    }

    @NotNull
    private static String nth(@NotNull String name, int number) {
        if (number <= 3 || number >= 21) {
            switch (number % 10) {
                case 1: {
                    return name + "st";
                }
                case 2: {
                    return name + "nd";
                }
                case 3: {
                    return name + "rd";
                }
            }
        }
        return name + "th";
    }

    private static interface Decorator<T> {
        @NotNull
        public String getText(@NotNull T var1);

        public boolean getChecked(@NotNull T var1);

        public void setChecked(@NotNull T var1, boolean var2);

        default public boolean getEnabled(@NotNull T t) {
            return true;
        }
    }

    private class PageControl
    extends ProgressPageControl {
        public PageControl(Composite parent) {
            super(parent, 0x10000000);
        }

        public void fillCustomActions(@NotNull IContributionManager manager) {
            super.fillCustomActions(manager);
            IWorkbenchPartSite site = PostgreScheduleEditor.this.getSite();
            if (site != null) {
                manager.add((IContributionItem)new Separator());
                DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)site, (IContributionManager)manager);
            }
        }
    }

    private class UpdateCommand
    extends DBECommandAbstract<PostgreJobSchedule> {
        public UpdateCommand(PostgreJobSchedule object) {
            super((DBPObject)object, "Update schedule");
        }

        @NotNull
        public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) {
            PostgreJobSchedule schedule = (PostgreJobSchedule)this.getObject();
            StringJoiner changes = new StringJoiner(",\n\t");
            if (!Arrays.equals(PostgreScheduleEditor.this.minutes, schedule.getMinutes())) {
                changes.add("jscminutes=" + this.toCompactArray(PostgreScheduleEditor.this.minutes));
            }
            if (!Arrays.equals(PostgreScheduleEditor.this.hours, schedule.getHours())) {
                changes.add("jschours=" + this.toCompactArray(PostgreScheduleEditor.this.hours));
            }
            if (!Arrays.equals(PostgreScheduleEditor.this.weekDays, schedule.getWeekDays())) {
                changes.add("jscweekdays=" + this.toCompactArray(PostgreScheduleEditor.this.weekDays));
            }
            if (!Arrays.equals(PostgreScheduleEditor.this.monthDays, schedule.getMonthDays())) {
                changes.add("jscmonthdays=" + this.toCompactArray(PostgreScheduleEditor.this.monthDays));
            }
            if (!Arrays.equals(PostgreScheduleEditor.this.months, schedule.getMonths())) {
                changes.add("jscmonths=" + this.toCompactArray(PostgreScheduleEditor.this.months));
            }
            if (changes.length() == 0) {
                return new DBEPersistAction[0];
            }
            return new DBEPersistAction[]{new SQLDatabasePersistActionComment((DBPDataSource)schedule.getDataSource(), "Update schedule '" + schedule.getName() + "'"), new SQLDatabasePersistAction("Update schedule", "UPDATE pgagent.pga_schedule\nSET\n\t" + String.valueOf(changes) + "\nWHERE jscid=" + schedule.getObjectId())};
        }

        @NotNull
        public DBECommand<?> merge(@NotNull DBECommand<?> prevCommand, @NotNull Map<Object, Object> userParams) {
            String name = "schedule#" + ((PostgreJobSchedule)this.getObject()).getObjectId();
            if (userParams.putIfAbsent(name, (Object)this) == null) {
                return this;
            }
            return (DBECommand)userParams.get(name);
        }

        @NotNull
        private String toCompactArray(@NotNull boolean[] values) {
            StringJoiner joiner = new StringJoiner(",", "'{", "}'");
            boolean[] blArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                boolean value = blArray[n2];
                joiner.add(value ? "t" : "f");
                ++n2;
            }
            return joiner.toString();
        }
    }
}

