// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketOwnershipControls`](crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`GetBucketOwnershipControlsOutput`](crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsOutput) with field(s):
    ///   - [`ownership_controls(Option<OwnershipControls>)`](crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsOutput::ownership_controls): <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) currently in effect for this Amazon S3 bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketOwnershipControlsError>`](crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsError)
    pub fn get_bucket_ownership_controls(
        &self,
    ) -> crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder {
        crate::operation::get_bucket_ownership_controls::builders::GetBucketOwnershipControlsFluentBuilder::new(self.handle.clone())
    }
}
