// <copyright file="SetScreenOrientationOverrideCommand.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

using OpenQA.Selenium.BiDi.Json.Converters;
using System.Collections.Generic;
using System.Text.Json.Serialization;

namespace OpenQA.Selenium.BiDi.Emulation;

internal sealed class SetScreenOrientationOverrideCommand(SetScreenOrientationOverrideParameters @params)
    : Command<SetScreenOrientationOverrideParameters, SetScreenOrientationOverrideResult>(@params, "emulation.setScreenOrientationOverride");

internal sealed record SetScreenOrientationOverrideParameters([property: JsonIgnore(Condition = JsonIgnoreCondition.Never)] ScreenOrientation? ScreenOrientation, IEnumerable<BrowsingContext.BrowsingContext>? Contexts, IEnumerable<Browser.UserContext>? UserContexts) : Parameters;

public sealed class SetScreenOrientationOverrideOptions : CommandOptions
{
    public IEnumerable<BrowsingContext.BrowsingContext>? Contexts { get; set; }

    public IEnumerable<Browser.UserContext>? UserContexts { get; set; }
}

[JsonConverter(typeof(CamelCaseEnumConverter<ScreenOrientationNatural>))]
public enum ScreenOrientationNatural
{
    Portrait,
    Landscape
}

[JsonConverter(typeof(KebabCaseEnumConverter<ScreenOrientationType>))]
public enum ScreenOrientationType
{
    PortraitPrimary,
    PortraitSecondary,
    LandscapePrimary,
    LandscapeSecondary
}

public sealed record ScreenOrientation(ScreenOrientationNatural Natural, ScreenOrientationType Type);

public sealed record SetScreenOrientationOverrideResult : EmptyResult;
