/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.api.util.SleepTimer;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;

final class SignalWebSocketHealthMonitor
implements HealthMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SignalWebSocketHealthMonitor.class);
    private static final long KEEP_ALIVE_SEND_CADENCE = TimeUnit.SECONDS.toMillis(30L);
    private static final long KEEP_ALIVE_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final SleepTimer sleepTimer;
    private SignalWebSocket webSocket = null;
    private volatile KeepAliveSender keepAliveSender = null;
    private boolean needsKeepAlive = false;
    private long lastKeepAliveReceived = 0L;

    public SignalWebSocketHealthMonitor(SleepTimer sleepTimer) {
        this.sleepTimer = sleepTimer;
    }

    void monitor(SignalWebSocket webSocket) {
        Preconditions.checkNotNull((Object)webSocket);
        Preconditions.checkArgument((this.webSocket == null ? 1 : 0) != 0, (String)"monitor can only be called once");
        this.executor.execute(() -> {
            this.webSocket = webSocket;
            webSocket.getState().subscribeOn(Schedulers.computation()).observeOn(Schedulers.computation()).distinctUntilChanged().subscribe(this::onStateChanged);
            webSocket.addKeepAliveChangeListener(() -> {
                this.executor.execute(this::updateKeepAliveSenderStatus);
                return Unit.INSTANCE;
            });
        });
    }

    private void onStateChanged(WebSocketConnectionState connectionState) {
        this.executor.execute(() -> {
            this.needsKeepAlive = connectionState == WebSocketConnectionState.CONNECTED;
            this.updateKeepAliveSenderStatus();
        });
    }

    public void onKeepAliveResponse(long sentTimestamp, boolean isIdentifiedWebSocket) {
        long keepAliveTime = System.currentTimeMillis();
        this.executor.execute(() -> {
            this.lastKeepAliveReceived = keepAliveTime;
        });
    }

    public void onMessageError(int status, boolean isIdentifiedWebSocket) {
    }

    private void updateKeepAliveSenderStatus() {
        if (this.keepAliveSender == null && this.sendKeepAlives()) {
            this.keepAliveSender = new KeepAliveSender();
            this.keepAliveSender.start();
        } else if (this.keepAliveSender != null && !this.sendKeepAlives()) {
            this.keepAliveSender.shutdown();
            this.keepAliveSender = null;
        }
    }

    private boolean sendKeepAlives() {
        return this.needsKeepAlive && this.webSocket != null && this.webSocket.shouldSendKeepAlives();
    }

    private final class KeepAliveSender
    extends Thread {
        private volatile boolean shouldKeepRunning = true;

        private KeepAliveSender() {
        }

        @Override
        public void run() {
            logger.debug("[KeepAliveSender({})] started", (Object)this.threadId());
            SignalWebSocketHealthMonitor.this.lastKeepAliveReceived = System.currentTimeMillis();
            long keepAliveSendTime = System.currentTimeMillis();
            while (this.shouldKeepRunning && SignalWebSocketHealthMonitor.this.sendKeepAlives()) {
                try {
                    long nextKeepAliveSendTime = keepAliveSendTime + KEEP_ALIVE_SEND_CADENCE;
                    this.sleepUntil(nextKeepAliveSendTime);
                    if (this.shouldKeepRunning && SignalWebSocketHealthMonitor.this.sendKeepAlives()) {
                        keepAliveSendTime = System.currentTimeMillis();
                        SignalWebSocketHealthMonitor.this.webSocket.sendKeepAlive();
                    }
                    long responseRequiredTime = keepAliveSendTime + KEEP_ALIVE_TIMEOUT;
                    this.sleepUntil(responseRequiredTime);
                    if (!this.shouldKeepRunning || !SignalWebSocketHealthMonitor.this.sendKeepAlives() || SignalWebSocketHealthMonitor.this.lastKeepAliveReceived >= keepAliveSendTime) continue;
                    logger.debug("Missed keep alive, last: {} needed by: {}", (Object)SignalWebSocketHealthMonitor.this.lastKeepAliveReceived, (Object)responseRequiredTime);
                    SignalWebSocketHealthMonitor.this.webSocket.forceNewWebSocket();
                }
                catch (Throwable e) {
                    logger.warn("Keep alive sender failed", e);
                }
            }
            logger.debug("[KeepAliveSender({})] ended", (Object)this.threadId());
        }

        void sleepUntil(long timeMillis) {
            while (System.currentTimeMillis() < timeMillis) {
                long waitTime = timeMillis - System.currentTimeMillis();
                if (waitTime <= 0L) continue;
                try {
                    SignalWebSocketHealthMonitor.this.sleepTimer.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    logger.warn("WebSocket health monitor interrupted", (Throwable)e);
                }
            }
        }

        void shutdown() {
            this.shouldKeepRunning = false;
        }
    }
}

