/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.util.UUID;
import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.groups.GroupCipher;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.whispersystems.signalservice.api.SignalSessionLock;

public class SignalGroupCipher {
    private final SignalSessionLock lock;
    private final GroupCipher cipher;

    public SignalGroupCipher(SignalSessionLock lock, GroupCipher cipher) {
        this.lock = lock;
        this.cipher = cipher;
    }

    public CiphertextMessage encrypt(UUID distributionId, byte[] paddedPlaintext) throws NoSessionException {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            CiphertextMessage ciphertextMessage = this.cipher.encrypt(distributionId, paddedPlaintext);
            return ciphertextMessage;
        }
    }

    public byte[] decrypt(byte[] senderKeyMessageBytes) throws LegacyMessageException, DuplicateMessageException, InvalidMessageException, NoSessionException {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            byte[] byArray = this.cipher.decrypt(senderKeyMessageBytes);
            return byArray;
        }
    }
}

