/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.table;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import sun.jvm.hotspot.ui.table.SortableTableModel;

public class SortHeaderCellRenderer
extends DefaultTableCellRenderer {
    private Icon descendingIcon;
    private Icon ascendingIcon;
    private SortableTableModel model;

    public SortHeaderCellRenderer(JTableHeader header, SortableTableModel model) {
        this.model = model;
        this.descendingIcon = this.getIcon("navigation/Down16.gif");
        this.ascendingIcon = this.getIcon("navigation/Up16.gif");
        this.setForeground(header.getForeground());
        this.setBackground(header.getBackground());
        this.setFont(header.getFont());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
    }

    public ImageIcon getIcon(String name) {
        String imagePath = "/toolbarButtonGraphics/" + name;
        URL url = this.getClass().getResource(imagePath);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        Icon icon = null;
        if (column == this.model.getColumn()) {
            icon = this.model.isAscending() ? this.ascendingIcon : this.descendingIcon;
        }
        this.setIcon(icon);
        return this;
    }
}

