/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.service;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.OpenHAB;
import org.openhab.core.service.WatchServiceFactory;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={WatchServiceFactory.class})
public class WatchServiceFactoryImpl
implements WatchServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(WatchServiceFactoryImpl.class);
    private final ConfigurationAdmin cm;

    @Activate
    public WatchServiceFactoryImpl(@Reference ConfigurationAdmin cm) {
        this.cm = cm;
        this.clearConfigurationAdmin();
        this.createWatchService("configWatcher", Path.of(OpenHAB.getConfigFolder(), new String[0]));
    }

    @Deactivate
    public void deactivate() {
        this.clearConfigurationAdmin();
    }

    @Override
    public void createWatchService(String name, Path basePath) {
        try {
            String filter = "(&(name=" + name + ")(service.factoryPid=org.openhab.core.service.WatchService))";
            Configuration[] configurations = this.cm.listConfigurations(filter);
            if (configurations == null || configurations.length == 0) {
                Configuration config = this.cm.createFactoryConfiguration("org.openhab.core.service.WatchService", "?");
                Hashtable<String, String> map = new Hashtable<String, String>();
                ((Dictionary)map).put("name", name);
                ((Dictionary)map).put("path", basePath.toString());
                config.update(map);
            } else {
                Configuration config = configurations[0];
                Dictionary map = config.getProperties();
                map.put("name", name);
                map.put("path", basePath.toString());
                config.update(map);
            }
        }
        catch (IOException | InvalidSyntaxException e1) {
            this.logger.error("Failed to create configuration with name `{}' and path '{}'", (Object)name, (Object)basePath);
        }
    }

    @Override
    public void removeWatchService(String name) {
        try {
            String filter = "(&(name=" + name + ")(service.factoryPid=org.openhab.core.service.WatchService))";
            Configuration[] configurations = this.cm.listConfigurations(filter);
            if (configurations != null) {
                configurations[0].delete();
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            this.logger.error("Failed to remove configuration with name '{}", (Object)name);
        }
    }

    private void clearConfigurationAdmin() {
        block5: {
            try {
                String filter = "(service.factoryPid=org.openhab.core.service.WatchService)";
                Configuration[] configurations = this.cm.listConfigurations(filter);
                if (configurations == null) break block5;
                Configuration[] configurationArray = configurations;
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    Configuration configuration = configurationArray[n2];
                    try {
                        configuration.delete();
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to remove configuration with name '{}", configuration.getProperties().get("name"));
                    }
                    ++n2;
                }
            }
            catch (IOException | InvalidSyntaxException e) {
                this.logger.error("Failed to remove services.");
            }
        }
    }
}

