/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.netty4;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.netty4.NettyMeters;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.SingleThreadEventExecutor;

public class NettyEventExecutorMetrics
implements MeterBinder {
    private final Iterable<EventExecutor> eventExecutors;
    private final Iterable<Tag> tags;

    public NettyEventExecutorMetrics(Iterable<EventExecutor> eventExecutors) {
        this(eventExecutors, Tags.empty());
    }

    public NettyEventExecutorMetrics(Iterable<EventExecutor> eventExecutors, Iterable<Tag> tags) {
        this.eventExecutors = eventExecutors;
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(NettyMeters.EVENT_EXECUTOR_WORKERS.getName(), this.eventExecutors, NettyEventExecutorMetrics::getExecutorCount).description("Number of event executor workers").tags(this.tags).register(registry);
        this.eventExecutors.forEach(eventExecutor -> {
            if (eventExecutor instanceof SingleThreadEventExecutor) {
                SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)eventExecutor;
                Gauge.builder(NettyMeters.EVENT_EXECUTOR_TASKS_PENDING.getName(), singleThreadEventExecutor, SingleThreadEventExecutor::pendingTasks).tag(NettyMeters.EventExecutorTasksPendingKeyNames.NAME.asString(), singleThreadEventExecutor.threadProperties().name()).tags(this.tags).register(registry);
            }
        });
    }

    private static double getExecutorCount(Iterable<EventExecutor> executors) {
        if (executors instanceof MultithreadEventLoopGroup) {
            return ((MultithreadEventLoopGroup)executors).executorCount();
        }
        int count = 0;
        for (EventExecutor ignored : executors) {
            ++count;
        }
        return count;
    }
}

