//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// InterfacesServer is a fake server for instances of the armnetwork.InterfacesClient type.
type InterfacesServer struct {
	// BeginCreateOrUpdate is the fake for method InterfacesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, networkInterfaceName string, parameters armnetwork.Interface, options *armnetwork.InterfacesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetwork.InterfacesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method InterfacesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, networkInterfaceName string, options *armnetwork.InterfacesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetwork.InterfacesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InterfacesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, networkInterfaceName string, options *armnetwork.InterfacesClientGetOptions) (resp azfake.Responder[armnetwork.InterfacesClientGetResponse], errResp azfake.ErrorResponder)

	// GetCloudServiceNetworkInterface is the fake for method InterfacesClient.GetCloudServiceNetworkInterface
	// HTTP status codes to indicate success: http.StatusOK
	GetCloudServiceNetworkInterface func(ctx context.Context, resourceGroupName string, cloudServiceName string, roleInstanceName string, networkInterfaceName string, options *armnetwork.InterfacesClientGetCloudServiceNetworkInterfaceOptions) (resp azfake.Responder[armnetwork.InterfacesClientGetCloudServiceNetworkInterfaceResponse], errResp azfake.ErrorResponder)

	// BeginGetEffectiveRouteTable is the fake for method InterfacesClient.BeginGetEffectiveRouteTable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetEffectiveRouteTable func(ctx context.Context, resourceGroupName string, networkInterfaceName string, options *armnetwork.InterfacesClientBeginGetEffectiveRouteTableOptions) (resp azfake.PollerResponder[armnetwork.InterfacesClientGetEffectiveRouteTableResponse], errResp azfake.ErrorResponder)

	// GetVirtualMachineScaleSetIPConfiguration is the fake for method InterfacesClient.GetVirtualMachineScaleSetIPConfiguration
	// HTTP status codes to indicate success: http.StatusOK
	GetVirtualMachineScaleSetIPConfiguration func(ctx context.Context, resourceGroupName string, virtualMachineScaleSetName string, virtualmachineIndex string, networkInterfaceName string, ipConfigurationName string, options *armnetwork.InterfacesClientGetVirtualMachineScaleSetIPConfigurationOptions) (resp azfake.Responder[armnetwork.InterfacesClientGetVirtualMachineScaleSetIPConfigurationResponse], errResp azfake.ErrorResponder)

	// GetVirtualMachineScaleSetNetworkInterface is the fake for method InterfacesClient.GetVirtualMachineScaleSetNetworkInterface
	// HTTP status codes to indicate success: http.StatusOK
	GetVirtualMachineScaleSetNetworkInterface func(ctx context.Context, resourceGroupName string, virtualMachineScaleSetName string, virtualmachineIndex string, networkInterfaceName string, options *armnetwork.InterfacesClientGetVirtualMachineScaleSetNetworkInterfaceOptions) (resp azfake.Responder[armnetwork.InterfacesClientGetVirtualMachineScaleSetNetworkInterfaceResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method InterfacesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armnetwork.InterfacesClientListOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListResponse])

	// NewListAllPager is the fake for method InterfacesClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(options *armnetwork.InterfacesClientListAllOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListAllResponse])

	// NewListCloudServiceNetworkInterfacesPager is the fake for method InterfacesClient.NewListCloudServiceNetworkInterfacesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCloudServiceNetworkInterfacesPager func(resourceGroupName string, cloudServiceName string, options *armnetwork.InterfacesClientListCloudServiceNetworkInterfacesOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListCloudServiceNetworkInterfacesResponse])

	// NewListCloudServiceRoleInstanceNetworkInterfacesPager is the fake for method InterfacesClient.NewListCloudServiceRoleInstanceNetworkInterfacesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCloudServiceRoleInstanceNetworkInterfacesPager func(resourceGroupName string, cloudServiceName string, roleInstanceName string, options *armnetwork.InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesResponse])

	// BeginListEffectiveNetworkSecurityGroups is the fake for method InterfacesClient.BeginListEffectiveNetworkSecurityGroups
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListEffectiveNetworkSecurityGroups func(ctx context.Context, resourceGroupName string, networkInterfaceName string, options *armnetwork.InterfacesClientBeginListEffectiveNetworkSecurityGroupsOptions) (resp azfake.PollerResponder[armnetwork.InterfacesClientListEffectiveNetworkSecurityGroupsResponse], errResp azfake.ErrorResponder)

	// NewListVirtualMachineScaleSetIPConfigurationsPager is the fake for method InterfacesClient.NewListVirtualMachineScaleSetIPConfigurationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVirtualMachineScaleSetIPConfigurationsPager func(resourceGroupName string, virtualMachineScaleSetName string, virtualmachineIndex string, networkInterfaceName string, options *armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsResponse])

	// NewListVirtualMachineScaleSetNetworkInterfacesPager is the fake for method InterfacesClient.NewListVirtualMachineScaleSetNetworkInterfacesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVirtualMachineScaleSetNetworkInterfacesPager func(resourceGroupName string, virtualMachineScaleSetName string, options *armnetwork.InterfacesClientListVirtualMachineScaleSetNetworkInterfacesOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetNetworkInterfacesResponse])

	// NewListVirtualMachineScaleSetVMNetworkInterfacesPager is the fake for method InterfacesClient.NewListVirtualMachineScaleSetVMNetworkInterfacesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVirtualMachineScaleSetVMNetworkInterfacesPager func(resourceGroupName string, virtualMachineScaleSetName string, virtualmachineIndex string, options *armnetwork.InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesOptions) (resp azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesResponse])

	// UpdateTags is the fake for method InterfacesClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, networkInterfaceName string, parameters armnetwork.TagsObject, options *armnetwork.InterfacesClientUpdateTagsOptions) (resp azfake.Responder[armnetwork.InterfacesClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewInterfacesServerTransport creates a new instance of InterfacesServerTransport with the provided implementation.
// The returned InterfacesServerTransport instance is connected to an instance of armnetwork.InterfacesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInterfacesServerTransport(srv *InterfacesServer) *InterfacesServerTransport {
	return &InterfacesServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armnetwork.InterfacesClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armnetwork.InterfacesClientDeleteResponse]](),
		beginGetEffectiveRouteTable: newTracker[azfake.PollerResponder[armnetwork.InterfacesClientGetEffectiveRouteTableResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListResponse]](),
		newListAllPager:             newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListAllResponse]](),
		newListCloudServiceNetworkInterfacesPager:             newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListCloudServiceNetworkInterfacesResponse]](),
		newListCloudServiceRoleInstanceNetworkInterfacesPager: newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesResponse]](),
		beginListEffectiveNetworkSecurityGroups:               newTracker[azfake.PollerResponder[armnetwork.InterfacesClientListEffectiveNetworkSecurityGroupsResponse]](),
		newListVirtualMachineScaleSetIPConfigurationsPager:    newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsResponse]](),
		newListVirtualMachineScaleSetNetworkInterfacesPager:   newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetNetworkInterfacesResponse]](),
		newListVirtualMachineScaleSetVMNetworkInterfacesPager: newTracker[azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesResponse]](),
	}
}

// InterfacesServerTransport connects instances of armnetwork.InterfacesClient to instances of InterfacesServer.
// Don't use this type directly, use NewInterfacesServerTransport instead.
type InterfacesServerTransport struct {
	srv                                                   *InterfacesServer
	beginCreateOrUpdate                                   *tracker[azfake.PollerResponder[armnetwork.InterfacesClientCreateOrUpdateResponse]]
	beginDelete                                           *tracker[azfake.PollerResponder[armnetwork.InterfacesClientDeleteResponse]]
	beginGetEffectiveRouteTable                           *tracker[azfake.PollerResponder[armnetwork.InterfacesClientGetEffectiveRouteTableResponse]]
	newListPager                                          *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListResponse]]
	newListAllPager                                       *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListAllResponse]]
	newListCloudServiceNetworkInterfacesPager             *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListCloudServiceNetworkInterfacesResponse]]
	newListCloudServiceRoleInstanceNetworkInterfacesPager *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesResponse]]
	beginListEffectiveNetworkSecurityGroups               *tracker[azfake.PollerResponder[armnetwork.InterfacesClientListEffectiveNetworkSecurityGroupsResponse]]
	newListVirtualMachineScaleSetIPConfigurationsPager    *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsResponse]]
	newListVirtualMachineScaleSetNetworkInterfacesPager   *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetNetworkInterfacesResponse]]
	newListVirtualMachineScaleSetVMNetworkInterfacesPager *tracker[azfake.PagerResponder[armnetwork.InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesResponse]]
}

// Do implements the policy.Transporter interface for InterfacesServerTransport.
func (i *InterfacesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InterfacesClient.BeginCreateOrUpdate":
		resp, err = i.dispatchBeginCreateOrUpdate(req)
	case "InterfacesClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "InterfacesClient.Get":
		resp, err = i.dispatchGet(req)
	case "InterfacesClient.GetCloudServiceNetworkInterface":
		resp, err = i.dispatchGetCloudServiceNetworkInterface(req)
	case "InterfacesClient.BeginGetEffectiveRouteTable":
		resp, err = i.dispatchBeginGetEffectiveRouteTable(req)
	case "InterfacesClient.GetVirtualMachineScaleSetIPConfiguration":
		resp, err = i.dispatchGetVirtualMachineScaleSetIPConfiguration(req)
	case "InterfacesClient.GetVirtualMachineScaleSetNetworkInterface":
		resp, err = i.dispatchGetVirtualMachineScaleSetNetworkInterface(req)
	case "InterfacesClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	case "InterfacesClient.NewListAllPager":
		resp, err = i.dispatchNewListAllPager(req)
	case "InterfacesClient.NewListCloudServiceNetworkInterfacesPager":
		resp, err = i.dispatchNewListCloudServiceNetworkInterfacesPager(req)
	case "InterfacesClient.NewListCloudServiceRoleInstanceNetworkInterfacesPager":
		resp, err = i.dispatchNewListCloudServiceRoleInstanceNetworkInterfacesPager(req)
	case "InterfacesClient.BeginListEffectiveNetworkSecurityGroups":
		resp, err = i.dispatchBeginListEffectiveNetworkSecurityGroups(req)
	case "InterfacesClient.NewListVirtualMachineScaleSetIPConfigurationsPager":
		resp, err = i.dispatchNewListVirtualMachineScaleSetIPConfigurationsPager(req)
	case "InterfacesClient.NewListVirtualMachineScaleSetNetworkInterfacesPager":
		resp, err = i.dispatchNewListVirtualMachineScaleSetNetworkInterfacesPager(req)
	case "InterfacesClient.NewListVirtualMachineScaleSetVMNetworkInterfacesPager":
		resp, err = i.dispatchNewListVirtualMachineScaleSetVMNetworkInterfacesPager(req)
	case "InterfacesClient.UpdateTags":
		resp, err = i.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InterfacesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := i.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.Interface](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, networkInterfaceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		i.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		i.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		i.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (i *InterfacesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), resourceGroupNameParam, networkInterfaceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *InterfacesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.InterfacesClientGetOptions
	if expandParam != nil {
		options = &armnetwork.InterfacesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, networkInterfaceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchGetCloudServiceNetworkInterface(req *http.Request) (*http.Response, error) {
	if i.srv.GetCloudServiceNetworkInterface == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCloudServiceNetworkInterface not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/cloudServices/(?P<cloudServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/roleInstances/(?P<roleInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	cloudServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudServiceName")])
	if err != nil {
		return nil, err
	}
	roleInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleInstanceName")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.InterfacesClientGetCloudServiceNetworkInterfaceOptions
	if expandParam != nil {
		options = &armnetwork.InterfacesClientGetCloudServiceNetworkInterfaceOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := i.srv.GetCloudServiceNetworkInterface(req.Context(), resourceGroupNameParam, cloudServiceNameParam, roleInstanceNameParam, networkInterfaceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchBeginGetEffectiveRouteTable(req *http.Request) (*http.Response, error) {
	if i.srv.BeginGetEffectiveRouteTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetEffectiveRouteTable not implemented")}
	}
	beginGetEffectiveRouteTable := i.beginGetEffectiveRouteTable.get(req)
	if beginGetEffectiveRouteTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/effectiveRouteTable`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginGetEffectiveRouteTable(req.Context(), resourceGroupNameParam, networkInterfaceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetEffectiveRouteTable = &respr
		i.beginGetEffectiveRouteTable.add(req, beginGetEffectiveRouteTable)
	}

	resp, err := server.PollerResponderNext(beginGetEffectiveRouteTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginGetEffectiveRouteTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetEffectiveRouteTable) {
		i.beginGetEffectiveRouteTable.remove(req)
	}

	return resp, nil
}

func (i *InterfacesServerTransport) dispatchGetVirtualMachineScaleSetIPConfiguration(req *http.Request) (*http.Response, error) {
	if i.srv.GetVirtualMachineScaleSetIPConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVirtualMachineScaleSetIPConfiguration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualmachineIndex>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipConfigurations/(?P<ipConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
	if err != nil {
		return nil, err
	}
	virtualmachineIndexParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualmachineIndex")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	ipConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ipConfigurationName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.InterfacesClientGetVirtualMachineScaleSetIPConfigurationOptions
	if expandParam != nil {
		options = &armnetwork.InterfacesClientGetVirtualMachineScaleSetIPConfigurationOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := i.srv.GetVirtualMachineScaleSetIPConfiguration(req.Context(), resourceGroupNameParam, virtualMachineScaleSetNameParam, virtualmachineIndexParam, networkInterfaceNameParam, ipConfigurationNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InterfaceIPConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchGetVirtualMachineScaleSetNetworkInterface(req *http.Request) (*http.Response, error) {
	if i.srv.GetVirtualMachineScaleSetNetworkInterface == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVirtualMachineScaleSetNetworkInterface not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualmachineIndex>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
	if err != nil {
		return nil, err
	}
	virtualmachineIndexParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualmachineIndex")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.InterfacesClientGetVirtualMachineScaleSetNetworkInterfaceOptions
	if expandParam != nil {
		options = &armnetwork.InterfacesClientGetVirtualMachineScaleSetNetworkInterfaceOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := i.srv.GetVirtualMachineScaleSetNetworkInterface(req.Context(), resourceGroupNameParam, virtualMachineScaleSetNameParam, virtualmachineIndexParam, networkInterfaceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.InterfacesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := i.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := i.srv.NewListAllPager(nil)
		newListAllPager = &resp
		i.newListAllPager.add(req, newListAllPager)
		server.PagerResponderInjectNextLinks(newListAllPager, req, func(page *armnetwork.InterfacesClientListAllResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		i.newListAllPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListCloudServiceNetworkInterfacesPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListCloudServiceNetworkInterfacesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCloudServiceNetworkInterfacesPager not implemented")}
	}
	newListCloudServiceNetworkInterfacesPager := i.newListCloudServiceNetworkInterfacesPager.get(req)
	if newListCloudServiceNetworkInterfacesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/cloudServices/(?P<cloudServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cloudServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudServiceName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListCloudServiceNetworkInterfacesPager(resourceGroupNameParam, cloudServiceNameParam, nil)
		newListCloudServiceNetworkInterfacesPager = &resp
		i.newListCloudServiceNetworkInterfacesPager.add(req, newListCloudServiceNetworkInterfacesPager)
		server.PagerResponderInjectNextLinks(newListCloudServiceNetworkInterfacesPager, req, func(page *armnetwork.InterfacesClientListCloudServiceNetworkInterfacesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCloudServiceNetworkInterfacesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListCloudServiceNetworkInterfacesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCloudServiceNetworkInterfacesPager) {
		i.newListCloudServiceNetworkInterfacesPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListCloudServiceRoleInstanceNetworkInterfacesPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListCloudServiceRoleInstanceNetworkInterfacesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCloudServiceRoleInstanceNetworkInterfacesPager not implemented")}
	}
	newListCloudServiceRoleInstanceNetworkInterfacesPager := i.newListCloudServiceRoleInstanceNetworkInterfacesPager.get(req)
	if newListCloudServiceRoleInstanceNetworkInterfacesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/cloudServices/(?P<cloudServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/roleInstances/(?P<roleInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cloudServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudServiceName")])
		if err != nil {
			return nil, err
		}
		roleInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListCloudServiceRoleInstanceNetworkInterfacesPager(resourceGroupNameParam, cloudServiceNameParam, roleInstanceNameParam, nil)
		newListCloudServiceRoleInstanceNetworkInterfacesPager = &resp
		i.newListCloudServiceRoleInstanceNetworkInterfacesPager.add(req, newListCloudServiceRoleInstanceNetworkInterfacesPager)
		server.PagerResponderInjectNextLinks(newListCloudServiceRoleInstanceNetworkInterfacesPager, req, func(page *armnetwork.InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCloudServiceRoleInstanceNetworkInterfacesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListCloudServiceRoleInstanceNetworkInterfacesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCloudServiceRoleInstanceNetworkInterfacesPager) {
		i.newListCloudServiceRoleInstanceNetworkInterfacesPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchBeginListEffectiveNetworkSecurityGroups(req *http.Request) (*http.Response, error) {
	if i.srv.BeginListEffectiveNetworkSecurityGroups == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListEffectiveNetworkSecurityGroups not implemented")}
	}
	beginListEffectiveNetworkSecurityGroups := i.beginListEffectiveNetworkSecurityGroups.get(req)
	if beginListEffectiveNetworkSecurityGroups == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/effectiveNetworkSecurityGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginListEffectiveNetworkSecurityGroups(req.Context(), resourceGroupNameParam, networkInterfaceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListEffectiveNetworkSecurityGroups = &respr
		i.beginListEffectiveNetworkSecurityGroups.add(req, beginListEffectiveNetworkSecurityGroups)
	}

	resp, err := server.PollerResponderNext(beginListEffectiveNetworkSecurityGroups, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginListEffectiveNetworkSecurityGroups.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListEffectiveNetworkSecurityGroups) {
		i.beginListEffectiveNetworkSecurityGroups.remove(req)
	}

	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListVirtualMachineScaleSetIPConfigurationsPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListVirtualMachineScaleSetIPConfigurationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVirtualMachineScaleSetIPConfigurationsPager not implemented")}
	}
	newListVirtualMachineScaleSetIPConfigurationsPager := i.newListVirtualMachineScaleSetIPConfigurationsPager.get(req)
	if newListVirtualMachineScaleSetIPConfigurationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualmachineIndex>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
		if err != nil {
			return nil, err
		}
		virtualmachineIndexParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualmachineIndex")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsOptions
		if expandParam != nil {
			options = &armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsOptions{
				Expand: expandParam,
			}
		}
		resp := i.srv.NewListVirtualMachineScaleSetIPConfigurationsPager(resourceGroupNameParam, virtualMachineScaleSetNameParam, virtualmachineIndexParam, networkInterfaceNameParam, options)
		newListVirtualMachineScaleSetIPConfigurationsPager = &resp
		i.newListVirtualMachineScaleSetIPConfigurationsPager.add(req, newListVirtualMachineScaleSetIPConfigurationsPager)
		server.PagerResponderInjectNextLinks(newListVirtualMachineScaleSetIPConfigurationsPager, req, func(page *armnetwork.InterfacesClientListVirtualMachineScaleSetIPConfigurationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVirtualMachineScaleSetIPConfigurationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListVirtualMachineScaleSetIPConfigurationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVirtualMachineScaleSetIPConfigurationsPager) {
		i.newListVirtualMachineScaleSetIPConfigurationsPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListVirtualMachineScaleSetNetworkInterfacesPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListVirtualMachineScaleSetNetworkInterfacesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVirtualMachineScaleSetNetworkInterfacesPager not implemented")}
	}
	newListVirtualMachineScaleSetNetworkInterfacesPager := i.newListVirtualMachineScaleSetNetworkInterfacesPager.get(req)
	if newListVirtualMachineScaleSetNetworkInterfacesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListVirtualMachineScaleSetNetworkInterfacesPager(resourceGroupNameParam, virtualMachineScaleSetNameParam, nil)
		newListVirtualMachineScaleSetNetworkInterfacesPager = &resp
		i.newListVirtualMachineScaleSetNetworkInterfacesPager.add(req, newListVirtualMachineScaleSetNetworkInterfacesPager)
		server.PagerResponderInjectNextLinks(newListVirtualMachineScaleSetNetworkInterfacesPager, req, func(page *armnetwork.InterfacesClientListVirtualMachineScaleSetNetworkInterfacesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVirtualMachineScaleSetNetworkInterfacesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListVirtualMachineScaleSetNetworkInterfacesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVirtualMachineScaleSetNetworkInterfacesPager) {
		i.newListVirtualMachineScaleSetNetworkInterfacesPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchNewListVirtualMachineScaleSetVMNetworkInterfacesPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListVirtualMachineScaleSetVMNetworkInterfacesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVirtualMachineScaleSetVMNetworkInterfacesPager not implemented")}
	}
	newListVirtualMachineScaleSetVMNetworkInterfacesPager := i.newListVirtualMachineScaleSetVMNetworkInterfacesPager.get(req)
	if newListVirtualMachineScaleSetVMNetworkInterfacesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualmachineIndex>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
		if err != nil {
			return nil, err
		}
		virtualmachineIndexParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualmachineIndex")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListVirtualMachineScaleSetVMNetworkInterfacesPager(resourceGroupNameParam, virtualMachineScaleSetNameParam, virtualmachineIndexParam, nil)
		newListVirtualMachineScaleSetVMNetworkInterfacesPager = &resp
		i.newListVirtualMachineScaleSetVMNetworkInterfacesPager.add(req, newListVirtualMachineScaleSetVMNetworkInterfacesPager)
		server.PagerResponderInjectNextLinks(newListVirtualMachineScaleSetVMNetworkInterfacesPager, req, func(page *armnetwork.InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVirtualMachineScaleSetVMNetworkInterfacesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListVirtualMachineScaleSetVMNetworkInterfacesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVirtualMachineScaleSetVMNetworkInterfacesPager) {
		i.newListVirtualMachineScaleSetVMNetworkInterfacesPager.remove(req)
	}
	return resp, nil
}

func (i *InterfacesServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if i.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.UpdateTags(req.Context(), resourceGroupNameParam, networkInterfaceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
